/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider.oauth;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyAuthenticator;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyValidationMode;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdAuthenticator;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import io.confluent.kafka.server.plugins.auth.oauth.JwtAuthenticatorConfig;
import io.confluent.kafka.util.ClientContext;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authentication.AdmissionController;
import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.Claims;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticator;
import io.confluent.security.config.ConfigurationException;
import io.confluent.security.policyapi.engine.PolicyEngine;
import io.confluent.security.policyapi.engine.TrustPolicyEngine;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import io.confluent.security.trustservice.store.data.IdentityProvider;
import io.confluent.security.util.SecurityContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.apache.kafka.common.security.oauthbearer.CommonExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.Contextable;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.PreTokenValidationExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.server.datapolicy.DefaultDataPolicyStore;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedOAuthBearerValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(EnhancedOAuthBearerValidatorCallbackHandler.class);
    private static final String AUTH_ERROR_MESSAGE = "Authentication failed";
    private AdmissionController admissionController;
    private BasePhysicalClusterMetadata<KafkaLogicalClusterMetadata> clusterMetadata;
    private SniValidationMode mode;
    private String networkIdValidationModeJaasConfigEntry;
    private DefaultDataPolicyValidationMode defaultDataPolicyValidationMode;
    private List<String> defaultDataPolicyDenyOrgIds;
    private String sessionUuid;
    private boolean enableFlatNetworkingVerification;
    private boolean requireCallingResourceIdentityForConfluentIssuer;
    static final String OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY = "providerId";
    private static final String OAUTH_IDENTITY_PROPERTY_KEY = "identity";
    private static final String OAUTH_ORGANIZATION_ID_PROPERTY_KEY = "organizationId";
    public static final String CALLING_RESOURCE_IDENTITY_CLAIM_KEY = "calling_resource_identity";
    private static final Map<String, String> DEFAULT_DATA_POLICY_INVALID_EXTENSIONS = new HashMap<String, String>();
    private boolean configured = false;
    private boolean enableOAuthUnionOfPools = false;
    private boolean enableOrgIdCheck = true;
    private static final AtomicLong REQ_COUNTER;
    public static final String METRIC_GROUP = "kafka.authn.oauthbearer";
    private static final Counter UNION_OF_POOLS_NULL_POOL_ID_METRIC;
    private static final Counter UNION_OF_POOLS_LIST_POOL_ID_METRIC;
    private static final Histogram UNION_OF_POOLS_PRE_TOKEN_VALIDATOR_LATENCY_METRIC;
    private static final Histogram UNION_OF_POOLS_EXTENSION_VALIDATOR_LATENCY_METRIC;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        boolean requireConfluentIssuer;
        JaasOptionsUtils.validateOAuthMechanismAndNonNullJaasConfig((String)saslMechanism, jaasConfigEntries);
        HashMap moduleOptions = new HashMap(jaasConfigEntries.get(0).getOptions());
        JwtAuthenticator jwtAuthenticator = JwtAuthenticatorConfig.newInstance(moduleOptions).generateConfig(configs);
        Object uuid = configs.get("broker.session.uuid");
        if (uuid == null || uuid.toString().isEmpty()) {
            throw new ConfigurationException("Broker session UUID must be set in the Kafka config!");
        }
        this.sessionUuid = uuid.toString();
        this.clusterMetadata = BasePhysicalClusterMetadata.getInstance((String)this.sessionUuid);
        if (this.clusterMetadata == null) {
            throw new ConfigurationException("Could not get a ClusterMetadata instance with broker session UUID " + String.valueOf(uuid));
        }
        if (this.clusterMetadata instanceof PhysicalClusterMetadata) {
            this.enableOrgIdCheck = false;
        }
        this.mode = SniValidationMode.fromString((String)moduleOptions.get("sni_host_name_validation_mode"));
        this.networkIdValidationModeJaasConfigEntry = (String)moduleOptions.get("traffic_network_id_validation_mode");
        String defaultDataPolicyValidationModeJaasConfigEntry = (String)moduleOptions.get("default_data_policy_validation_mode");
        this.defaultDataPolicyValidationMode = DefaultDataPolicyValidationMode.fromConfigs(() -> defaultDataPolicyValidationModeJaasConfigEntry);
        this.defaultDataPolicyDenyOrgIds = (List)configs.get("confluent.cluster.link.intranet.connectivity.denied.org.ids");
        this.admissionController = new AdmissionController((Authenticator)jwtAuthenticator, () -> {
            AuthStore store = Objects.requireNonNull(AuthStore.getInstance((String)this.sessionUuid));
            return store.trustCache();
        }, (PolicyEngine)new TrustPolicyEngine());
        this.enableFlatNetworkingVerification = configs.get("confluent.oauth.flat.networking.verification.enable") != null ? Boolean.parseBoolean(String.valueOf(configs.get("confluent.oauth.flat.networking.verification.enable"))) : false;
        boolean bl = requireConfluentIssuer = configs.get("confluent.require.confluent.issuer") != null ? Boolean.parseBoolean(String.valueOf(configs.get("confluent.require.confluent.issuer"))) : false;
        if (requireConfluentIssuer) {
            this.enableFlatNetworkingVerification = true;
        }
        this.requireCallingResourceIdentityForConfluentIssuer = configs.get("confluent.require.calling.resource.identity") != null ? Boolean.parseBoolean(String.valueOf(configs.get("confluent.require.calling.resource.identity"))) : false;
        this.enableOAuthUnionOfPools = ConfluentConfigs.getOAuthUnionOfPoolsEnable(configs);
        this.configured = true;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerValidatorCallback) {
                this.handleValidatorCallback((OAuthBearerValidatorCallback)callback);
                continue;
            }
            if (callback instanceof PreTokenValidationExtensionsValidatorCallback) {
                this.handlePreTokenValidationCallback((PreTokenValidationExtensionsValidatorCallback)callback);
                continue;
            }
            if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                this.handleExtensionsCallback((OAuthBearerExtensionsValidatorCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void close() {
    }

    private void handlePreTokenValidationCallback(PreTokenValidationExtensionsValidatorCallback callback) {
        long reqId = REQ_COUNTER.getAndIncrement();
        String logicalCluster = (String)callback.inputExtensions().map().get("logicalCluster");
        String identityPoolId = (String)callback.inputExtensions().map().get("identityPoolId");
        log.info("Negotiated properties - cluster: {}, poolId: {}. Req id: {}", new Object[]{logicalCluster, identityPoolId, reqId});
        if (!this.doesClusterExtensionExist((CommonExtensionsValidatorCallback)callback, logicalCluster)) {
            return;
        }
        if (identityPoolId != null && !identityPoolId.contains(",")) {
            TrustCache cache = Objects.requireNonNull(AuthStore.getInstance((String)this.sessionUuid).trustCache());
            IdentityPool pool = cache.identityPool(identityPoolId);
            if (pool == null) {
                AuthenticationException exe = new AuthenticationException(String.format("Token precheck failed - unknown Identity Pool %s.", identityPoolId), "IDENTITY_POOL_NOT_FOUND");
                this.handleExtensionError((CommonExtensionsValidatorCallback)callback, exe.getMessage(), "identityPoolId", exe.reasonCode());
                return;
            }
            callback.context().add("identityPoolId", (Object)pool.poolId());
            callback.context().add(OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY, (Object)pool.providerId());
            callback.context().add("jwksEndpoint", (Object)pool.jwksEndpoint());
            callback.context().add("req_id", (Object)reqId);
            log.info("Properties from IdentityPool object - poolId: {}, providerId: {}, jwksEndpoint: {}. Req id: {}", new Object[]{pool.poolId(), pool.providerId(), pool.jwksEndpoint(), reqId});
        } else if (this.enableOAuthUnionOfPools) {
            long startTime = System.currentTimeMillis();
            KafkaLogicalClusterMetadata metadata = (KafkaLogicalClusterMetadata)this.clusterMetadata.metadata(logicalCluster);
            if (Objects.isNull(metadata)) {
                String errorMessage = String.format("The logical cluster %s metadata was not found. Req id: %d", logicalCluster, callback.context().getReqId());
                this.handleExtensionError((CommonExtensionsValidatorCallback)callback, errorMessage, "logicalCluster", "CLUSTER_NOT_FOUND");
                return;
            }
            String orgResourceId = metadata.organizationId();
            callback.context().add("orgId", (Object)orgResourceId);
            callback.context().add("unionOfPools", (Object)true);
            callback.context().add("req_id", (Object)reqId);
            if (identityPoolId == null) {
                log.debug("Token precheck for union of pools OAuth with no pools passed");
            } else if (identityPoolId.contains(",")) {
                callback.context().add("identityPoolId", (Object)identityPoolId);
                List<String> poolIds = Arrays.asList(identityPoolId.split(","));
                this.validateProviders((CommonExtensionsValidatorCallback)callback, poolIds);
                log.debug("Token precheck for union of pools OAuth with list of pools: {}", poolIds);
            }
            UNION_OF_POOLS_PRE_TOKEN_VALIDATOR_LATENCY_METRIC.update(System.currentTimeMillis() - startTime);
        } else if (identityPoolId != null) {
            this.handleExtensionError((CommonExtensionsValidatorCallback)callback, String.format("Invalid format found for pool id extension: %s", identityPoolId), "identityPoolId", "IMPROPERLY_FORMATTED_IDENTITY_POOL_EXTENSION");
        }
    }

    private void handleValidatorCallback(OAuthBearerValidatorCallback callback) {
        try {
            String tokenValue = callback.tokenValue();
            if (tokenValue == null) {
                throw new AuthenticationException("Callback missing required token value", "TOKEN_VALUE_ABSENT");
            }
            OAuthBearerToken token = this.processToken(tokenValue, callback.context());
            boolean verifiedConfluentToken = false;
            if (token instanceof OAuthBearerJwsToken && this.isConfluentIssuer((OAuthBearerJwsToken)token)) {
                if (!this.checkAudClaim((OAuthBearerJwsToken)token, callback)) {
                    return;
                }
                verifiedConfluentToken = true;
            }
            if (this.enableFlatNetworkingVerification && !verifiedConfluentToken && this.defaultDataPolicyValidationMode == DefaultDataPolicyValidationMode.NONE) {
                if (token instanceof OAuthBearerJwsToken) {
                    log.info("Expected Confluent-issued token, actual issuer was: {}. Req id: {}", (Object)((OAuthBearerJwsToken)token).issuer(), (Object)this.getReqId((Contextable)callback));
                } else {
                    log.info("Expected Confluent-issued token, actual issuer was unknown. Req id: {}", (Object)this.getReqId((Contextable)callback));
                }
                callback.error("ISSUER_INVALID", null, null);
                return;
            }
            callback.token(token);
            log.debug("Successfully validated token. Req id: {}", (Object)this.getReqId((Contextable)callback));
        }
        catch (AuthenticationException e) {
            log.error(String.format("Failed to verify OAuth JWT token. Req id: %d", this.getReqId((Contextable)callback)), (Throwable)e);
            callback.error(e.reasonCode().equals("AUTHENTICATION_EXCEPTION_OCCURRED") ? AUTH_ERROR_MESSAGE : e.reasonCode(), null, null);
        }
    }

    private long getReqId(Contextable cbctx) {
        if (cbctx == null || cbctx.context() == null) {
            return -1L;
        }
        return cbctx.context().getReqId();
    }

    private void handleExtensionsCallback(OAuthBearerExtensionsValidatorCallback callback) {
        KafkaLogicalClusterMetadata metadata;
        OAuthBearerJwsToken token = (OAuthBearerJwsToken)callback.token();
        String logicalCluster = (String)callback.inputExtensions().map().get("logicalCluster");
        String identityPoolId = (String)callback.inputExtensions().map().get("identityPoolId");
        String sniHostName = (String)callback.inputExtensions().map().get("__confluent_sni_broker_host_name");
        String networkId = (String)callback.inputExtensions().map().get("__confluent_traffic_network_id");
        String trafficTypeName = (String)callback.inputExtensions().map().get("__confluent_ccloud_traffic_type");
        boolean usedUnionOfPools = callback.context().boolVal("unionOfPools", Boolean.valueOf(false));
        this.addIdentityInformation(identityPoolId, token.jwtClaims(), callback, usedUnionOfPools);
        if (!this.doesClusterExtensionExist((CommonExtensionsValidatorCallback)callback, logicalCluster)) {
            return;
        }
        try {
            metadata = this.checkClusterMetadataMatched(callback, token, logicalCluster);
            if (Objects.isNull(metadata)) {
                return;
            }
        }
        catch (IllegalStateException e) {
            this.reportErrorGettingMetadata(callback, e);
            return;
        }
        if (!this.networkIdMatches(callback, logicalCluster, networkId, trafficTypeName)) {
            return;
        }
        if (!this.checkSniHostNameMatched(callback, logicalCluster, sniHostName, this.mode)) {
            return;
        }
        if (this.isConfluentIssuer(token) && !this.checkLogicalClusterBelongToOrg(callback, token, metadata)) {
            return;
        }
        if (this.isConfluentIssuer(token) ? !this.checkCallingResourceIdentityForConfluentIssuer(token, callback) : !this.defaultDataPolicyAllowed(callback, logicalCluster)) {
            return;
        }
        if (usedUnionOfPools || identityPoolId != null) {
            log.debug("Start validate identity pool trust policy based on token claims: {}. Req id: {}", (Object)token.jwtClaims(), (Object)this.getReqId((Contextable)callback));
            try {
                if (usedUnionOfPools) {
                    long startTime = System.currentTimeMillis();
                    String identityProviderId = callback.context().strVal(OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY, null, true);
                    callback.addValidated("identityPoolId", this.admissionController.assumePrincipal(token.jwtClaims(), identityProviderId, identityPoolId, metadata.organizationId()));
                    callback.addValidated("identityPoolId", "OAuth-ClientCredentials");
                    UNION_OF_POOLS_EXTENSION_VALIDATOR_LATENCY_METRIC.update(System.currentTimeMillis() - startTime);
                } else {
                    callback.valid("identityPoolId", this.admissionController.assumePrincipal(token.jwtClaims(), identityPoolId, metadata.organizationId()));
                    callback.valid("identityPoolId", identityPoolId);
                }
            }
            catch (AuthenticationException e) {
                this.handleExtensionError((CommonExtensionsValidatorCallback)callback, e.getMessage(), "identityPoolId", e.reasonCode());
                return;
            }
            catch (IllegalArgumentException e) {
                this.handleExtensionError((CommonExtensionsValidatorCallback)callback, e.getMessage(), "identityPoolId", "FAILED_TO_READ_CLAIMS");
                return;
            }
        }
        callback.valid("logicalCluster", logicalCluster);
        log.debug("Successfully authenticated for user: {} (cluster: {}). Req id: {}", new Object[]{token.principalName(), logicalCluster, this.getReqId((Contextable)callback)});
    }

    private boolean checkAudClaim(OAuthBearerJwsToken token, OAuthBearerValidatorCallback callback) {
        if (token.jwtClaims().containsKey("aud")) {
            log.info("Expecting no aud claim got: {}. Req id: {}", token.jwtClaims().get("aud"), (Object)this.getReqId((Contextable)callback));
            callback.error("AUD_CLAIM_MISMATCH", null, null);
            return false;
        }
        return true;
    }

    private boolean checkCallingResourceIdentityForConfluentIssuer(OAuthBearerJwsToken token, OAuthBearerExtensionsValidatorCallback callback) {
        if (this.requireCallingResourceIdentityForConfluentIssuer && (token.jwtClaims().get(CALLING_RESOURCE_IDENTITY_CLAIM_KEY) == null || token.jwtClaims().get(CALLING_RESOURCE_IDENTITY_CLAIM_KEY).toString().isEmpty())) {
            String errorMessage = String.format("Expected %s claim, but none was found. Req id: %s", CALLING_RESOURCE_IDENTITY_CLAIM_KEY, this.getReqId((Contextable)callback));
            this.handleExtensionError((CommonExtensionsValidatorCallback)callback, errorMessage, CALLING_RESOURCE_IDENTITY_CLAIM_KEY, "CALLING_RESOURCE_IDENTITY_MISSING_OR_EMPTY");
            return false;
        }
        return true;
    }

    private boolean defaultDataPolicyAllowed(OAuthBearerExtensionsValidatorCallback callback, String logicalCluster) {
        if (!this.enableFlatNetworkingVerification || this.defaultDataPolicyValidationMode == DefaultDataPolicyValidationMode.NONE || !DefaultDataPolicyStore.getDefaultDataPolicyEnforcement((String)this.sessionUuid)) {
            return true;
        }
        KafkaLogicalClusterMetadata lkcMetadata = (KafkaLogicalClusterMetadata)this.clusterMetadata.metadata(logicalCluster);
        if (lkcMetadata == null) {
            log.debug("No lkc metadata for " + logicalCluster);
            return false;
        }
        String organizationId = (String)callback.inputExtensions().map().get("__confluent_cloud_organization_id");
        SaslInternalConfigs.NetworkType networkType = SaslInternalConfigs.NetworkType.fromString((String)((String)callback.inputExtensions().map().get("__confluent_traffic_network_type")));
        Boolean hasSslPeerCertificate = Boolean.parseBoolean((String)callback.inputExtensions().map().get("__confluent_has_ssl_peer_certificate"));
        boolean isOrgDenied = this.defaultDataPolicyDenyOrgIds != null && this.defaultDataPolicyDenyOrgIds.contains(lkcMetadata.organizationId());
        DefaultDataPolicyAuthenticator defaultDataPolicyAuthenticator = new DefaultDataPolicyAuthenticator(this.defaultDataPolicyValidationMode, isOrgDenied, (LogicalClusterMetadata)lkcMetadata, errorMessage -> this.handleExtensionErrors((CommonExtensionsValidatorCallback)callback, (String)errorMessage, DEFAULT_DATA_POLICY_INVALID_EXTENSIONS));
        DefaultDataPolicyContext policyContext = new DefaultDataPolicyContext.Builder(organizationId, networkType, hasSslPeerCertificate, DefaultDataPolicyStore.crossOrgDeniedSensor((String)this.sessionUuid)).build();
        return defaultDataPolicyAuthenticator.authenticate(policyContext);
    }

    private boolean isConfluentIssuer(OAuthBearerJwsToken token) {
        return token.issuer() != null && "Confluent".equalsIgnoreCase(token.issuer().trim());
    }

    private boolean checkLogicalClusterBelongToOrg(OAuthBearerExtensionsValidatorCallback callback, OAuthBearerJwsToken token, KafkaLogicalClusterMetadata metadata) {
        if (!this.enableOrgIdCheck) {
            return true;
        }
        String orgResourceId = (String)token.jwtClaims().get("orgResourceId");
        if (orgResourceId != null && orgResourceId.equals(metadata.organizationId())) {
            return true;
        }
        String errorMessage = String.format("The principal %s's logical cluster %s does not belong to the org in the token (%s). Req id: %d", token.principalName(), metadata.logicalClusterId(), orgResourceId, this.getReqId((Contextable)callback));
        this.handleExtensionError((CommonExtensionsValidatorCallback)callback, errorMessage, "logicalCluster", "ORG_ID_CLUSTER_ID_MISMATCH");
        return false;
    }

    private void addIdentityInformation(String identityPoolId, Map<String, Object> claims, OAuthBearerExtensionsValidatorCallback callback, boolean usedUnionOfPools) {
        if (usedUnionOfPools) {
            if (identityPoolId == null) {
                UNION_OF_POOLS_NULL_POOL_ID_METRIC.inc();
            } else if (identityPoolId.contains(",")) {
                UNION_OF_POOLS_LIST_POOL_ID_METRIC.inc();
            }
            AuthStore store = Objects.requireNonNull(AuthStore.getInstance((String)this.sessionUuid));
            callback.addValidated("identityPoolId", "OAuth-ClientCredentials");
            String providerId = callback.context().strVal(OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY, null, true);
            callback.data(OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY, providerId);
            IdentityProvider provider = store.trustCache().identityProvider(providerId);
            Object subClaim = claims.getOrDefault(provider.subjectClaim(), null);
            callback.data(OAUTH_IDENTITY_PROPERTY_KEY, subClaim != null ? String.valueOf(subClaim) : null);
            callback.data(OAUTH_ORGANIZATION_ID_PROPERTY_KEY, provider.orgId());
        } else if (identityPoolId != null) {
            AuthStore store = Objects.requireNonNull(AuthStore.getInstance((String)this.sessionUuid));
            callback.valid("identityPoolId", identityPoolId);
            IdentityPool pool = store.trustCache().identityPool(identityPoolId);
            callback.data(OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY, (String)(pool.providerId() != null && pool.providerId().trim().isEmpty() ? null : pool.providerId()));
            Object subClaim = claims.getOrDefault(pool.subjectClaim(), null);
            callback.data(OAUTH_IDENTITY_PROPERTY_KEY, subClaim != null ? String.valueOf(subClaim) : null);
            callback.data(OAUTH_ORGANIZATION_ID_PROPERTY_KEY, pool.orgId());
        }
    }

    private void reportErrorGettingMetadata(OAuthBearerExtensionsValidatorCallback callback, IllegalStateException e) {
        log.error(String.format("Could not get physical cluster metadata to validate the token. Req id: %d", this.getReqId((Contextable)callback)), (Throwable)e);
        callback.errorMessage("Could not get cluster metadata to validate the token");
        callback.error("logicalCluster", AUTH_ERROR_MESSAGE);
    }

    private KafkaLogicalClusterMetadata checkClusterMetadataMatched(OAuthBearerExtensionsValidatorCallback callback, OAuthBearerJwsToken token, String logicalCluster) {
        KafkaLogicalClusterMetadata metadata = (KafkaLogicalClusterMetadata)this.clusterMetadata.metadata(logicalCluster);
        if (Objects.isNull(metadata)) {
            if (this.clusterMetadata.logicalClusterIdsIncludingStale().contains(logicalCluster)) {
                log.info("Failing OAuth authentication because the metadata for the logical cluster {} is stale. Req id: {}", (Object)logicalCluster, (Object)this.getReqId((Contextable)callback));
            }
            String errorMessage = String.format("The principal %s's logical cluster %s is not hosted on this broker. Req id: %d", token.principalName(), logicalCluster, this.getReqId((Contextable)callback));
            this.handleExtensionError((CommonExtensionsValidatorCallback)callback, errorMessage, "logicalCluster", "CLUSTER_NOT_FOUND");
            return null;
        }
        return metadata;
    }

    private boolean doesClusterExtensionExist(CommonExtensionsValidatorCallback callback, String logicalCluster) {
        if (logicalCluster == null || logicalCluster.isEmpty()) {
            String errorMessage = "The logical cluster extension is missing or is empty. Req id: " + this.getReqId((Contextable)callback);
            this.handleExtensionError(callback, errorMessage, "logicalCluster", "CLUSTER_ID_MISSING_OR_EMPTY");
            return false;
        }
        return true;
    }

    protected boolean checkSniHostNameMatched(OAuthBearerExtensionsValidatorCallback callback, String logicalClusterId, String sniHostName, SniValidationMode sniValidationMode) {
        Optional<PathAwareSniHostName> sniHostNameOptional = sniHostName == null ? Optional.empty() : Optional.of(new PathAwareSniHostName(sniHostName));
        Optional<String> sniClusterId = sniHostNameOptional.map(PathAwareSniHostName::logicalClusterId);
        if (sniValidationMode.sniHostNameMatches(logicalClusterId, sniClusterId, sniHostNameOptional)) {
            return true;
        }
        String errorMessage = String.format("The SNI cluster Id: %s doesn't match with logical cluster extension: %s. Req id: %d", sniClusterId.orElse("<empty>"), logicalClusterId, this.getReqId((Contextable)callback));
        this.handleExtensionError((CommonExtensionsValidatorCallback)callback, errorMessage, "__confluent_sni_broker_host_name", "SNI_ID_CLUSTER_ID_MISMATCH");
        return false;
    }

    private boolean networkIdMatches(OAuthBearerExtensionsValidatorCallback callback, String logicalClusterId, String networkId, String trafficTypeName) {
        TrafficNetworkIdRoutes networkIdRoutes = TrafficNetworkIdRoutesStore.getRoutes((String)this.sessionUuid);
        CCloudTrafficType trafficType = trafficTypeName != null ? CCloudTrafficType.valueOf((String)trafficTypeName) : null;
        TrafficNetworkIdValidationMode networkIdValidationMode = TrafficNetworkIdValidationMode.fromConfigs(trafficType, () -> this.networkIdValidationModeJaasConfigEntry);
        TrafficNetworkIdAuthenticator networkIdAuthenticator = new TrafficNetworkIdAuthenticator(networkIdRoutes, networkIdValidationMode, errorMessage -> this.handleExtensionError((CommonExtensionsValidatorCallback)callback, (String)errorMessage, "__confluent_traffic_network_id", "NETWORK_ID_DISALLOWED"));
        return networkIdAuthenticator.authenticate(Optional.ofNullable(networkId), logicalClusterId);
    }

    private void validateProviders(CommonExtensionsValidatorCallback callback, List<String> poolIds) {
        TrustCache cache = Objects.requireNonNull(AuthStore.getInstance((String)this.sessionUuid).trustCache());
        String providerId = null;
        for (String poolId : poolIds) {
            IdentityPool pool = cache.identityPool(poolId);
            if (pool == null) {
                this.handleExtensionError(callback, "List of pools provided in sasl extension contains pool id that doesn't exist", "identityPoolId", "INVALID_POOL_ID");
                continue;
            }
            if (providerId == null) {
                providerId = pool.providerId();
                continue;
            }
            if (providerId.equals(pool.providerId())) continue;
            this.handleExtensionError(callback, "List of pools provided in sasl extension contains multiple providers", "identityPoolId", "LIST_OF_POOLS_HAS_MULTIPLE_PROVIDERS");
        }
    }

    private void handleExtensionError(CommonExtensionsValidatorCallback callback, String errorMessage, String invalidExtensionName, String reasonCode) {
        log.info(errorMessage);
        callback.errorMessage(errorMessage);
        if (reasonCode == null || reasonCode.trim().equals("") || reasonCode.equals("AUTHENTICATION_EXCEPTION_OCCURRED")) {
            reasonCode = AUTH_ERROR_MESSAGE;
        }
        callback.error(invalidExtensionName, reasonCode);
    }

    private void handleExtensionErrors(CommonExtensionsValidatorCallback callback, String errorMessage, Map<String, String> invalidExtensionNameAndReasonCode) {
        log.trace(errorMessage);
        callback.errorMessage(errorMessage);
        callback.errors(invalidExtensionNameAndReasonCode);
    }

    OAuthBearerToken processToken(String jws, ClientContext context) throws AuthenticationException {
        log.info("Using context {} for authentication.", (Object)context.getContextMap());
        SecurityContext callbackContext = SecurityContext.fromMap((Map)context.getContextMap());
        Claims claims = this.admissionController.authenticate(new BearerCredential(jws), callbackContext);
        String orgClaim = (String)claims.claimValue("orgResourceId", String.class);
        Set<Object> scope = orgClaim != null ? Collections.singleton(orgClaim) : Collections.emptySet();
        String callbackProviderid = callbackContext.strVal(OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY, null, true);
        if (callbackProviderid != null) {
            context.add(OAUTH_IDENTITY_PROVIDER_ID_PROPERTY_KEY, (Object)callbackProviderid);
        }
        return new OAuthBearerJwsToken(jws, scope, claims.expiresOn(), claims.subject(), Long.valueOf(claims.issuedAt()), claims.asMap(), claims.issuer());
    }

    static {
        DEFAULT_DATA_POLICY_INVALID_EXTENSIONS.put("__confluent_cloud_organization_id", "DATA_POLICY_DISALLOWED");
        DEFAULT_DATA_POLICY_INVALID_EXTENSIONS.put("__confluent_traffic_network_type", "DATA_POLICY_DISALLOWED");
        DEFAULT_DATA_POLICY_INVALID_EXTENSIONS.put("__confluent_has_ssl_peer_certificate", "DATA_POLICY_DISALLOWED");
        REQ_COUNTER = new AtomicLong(1L);
        UNION_OF_POOLS_NULL_POOL_ID_METRIC = KafkaYammerMetrics.defaultRegistry().newCounter(new MetricName(METRIC_GROUP, EnhancedOAuthBearerValidatorCallbackHandler.class.getSimpleName(), "union-of-pools-null-pool-id-processed-count"));
        UNION_OF_POOLS_LIST_POOL_ID_METRIC = KafkaYammerMetrics.defaultRegistry().newCounter(new MetricName(METRIC_GROUP, EnhancedOAuthBearerValidatorCallbackHandler.class.getSimpleName(), "union-of-pools-list-pool-id-processed-count"));
        UNION_OF_POOLS_PRE_TOKEN_VALIDATOR_LATENCY_METRIC = KafkaYammerMetrics.defaultRegistry().newHistogram(new MetricName(METRIC_GROUP, EnhancedOAuthBearerValidatorCallbackHandler.class.getSimpleName(), "union-of-pools-pre-token-validation-latency"), true);
        UNION_OF_POOLS_EXTENSION_VALIDATOR_LATENCY_METRIC = KafkaYammerMetrics.defaultRegistry().newHistogram(new MetricName(METRIC_GROUP, EnhancedOAuthBearerValidatorCallbackHandler.class.getSimpleName(), "union-of-pools-extension-validation-latency"), true);
    }
}

