/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.FailedAuthSensors;
import io.confluent.kafka.multitenant.metrics.IpFailedAuthenticationByIpSensorBuilder;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IpFailedAuthenticationSensorsTest {
    private MockTime time = new MockTime();
    private TenantMetricsTestUtils utils;
    private FailedAuthSensors sensors;
    private Metrics metrics;
    private String ip1 = "127.0.0.1";
    private MetricsBuilderContext context;

    @BeforeEach
    public void setUp() throws UnknownHostException {
        this.metrics = new Metrics((Time)this.time);
        InetAddress clientAddress = InetAddress.getByName(this.ip1);
        this.context = new TenantMetrics.IpMetricsContext(clientAddress);
        this.utils = new TenantMetricsTestUtils(this.metrics);
        this.sensors = new IpFailedAuthenticationByIpSensorBuilder(this.metrics, clientAddress).build();
    }

    @Test
    public void testRecordFailedAuth() {
        for (int i = 0; i < 5; ++i) {
            this.sensors.recordFailedAuthentication();
            Assertions.assertEquals((double)((double)i + 1.0), (double)((Double)this.utils.metric("failed-authentication-by-ip-total").metricValue()), (double)0.0);
        }
        this.utils.verifyTenantMetrics(this.context, TenantMetricsTestUtils.IP_FAILED_AUTHENTICATION_METRICS);
    }

    @Test
    public void testFailedAuthSensorExpires() {
        this.sensors.recordFailedAuthentication();
        this.time.sleep(Duration.ofSeconds(FailedAuthSensors.FailedAuthSensorCreator.FAILED_AUTH_EXPIRY_SECONDS).toMillis() + 1L);
        Assertions.assertTrue((boolean)this.sensors.failedAuthRate.hasExpired());
    }
}

