/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.server.plugins.policy.TopicPolicyConfig;
import java.util.HashMap;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicPolicyConfigTest {
    private static final String EMPTY = "";
    private static final String NONE = "none";
    private static final String UNKNOWN_POLICY = "unknown_policy";
    private static final String COMPACT_DELETE = "compact,delete";
    private static final String DELETE_COMPACT = "delete,compact";

    @Test
    public void testAllowedCleanupPolicies() {
        HashMap<String, String> clientConfigs = new HashMap<String, String>();
        clientConfigs.put("confluent.plugins.topic.policy.replication.factor", "3");
        TopicPolicyConfig config = new TopicPolicyConfig(clientConfigs);
        this.cleanupPolicyAllowed(config, Set.of("delete"), Set.of("compact", COMPACT_DELETE, NONE, UNKNOWN_POLICY, EMPTY, "compact,unknown_policy"));
        clientConfigs.put("confluent.plugins.topic.policy.cleanup.policy.allowed", String.join((CharSequence)";", EMPTY, NONE, "compact", "delete", COMPACT_DELETE));
        config = new TopicPolicyConfig(clientConfigs);
        this.cleanupPolicyAllowed(config, Set.of("compact", "delete", COMPACT_DELETE, DELETE_COMPACT, NONE, EMPTY), Set.of(UNKNOWN_POLICY));
        clientConfigs.put("confluent.plugins.topic.policy.cleanup.policy.allowed", "CoMpAcT;DELETE");
        config = new TopicPolicyConfig(clientConfigs);
        this.cleanupPolicyAllowed(config, Set.of("compact", "delete"), Set.of(COMPACT_DELETE, NONE, EMPTY, UNKNOWN_POLICY));
        clientConfigs.put("confluent.plugins.topic.policy.cleanup.policy.allowed", DELETE_COMPACT);
        config = new TopicPolicyConfig(clientConfigs);
        this.cleanupPolicyAllowed(config, Set.of(COMPACT_DELETE, DELETE_COMPACT), Set.of("compact", "delete", NONE, UNKNOWN_POLICY, EMPTY));
        clientConfigs.put("confluent.plugins.topic.policy.cleanup.policy.allowed", "delete,compact;delete");
        config = new TopicPolicyConfig(clientConfigs);
        this.cleanupPolicyAllowed(config, Set.of(COMPACT_DELETE, DELETE_COMPACT, "delete"), Set.of("compact", NONE, UNKNOWN_POLICY, EMPTY));
        clientConfigs.put("confluent.plugins.topic.policy.cleanup.policy.allowed", "DELETE");
        config = new TopicPolicyConfig(clientConfigs);
        this.cleanupPolicyAllowed(config, Set.of("delete"), Set.of(COMPACT_DELETE, DELETE_COMPACT, "compact", NONE, UNKNOWN_POLICY, EMPTY));
        clientConfigs.put("confluent.plugins.topic.policy.cleanup.policy.allowed", String.join((CharSequence)";", "compact", "delete", COMPACT_DELETE));
        config = new TopicPolicyConfig(clientConfigs);
        this.cleanupPolicyAllowed(config, Set.of("compact", "delete", COMPACT_DELETE, DELETE_COMPACT), Set.of(NONE, UNKNOWN_POLICY, EMPTY, "compact,unknown_policy"));
    }

    private void cleanupPolicyAllowed(TopicPolicyConfig config, Set<String> expectAllowed, Set<String> expectNotAllowed) {
        expectAllowed.forEach(policy -> Assertions.assertTrue((boolean)config.cleanupPolicyAllowed(policy)));
        expectNotAllowed.forEach(policy -> Assertions.assertFalse((boolean)config.cleanupPolicyAllowed(policy)));
    }
}

