/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.mtls;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import kafka.server.BrokerSession;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.security.mtls.MTlsConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMTlsConnectionManager
implements MTlsConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMTlsConnectionManager.class);
    private String sessionUuid;
    private BrokerSession session;

    public void configure(Map<String, ?> configs) {
        Object uuid = configs.get("broker.session.uuid");
        if (uuid == null || uuid.toString().isEmpty()) {
            throw new ConfigException("Broker session UUID must be set in the Kafka config!");
        }
        this.sessionUuid = uuid.toString();
        this.session = BrokerSession.session((String)this.sessionUuid);
    }

    public void closeConnections(PublicCredential credential) {
        if (this.session != null) {
            LOG.trace("Removing credential {} for broker session {}", (Object)credential, (Object)this.sessionUuid);
            try {
                this.session.handleCredentialDelete(credential);
            }
            catch (Exception e) {
                LOG.warn("Failed to remove credential {} for broker session {}", new Object[]{credential, this.sessionUuid, e});
            }
        } else {
            LOG.warn("Ignoring credential {} because broker session {} is not available.", (Object)credential, (Object)this.sessionUuid);
        }
    }

    @VisibleForTesting
    BrokerSession getSession() {
        return this.session;
    }
}

