/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import io.confluent.kafka.link.MultiTenantAclBindingFilterTransformer;
import kafka.server.link.ClusterLinkManager;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;

public class MultiTenantAclBindingFilterTransformerTest {
    private MultiTenantAclBindingFilterTransformer transformer;
    private String tenantPrefix = "tenantPrefix_";
    private String user = "user";
    private String principal = "User:" + this.user;
    private String host = "host";
    private AclOperation aclOperation = AclOperation.ALL;
    private AclPermissionType aclPermissionType = AclPermissionType.ALLOW;
    private ResourceType resourceType = ResourceType.TOPIC;
    private String resourceName = "resourceName";
    private PatternType patternType = PatternType.LITERAL;

    @BeforeEach
    public void setUp() {
        this.transformer = new MultiTenantAclBindingFilterTransformer();
        HashMap configs = new HashMap();
        configs = (Map)configs.updated((Object)ClusterLinkManager.LocalTenantPrefixProp(), (Object)this.tenantPrefix);
        this.transformer.configure((Map)configs);
    }

    @Test
    public void testPrincipals() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(this.resourceType, this.resourceName, this.patternType);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        Assertions.assertEquals((Object)("TenantUser:" + this.tenantPrefix + this.user), (Object)output.entryFilter().principal());
    }

    @Test
    public void testGroupPrefixes() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.GROUP, this.resourceName, PatternType.LITERAL);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)(this.tenantPrefix + this.resourceName), (Object)outputFilter.name());
    }

    @Test
    public void testTopicAndAny() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, this.resourceName, PatternType.ANY);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)(this.tenantPrefix + this.resourceName), (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.ANY, (Object)outputFilter.patternType());
    }

    @Test
    public void testTopicAndPrefix() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, this.resourceName, PatternType.PREFIXED);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)(this.tenantPrefix + this.resourceName), (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.PREFIXED, (Object)outputFilter.patternType());
    }

    @Test
    public void testTopicAndLiteral() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, this.resourceName, PatternType.LITERAL);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)(this.tenantPrefix + this.resourceName), (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.LITERAL, (Object)outputFilter.patternType());
    }

    @Test
    public void testTopicWildCard() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, "*", PatternType.LITERAL);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)this.tenantPrefix, (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.PREFIXED, (Object)outputFilter.patternType());
    }

    @Test
    public void testTopicAllTenantOnly() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, this.resourceName, PatternType.MATCH);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)(this.tenantPrefix + this.resourceName), (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.CONFLUENT_ONLY_TENANT_MATCH, (Object)outputFilter.patternType());
    }

    @Test
    public void testTopicNullPatternLiteral() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.LITERAL);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)this.tenantPrefix, (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.CONFLUENT_ALL_TENANT_LITERAL, (Object)outputFilter.patternType());
    }

    @Test
    public void testTopicNullPatternPrefixes() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.PREFIXED);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)this.tenantPrefix, (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.CONFLUENT_ALL_TENANT_PREFIXED, (Object)outputFilter.patternType());
    }

    @Test
    public void testTopicNullPatternAny() {
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.principal, this.host, this.aclOperation, this.aclPermissionType);
        ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.ANY);
        AclBindingFilter input = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
        AclBindingFilter output = this.transformer.transform(input);
        ResourcePatternFilter outputFilter = output.patternFilter();
        Assertions.assertEquals((Object)this.tenantPrefix, (Object)outputFilter.name());
        Assertions.assertEquals((Object)PatternType.CONFLUENT_ALL_TENANT_ANY, (Object)outputFilter.patternType());
    }
}

