/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.PartitionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.PartitionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PartitionSensorsTest {
    private MockTime time = new MockTime();
    private Metrics metrics;

    @BeforeEach
    public void setUp() {
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.SECONDS);
        this.metrics = new Metrics(config, (Time)this.time);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.metrics.close();
    }

    private static TenantMetrics.MetricsRequestContext createProduceContext(MultiTenantPrincipal principal) {
        return new TenantMetrics.MetricsRequestContext(principal, "client-1", ApiKeys.PRODUCE);
    }

    @Test
    public void testThroughputWithMultipleClientIds() {
        int i;
        String clientId1 = "producer-1";
        String clientId2 = "producer-2";
        String tenant = "tenantA";
        String topic = "tenantA_topic-1";
        TenantMetrics.MetricsRequestContext context1 = new TenantMetrics.MetricsRequestContext(new MultiTenantPrincipal("userA", new TenantMetadata(tenant, tenant)), clientId1, ApiKeys.PRODUCE);
        PartitionSensors partitionSensors1 = new PartitionSensorBuilder(this.metrics, context1).build();
        TenantMetrics.MetricsRequestContext context2 = new TenantMetrics.MetricsRequestContext(new MultiTenantPrincipal("userA", new TenantMetadata(tenant, tenant)), clientId2, ApiKeys.PRODUCE);
        PartitionSensors partitionSensors2 = new PartitionSensorBuilder(this.metrics, context2).build();
        for (i = 0; i < 10; ++i) {
            partitionSensors1.recordStatsIn(new TopicPartition(topic, i), (long)(1000 * i), (long)(100 * i), this.time.milliseconds());
        }
        for (i = 0; i < 10; ++i) {
            partitionSensors2.recordStatsIn(new TopicPartition(topic, i), (long)(2000 * i), (long)(200 * i), this.time.milliseconds());
        }
        for (i = 0; i < 10; ++i) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tenant", tenant);
            tags.put("client-id", clientId1);
            tags.put("topic", topic);
            tags.put("partition", Integer.toString(i));
            tags.put("io-confluent-jmx-ignore", "");
            KafkaMetric client1BytesIn = this.metric("partition-bytes-in-total", tags);
            KafkaMetric client1RecordsIn = this.metric("partition-records-in-total", tags);
            tags.put("client-id", clientId2);
            KafkaMetric client2BytesIn = this.metric("partition-bytes-in-total", tags);
            KafkaMetric client2RecordsIn = this.metric("partition-records-in-total", tags);
            Assertions.assertEquals((Object)((double)i * 1000.0), (Object)client1BytesIn.metricValue());
            Assertions.assertEquals((Object)((double)i * 2000.0), (Object)client2BytesIn.metricValue());
            Assertions.assertEquals((Object)((double)i * 100.0), (Object)client1RecordsIn.metricValue());
            Assertions.assertEquals((Object)((double)i * 200.0), (Object)client2RecordsIn.metricValue());
        }
    }

    @Test
    public void testExpiredPartitionSensorsReinitialized() {
        String tenant = "tenant";
        String topic = "tenant_topic-1";
        TopicPartition tp = new TopicPartition(topic, 0);
        TenantMetrics.MetricsRequestContext context = PartitionSensorsTest.createProduceContext(new MultiTenantPrincipal("userA", new TenantMetadata(tenant, tenant)));
        PartitionSensorBuilder builder = new PartitionSensorBuilder(this.metrics, context);
        PartitionSensors partitionSensors = builder.build();
        partitionSensors.recordStatsIn(tp, 1000L, 100L, this.time.milliseconds());
        partitionSensors.recordStatsOut(tp, 500L, 50L, this.time.milliseconds());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tenant", tenant);
        tags.put("client-id", "client-1");
        tags.put("topic", topic);
        tags.put("partition", Integer.toString(0));
        tags.put("io-confluent-jmx-ignore", "");
        Assertions.assertEquals((Object)1000.0, (Object)this.metric("partition-bytes-in-total", tags).metricValue());
        Assertions.assertEquals((Object)100.0, (Object)this.metric("partition-records-in-total", tags).metricValue());
        Assertions.assertEquals((Object)500.0, (Object)this.metric("partition-bytes-out-total", tags).metricValue());
        Assertions.assertEquals((Object)50.0, (Object)this.metric("partition-records-out-total", tags).metricValue());
        this.time.sleep(Duration.ofSeconds(PartitionSensorBuilder.PARTITION_SENSOR_EXPIRY_SECONDS).toMillis() + 1L);
        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
        sensors.add(partitionSensors.in.partitionDetailSensors((TopicPartition)tp, (Metrics)this.metrics).bytesSensor);
        sensors.add(partitionSensors.in.partitionDetailSensors((TopicPartition)tp, (Metrics)this.metrics).recordsSensor);
        sensors.add(partitionSensors.out.partitionDetailSensors((TopicPartition)tp, (Metrics)this.metrics).bytesSensor);
        sensors.add(partitionSensors.out.partitionDetailSensors((TopicPartition)tp, (Metrics)this.metrics).recordsSensor);
        for (Sensor sensor : sensors) {
            Assertions.assertTrue((boolean)sensor.hasExpired());
            this.metrics.removeSensor(sensor.name());
        }
        partitionSensors.recordStatsIn(tp, 300L, 30L, this.time.milliseconds());
        partitionSensors.recordStatsOut(tp, 600L, 60L, this.time.milliseconds());
        Assertions.assertEquals((Object)300.0, (Object)this.metric("partition-bytes-in-total", tags).metricValue());
        Assertions.assertEquals((Object)30.0, (Object)this.metric("partition-records-in-total", tags).metricValue());
        Assertions.assertEquals((Object)600.0, (Object)this.metric("partition-bytes-out-total", tags).metricValue());
        Assertions.assertEquals((Object)60.0, (Object)this.metric("partition-records-out-total", tags).metricValue());
    }

    private KafkaMetric metric(String name, Map<String, String> tags) {
        return (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName(name, "tenant-metrics", tags));
    }
}

