/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import kafka.security.authorizer.AuthorizerTest;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.metrics.PluginMetrics;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Tag;

@Tag(value="bazel:cpu:2")
public class ConfluentServerAuthorizerTest
extends AuthorizerTest {
    private static final ConfluentAuthorizerServerInfo SERVER_INFO = KafkaTestUtils.serverInfo("clusterA", SecurityProtocol.SSL);

    public Properties properties() {
        Properties props = super.properties();
        props.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name());
        return props;
    }

    @AfterEach
    public void tearDown() {
        super.tearDown();
        KafkaTestUtils.verifyThreadCleanup();
    }

    public Authorizer createAuthorizer() {
        ConfluentServerAuthorizer testAuthorizer = this.createTestAuthorizer();
        return this.standardAuthorizer(testAuthorizer);
    }

    public void configureAuthorizer(Authorizer authorizer, Map<String, Object> configs, PluginMetrics pluginMetrics) {
        authorizer.configure(configs);
        this.initializeStandardAuthorizer((StandardAuthorizer)authorizer, (AuthorizerServerInfo)SERVER_INFO);
    }

    protected ConfluentServerAuthorizer createTestAuthorizer() {
        return new TestAuthorizer();
    }

    protected StandardAuthorizer standardAuthorizer(final ConfluentServerAuthorizer authorizer) {
        return new StandardAuthorizer(this){
            final ConfluentServerAuthorizer authorizer1;
            final /* synthetic */ ConfluentServerAuthorizerTest this$0;
            {
                this.this$0 = this$0;
                this.authorizer1 = authorizer;
            }

            public void configure(Map<String, ?> javaConfigs) {
                authorizer.configure(javaConfigs);
            }

            public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return authorizer.start(serverInfo);
            }

            public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
                return authorizer.authorize(requestContext, actions);
            }

            public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
                return authorizer.createAcls(requestContext, aclBindings);
            }

            public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
                return authorizer.deleteAcls(requestContext, aclBindingFilters);
            }

            public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters, Optional<String> clusterId, AclState aclState) {
                return authorizer.deleteAcls(requestContext, aclBindingFilters, clusterId, aclState);
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return authorizer.acls(filter);
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter, AclState aclState) {
                return authorizer.acls(filter, aclState);
            }

            public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
                return authorizer.authorizeByResourceType(requestContext, op, resourceType);
            }

            public int aclCount() {
                return authorizer.aclCount();
            }

            public void setAclMutator(AclMutator aclMutator) {
                authorizer.setAclMutator(aclMutator);
            }

            public void completeInitialLoad() {
                authorizer.completeInitialLoad();
            }

            public void completeInitialLoad(Exception e) {
                authorizer.completeInitialLoad(e);
            }

            public void applyAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> aclChanges) {
                authorizer.applyAclChanges(aclChanges);
            }

            public void close() {
                try {
                    authorizer.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static class TestAuthorizer
    extends ConfluentServerAuthorizer {
        private TestAuthorizer() {
        }

        public void configure(Map<String, ?> configs) {
            super.configure(configs);
            this.configureServerInfo(SERVER_INFO);
        }
    }
}

