/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.common.multitenant.oauth.OauthMayActClaim;
import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.CallingResourceIdentityType;
import io.confluent.kafka.multitenant.CallingResourceIdentityTypeExtractor;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantSaslServer;
import io.confluent.kafka.multitenant.SpiffeIdPrincipalExtractor;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.kafka.security.oauthbearer.OAuthBearerJwsToken;
import io.confluent.kafka.server.plugins.auth.DefaultUserMetaDataStore;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.mtls.CertIdentityPool;
import io.confluent.security.auth.mtls.CertIdentityPoolExternalIdentifier;
import io.confluent.security.auth.store.data.CaCertificatesKey;
import io.confluent.security.mtls.CertificateMetadata;
import io.confluent.security.mtls.CertificateUtils;
import io.confluent.security.trustservice.store.data.IdentityPool;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.DefaultPrincipalData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.IdentityMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTenantPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantPrincipalBuilder.class);
    private static final String CONFLUENT_ISSUER = "Confluent";
    private static final String OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY = "OAUTHBEARER.token";
    public static final String CCLOUD_INTERNAL_USER = "0";
    public static final String METRIC_GROUP = "kafka.multitenant";
    private static final String RESOURCE_ID_SERVICE_ACCOUNT_PREFIX = "sa-";
    private static final MetricName ORG_PROPS_METRIC_NAME = KafkaYammerMetrics.getMetricName((String)"kafka.multitenant", (String)MultiTenantPrincipalBuilder.class.getSimpleName(), (String)"org-props-missing-rate");
    private static final Meter ORG_PROPS_MISSING_METER = KafkaYammerMetrics.defaultRegistry().newMeter(ORG_PROPS_METRIC_NAME, "org-props-missing", TimeUnit.SECONDS);
    private static final Map<String, Meter> AUTHENTICATION_SUBTYPE_REQUEST_METER = new HashMap<String, Meter>();
    private static final String ORG0_UUID = "00000000-0000-0000-0000-000000000000";
    private BasePhysicalClusterMetadata<?> physicalClusterMetadata;
    private DefaultUserMetaDataStore userMetaDataStore;
    private final DefaultKafkaPrincipalBuilder defaultKafkaPrincipalBuilder = new DefaultKafkaPrincipalBuilder(null, null);
    private AuthStore store;
    private String brokerUuid;
    private final SpiffeIdPrincipalExtractor spiffeIdPrincipalExtractor = new SpiffeIdPrincipalExtractor();
    private final CallingResourceIdentityTypeExtractor callingResourceIdentityTypeExtractor = new CallingResourceIdentityTypeExtractor();
    private String confluentSpireIssuerSuffix;
    private boolean mTlsBuildClientCertChain = false;

    public void configure(Map<String, ?> configs) {
        this.physicalClusterMetadata = BasePhysicalClusterMetadata.getInstance((String)AuthUtils.getBrokerSessionUuid(configs));
        this.brokerUuid = AuthUtils.getBrokerSessionUuid(configs);
        this.store = AuthStore.getInstance((String)this.brokerUuid);
        this.spiffeIdPrincipalExtractor.configure(configs);
        this.callingResourceIdentityTypeExtractor.configure(configs);
        this.confluentSpireIssuerSuffix = (String)configs.get("authenticator.jwt.spire.issuers.suffix");
        if (this.confluentSpireIssuerSuffix == null || this.confluentSpireIssuerSuffix.isEmpty()) {
            this.confluentSpireIssuerSuffix = "spire.internal.confluent.cloud";
        }
        this.mTlsBuildClientCertChain = ConfluentConfigs.getMTlsEnable(configs) && ConfluentConfigs.getMTlsBuildClientCertChain(configs);
    }

    private void initializeUserMetaDataStore() {
        if (this.userMetaDataStore == null) {
            this.userMetaDataStore = DefaultUserMetaDataStore.getInstance(this.brokerUuid);
        }
    }

    public KafkaPrincipal build(AuthenticationContext context) {
        if (context instanceof SaslAuthenticationContext) {
            return this.createKafkaPrincipalfromSaslContext((SaslAuthenticationContext)context);
        }
        if (context instanceof SslAuthenticationContext) {
            return this.createKafkaPrincipalfromSslContext((SslAuthenticationContext)context);
        }
        if (context instanceof PlaintextAuthenticationContext) {
            return this.createKafkaPrincipalPlain();
        }
        throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
    }

    private KafkaPrincipal createKafkaPrincipalPlain() {
        return KafkaPrincipal.ANONYMOUS;
    }

    private KafkaPrincipal createKafkaPrincipalfromSslContext(SslAuthenticationContext context) {
        SSLSession sslSession = context.session();
        try {
            Principal sslPrincipal = sslSession.getPeerPrincipal();
            return new KafkaPrincipal("User", sslPrincipal.getName());
        }
        catch (SSLPeerUnverifiedException se) {
            return KafkaPrincipal.ANONYMOUS;
        }
    }

    private KafkaPrincipal createKafkaPrincipalfromSaslContext(SaslAuthenticationContext context) {
        SaslServer saslServer = context.server();
        if (saslServer == null && context.isMTlsSession()) {
            return this.createKafkaPrincipalForMTlsClient(context);
        }
        String authId = saslServer.getAuthorizationID();
        if (saslServer instanceof MultiTenantSaslServer) {
            MultiTenantSaslServer mtServer = (MultiTenantSaslServer)((Object)saslServer);
            TenantMetadata tenantMetadata = mtServer.tenantMetadata();
            this.updateTenantMetadata(tenantMetadata.clusterId, tenantMetadata, authId);
            return new MultiTenantPrincipal(authId, mtServer.authenticationId(), mtServer.networkId(), tenantMetadata, new IdentityMetadata(null, CONFLUENT_ISSUER, tenantMetadata.userResourceId, null, null, null, CallingResourceIdentityType.DEFAULT));
        }
        if (saslServer instanceof OAuthBearerSaslServer) {
            List<String> authorizationIds;
            OAuthBearerSaslServer server = (OAuthBearerSaslServer)saslServer;
            OAuthBearerJwsToken token = (OAuthBearerJwsToken)server.getNegotiatedProperty(OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY);
            String logicalCluster = (String)server.getNegotiatedProperty("logicalCluster");
            String authorizedPartyClaim = (String)server.getNegotiatedProperty("identityPoolId-azp");
            String subjectClaim = (String)server.getNegotiatedProperty("identityPoolId-sub");
            String poolIdUnionList = (String)server.getNegotiatedProperty("identityPoolId-identityPoolId");
            String poolId = (String)server.getNegotiatedProperty("identityPoolId");
            if (authorizedPartyClaim == null ^ subjectClaim == null) {
                throw new IllegalArgumentException("Unhandled identity pool context: authorizedPartyClaim = " + authorizedPartyClaim + ", subjectClaim = " + subjectClaim);
            }
            TenantMetadata tenantMetadata = new TenantMetadata.Builder(logicalCluster, subjectClaim == null ? this.userResourceId(token) : subjectClaim).serviceAccount(subjectClaim != null || this.isServiceAccount(token)).apiKeyAuthenticated(false).build();
            IdentityMetadata.Builder builder = new IdentityMetadata.Builder();
            if (poolIdUnionList == null || poolIdUnionList.isEmpty()) {
                builder.poolId(poolId);
            }
            if ((authorizationIds = this.authorizationIdsBasedOnIssuer(token, builder)).size() == 0) {
                authorizationIds = Collections.singletonList(tenantMetadata.userResourceId);
            }
            authId = this.authIdBasedOnIssuer(token, subjectClaim, authorizationIds);
            if (poolIdUnionList != null && !poolIdUnionList.isEmpty() || poolId != null) {
                authorizationIds = this.getAuthorizationId(poolIdUnionList, poolId);
                this.setMetadataProviderId(builder, authorizationIds, poolId);
                builder.identity(authorizedPartyClaim);
            }
            builder.externalIdentityId(this.oauthClaim(token, "externalIdentityId"));
            builder.issuer(token.issuer());
            Object aud = token.jwtClaims().get("aud");
            if (aud instanceof String) {
                builder.audience(Collections.singletonList(aud.toString()));
            } else if (aud instanceof List) {
                builder.audience(((List)aud).stream().map(o -> Objects.toString(o, null)).collect(Collectors.toList()));
            }
            Object callingResourceIdentity = token.jwtClaims().get("calling_resource_identity");
            if (callingResourceIdentity != null) {
                builder.callingResourceIdentityType(this.callingResourceIdentityTypeExtractor.extractType(callingResourceIdentity.toString()));
            }
            IdentityMetadata identityMetadata = builder.build();
            this.updateTenantMetadata(logicalCluster, tenantMetadata, authId);
            this.recordAuthenticationSubtypeMetric(authorizationIds, token.principalName(), token.issuer());
            return new MultiTenantPrincipal(authId, authorizedPartyClaim == null ? token.principalName() : authorizedPartyClaim, server.networkId(), tenantMetadata, identityMetadata, authorizationIds);
        }
        return new KafkaPrincipal("User", authId);
    }

    private KafkaPrincipal createKafkaPrincipalForMTlsClient(SaslAuthenticationContext context) {
        CertificateMetadata clientCertMetadata;
        Certificate[] certChain;
        if (!context.sslSession().isPresent()) {
            throw new IllegalArgumentException("SSL session is required to build a principal for mTLS authenticated client");
        }
        LogicalClusterMetadata logicalCluster = this.getTenantMetadataForDedicatedCluster();
        if (logicalCluster == null) {
            throw new IllegalStateException("Building principal for mTLS authenticated clients on multi-tenant clusters is not supported");
        }
        String orgId = logicalCluster.organizationId();
        SSLSession sslSession = (SSLSession)context.sslSession().get();
        try {
            certChain = sslSession.getPeerCertificates();
            X509Certificate clientCert = (X509Certificate)certChain[0];
            if (this.mTlsBuildClientCertChain && !this.store.authCache().isCompleteCertChain(certChain, orgId)) {
                log.warn("{} is incomplete, attempting to build full chain from AuthCache", (Object)CertificateUtils.certChainToString((Certificate[])certChain));
                certChain = this.store.authCache().getCertChain(certChain, orgId);
            }
            clientCertMetadata = new CertificateMetadata(clientCert);
        }
        catch (IndexOutOfBoundsException | SSLPeerUnverifiedException e) {
            throw new IllegalArgumentException("Attempt to build MultiTenantPrincipal for unauthenticated SSL peer when mTLS is enabled");
        }
        Collection identityProviders = this.store.authCache().findCertIdentityProviders(certChain, orgId);
        if (identityProviders == null || identityProviders.size() != 1) {
            throw new AuthenticationException(String.format("Must be only one matching identity provider found when building principal for mTLS authenticated client of orgId %s, found %s, %s", orgId, identityProviders, CertificateUtils.certChainToString((Certificate[])certChain)));
        }
        String providerId = ((CaCertificatesKey)identityProviders.iterator().next()).providerId();
        if (this.store.authCache().isRevoked(certChain, orgId, providerId)) {
            throw new AuthenticationException(String.format("Either the client certificate or some certificate on the certification path is found to be revoked.Cannot build a principal for client of orgId %s and providerId %s", orgId, providerId));
        }
        Collection authzPools = this.store.authCache().findCertIdentityPools(clientCertMetadata.getCelVars(), orgId, providerId);
        if (authzPools.isEmpty()) {
            throw new AuthenticationException(String.format("No matching identity pools found when building principal for mTLS authenticated client of orgId %s and providerId %s", orgId, providerId));
        }
        String externalId = MultiTenantPrincipalBuilder.externalIdBasedOnSSLCert(clientCertMetadata, CertIdentityPoolExternalIdentifier.findExternalIdentifierFromIdentityPools((Collection)authzPools));
        String mTlsAuthnId = MultiTenantPrincipal.mTlsAuthenticationId((String)orgId, (String)providerId, (String)clientCertMetadata.getIssuerDn(), (String)clientCertMetadata.getSnid());
        List authorizationIds = authzPools.stream().map(CertIdentityPool::poolId).collect(Collectors.toList());
        String userResourceId = String.join((CharSequence)",", authorizationIds);
        TenantMetadata tenantMetadata = new TenantMetadata.Builder(logicalCluster.logicalClusterId(), userResourceId).organizationId(logicalCluster.organizationId()).environmentId(logicalCluster.environmentId()).serviceAccount(false).apiKeyAuthenticated(false).healthcheckTenant(logicalCluster.isHealthcheckLogicalCluster()).build();
        IdentityMetadata identityMetadata = new IdentityMetadata.Builder().providerId(providerId).identity(externalId).build();
        return new MultiTenantPrincipal(externalId, mTlsAuthnId, Optional.empty(), tenantMetadata, identityMetadata, authorizationIds);
    }

    private String authIdBasedOnIssuer(OAuthBearerJwsToken token, String subjectClaim, List<String> authorizationIds) {
        Optional<Object> authId = Optional.empty();
        this.initializeUserMetaDataStore();
        if (token.issuer() != null && token.issuer().equals(CONFLUENT_ISSUER) && this.userMetaDataStore != null) {
            for (String authorizationId : authorizationIds) {
                if (!authorizationId.startsWith("u-") && !authorizationId.startsWith(RESOURCE_ID_SERVICE_ACCOUNT_PREFIX)) continue;
                authId = this.userMetaDataStore.userResourceIdToUserId(authorizationId);
                if (authId.isPresent()) break;
                log.warn("Missing userIntegerId for userResourceId: {} present in token", (Object)authorizationId);
                break;
            }
        }
        if (!authId.isPresent()) {
            authId = Optional.of(subjectClaim == null ? token.principalName() : subjectClaim);
        }
        return (String)authId.get();
    }

    private List<String> authorizationIdsBasedOnIssuer(OAuthBearerJwsToken token, IdentityMetadata.Builder builder) {
        if (token.issuer() != null && token.issuer().equals(CONFLUENT_ISSUER)) {
            builder.providerId(CONFLUENT_ISSUER);
            builder.identity(this.userResourceId(token));
            return this.authorizationIds(token);
        }
        if (token.issuer() != null && token.issuer().contains(this.confluentSpireIssuerSuffix)) {
            return this.spiffeIdPrincipalExtractor.extractPrincipals(token.principalName());
        }
        return Collections.emptyList();
    }

    private List<String> authorizationIds(OAuthBearerJwsToken token) {
        if (token.jwtClaims().containsKey("may_act")) {
            try {
                JSONObject mayActJsonObject = new JSONObject((Map)token.jwtClaims().get("may_act"));
                OauthMayActClaim mayActValue = (OauthMayActClaim)new ObjectMapper().readValue(mayActJsonObject.toJSONString(), OauthMayActClaim.class);
                return mayActValue.principals();
            }
            catch (JsonProcessingException e) {
                log.error("Unable to parse the may_act claim");
                throw new IllegalArgumentException("Unable to parse the may_act claim");
            }
        }
        return Arrays.asList(this.userResourceId(token));
    }

    static String externalIdBasedOnSSLCert(CertificateMetadata clientCertMetadata, CertIdentityPoolExternalIdentifier externalIdentifier) {
        String dn = clientCertMetadata.getDn();
        String cn = clientCertMetadata.getCn();
        String snid = clientCertMetadata.getSnid();
        String san = clientCertMetadata.getSan();
        san = MultiTenantPrincipalBuilder.truncate(san, 255);
        String externalId = dn;
        switch (externalIdentifier) {
            case CN: {
                externalId = cn;
                break;
            }
            case DN: {
                externalId = dn;
                break;
            }
            case SNID: {
                externalId = snid;
                break;
            }
            case CN_SNID: {
                externalId = String.format("%s, %s", cn, snid);
                break;
            }
            case SAN: {
                externalId = san;
                break;
            }
            case SAN_SNID: {
                externalId = String.format("%s, %s", san, snid);
                break;
            }
            case SHA1: {
                externalId = clientCertMetadata.getSha1();
                break;
            }
            default: {
                log.warn("Unknown external identifier claim {} found while building multi-tenant principal for mTLS client, defaulting to DN", (Object)externalIdentifier);
            }
        }
        return externalId;
    }

    protected void recordAuthenticationSubtypeMetric(List<String> authorizationIds, String principal, String issuer) {
        if (issuer != null && issuer.equals(CONFLUENT_ISSUER)) {
            if (principal.contains("pool")) {
                AUTHENTICATION_SUBTYPE_REQUEST_METER.get(AuthenticationSubtype.FDPAT.name()).mark();
            } else if (authorizationIds.size() > 1) {
                AUTHENTICATION_SUBTYPE_REQUEST_METER.get(AuthenticationSubtype.AUPM.name()).mark();
            } else {
                AUTHENTICATION_SUBTYPE_REQUEST_METER.get(AuthenticationSubtype.DPAT.name()).mark();
            }
        } else {
            AUTHENTICATION_SUBTYPE_REQUEST_METER.get(AuthenticationSubtype.OAUTH.name()).mark();
        }
    }

    private void updateTenantMetadata(String clusterId, TenantMetadata tenantMetadata, String user) {
        boolean lkcMetadataAvailable = false;
        if (this.physicalClusterMetadata == null) {
            tenantMetadata.isHealthcheckTenant = false;
        } else {
            LogicalClusterMetadata lkcMetadata = this.physicalClusterMetadata.metadata(clusterId);
            lkcMetadataAvailable = lkcMetadata != null;
            boolean bl = tenantMetadata.isHealthcheckTenant = lkcMetadataAvailable && lkcMetadata.isHealthcheckLogicalCluster();
            if (lkcMetadataAvailable && lkcMetadata.organizationId() != null && lkcMetadata.environmentId() != null) {
                tenantMetadata.updateOrgProperties(lkcMetadata.organizationId(), lkcMetadata.environmentId());
            } else if (lkcMetadataAvailable) {
                ORG_PROPS_MISSING_METER.mark();
                log.warn("Org Properties is missing for user {}, userResourceId {} and clusterId {}", new Object[]{user, tenantMetadata.userResourceId, clusterId});
            }
        }
        if (!lkcMetadataAvailable) {
            ORG_PROPS_MISSING_METER.mark();
            log.warn("LKC Metadata is unavailable due to " + (String)(this.physicalClusterMetadata == null ? "physicalClusterMetadata=null" : "no metadata for cluster " + clusterId));
        }
    }

    private List<String> getAuthorizationId(String poolUnionList, String poolId) {
        List<String> authorizationIds = new ArrayList<String>();
        if (poolUnionList != null && !poolUnionList.isEmpty()) {
            authorizationIds = Arrays.asList(poolUnionList.split(","));
        } else if (poolId != null) {
            authorizationIds.add(poolId);
        }
        return authorizationIds;
    }

    private void setMetadataProviderId(IdentityMetadata.Builder builder, List<String> authorizationIds, String poolId) {
        IdentityPool pool = null;
        if (authorizationIds != null && !authorizationIds.isEmpty()) {
            pool = this.store.trustCache().identityPool(authorizationIds.get(0));
        } else if (poolId != null) {
            pool = this.store.trustCache().identityPool(poolId);
        }
        if (pool != null) {
            builder.providerId((String)(pool.providerId() != null && pool.providerId().isEmpty() ? null : pool.providerId()));
        }
    }

    private LogicalClusterMetadata getTenantMetadataForDedicatedCluster() {
        List dedicatedLkc = this.physicalClusterMetadata.kafkaLogicalClusterIds().stream().map(lkcId -> this.physicalClusterMetadata.metadata(lkcId)).filter(lkcMetadata -> lkcMetadata.isActive() && !ORG0_UUID.equals(lkcMetadata.organizationId())).collect(Collectors.toList());
        return dedicatedLkc.size() == 1 ? (LogicalClusterMetadata)dedicatedLkc.get(0) : null;
    }

    private boolean isServiceAccount(OAuthBearerJwsToken token) {
        String userResourceId = this.userResourceId(token);
        return userResourceId != null && userResourceId.startsWith(RESOURCE_ID_SERVICE_ACCOUNT_PREFIX);
    }

    public String userResourceId(OAuthBearerJwsToken token) {
        return this.oauthClaim(token, "userResourceId");
    }

    public String oauthClaim(OAuthBearerJwsToken token, String claimKey) {
        Object oauthClaim = token.jwtClaims().get(claimKey);
        return oauthClaim != null ? oauthClaim.toString() : null;
    }

    private static String truncate(String str, int limit) {
        limit = Math.min(str.length(), limit);
        return str.substring(0, limit);
    }

    public byte[] serialize(KafkaPrincipal principal) throws SerializationException {
        if (principal instanceof MultiTenantPrincipal) {
            DefaultPrincipalData data = new DefaultPrincipalData();
            MultiTenantPrincipal mtp = (MultiTenantPrincipal)principal;
            TenantMetadata tm = mtp.tenantMetadata();
            Optional im = mtp.maybeGetIdentityMetadata();
            data.setType(mtp.getPrincipalType()).setName(mtp.getName().substring(tm.tenantName.length() + "_".length())).setSaslAuthenticationId(mtp.authenticationId()).setTenantName(tm.tenantName).setClusterId(tm.clusterId).setOrganizationId(tm.organizationId).setEnvironmentId(tm.environmentId).setServiceAccount(tm.isServiceAccount).setApiKeyAuthenticated(tm.isApiKeyAuthenticated).setHealthcheckTenant(tm.isHealthcheckTenant).setUserResourceId(tm.userResourceId).setIdentity((String)im.map(IdentityMetadata::identity).orElse(null)).setPoolId((String)im.map(IdentityMetadata::poolId).orElse(null)).setProviderId((String)im.map(IdentityMetadata::providerId).orElse(null)).setAuthorizationIds(mtp.authorizationIds()).setExternalIdentityId((String)im.map(IdentityMetadata::externalIdentityId).orElse(null)).setIssuer((String)im.map(IdentityMetadata::issuer).orElse(null)).setAudience((List)im.map(IdentityMetadata::audience).orElse(null)).setCallingResourceIdentityType(im.map(m -> m.callingResourceIdentityType().id()).orElse((byte)0).byteValue());
            return MessageUtil.toVersionPrefixedBytes((short)0, (Message)data);
        }
        return this.defaultKafkaPrincipalBuilder.serialize(principal);
    }

    public KafkaPrincipal deserialize(byte[] bytes) throws SerializationException {
        DefaultPrincipalData data;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            throw new SerializationException("Invalid principal data version " + version);
        }
        try {
            data = new DefaultPrincipalData((Readable)new ByteBufferAccessor(buffer), version);
        }
        catch (Throwable t) {
            throw new SerializationException("Failed to deserialize principal", t);
        }
        if (buffer.hasRemaining()) {
            throw new SerializationException("Failed to deserialize principal: " + buffer.remaining() + " bytes remaining after parsing");
        }
        String type = data.type();
        if (type.equals("User")) {
            return this.defaultKafkaPrincipalBuilder.deserialize(bytes);
        }
        if (type.equals("TenantUser")) {
            String tenantName = data.tenantName();
            String user = data.name();
            if (data.authorizationIds() == null || data.authorizationIds().isEmpty()) {
                return new MultiTenantPrincipal(user, data.saslAuthenticationId(), Optional.empty(), new TenantMetadata(tenantName, data.clusterId(), data.organizationId(), data.environmentId(), data.userResourceId(), data.serviceAccount(), data.apiKeyAuthenticated(), data.healthcheckTenant()), new IdentityMetadata(data.poolId(), data.providerId(), data.identity(), data.externalIdentityId(), data.issuer(), data.audience(), CallingResourceIdentityType.findById((byte)data.callingResourceIdentityType())));
            }
            return new MultiTenantPrincipal(user, data.saslAuthenticationId(), Optional.empty(), new TenantMetadata(tenantName, data.clusterId(), data.organizationId(), data.environmentId(), data.userResourceId(), data.serviceAccount(), data.apiKeyAuthenticated(), data.healthcheckTenant()), new IdentityMetadata(data.poolId(), data.providerId(), data.identity(), data.externalIdentityId(), data.issuer(), data.audience(), CallingResourceIdentityType.findById((byte)data.callingResourceIdentityType())), data.authorizationIds());
        }
        throw new SerializationException(String.format("Invalid principal type '%s', expected '%s' or '%s'", type, "User", "TenantUser"));
    }

    void setAuthStore(AuthStore authStore) {
        this.store = authStore;
    }

    static {
        for (AuthenticationSubtype authenticationSubType : AuthenticationSubtype.values()) {
            LinkedHashMap<String, String> tag = new LinkedHashMap<String, String>();
            tag.put("subtype", authenticationSubType.name());
            AUTHENTICATION_SUBTYPE_REQUEST_METER.put(authenticationSubType.name(), KafkaYammerMetrics.defaultRegistry().newMeter(KafkaYammerMetrics.getMetricName((String)METRIC_GROUP, (String)MultiTenantPrincipalBuilder.class.getSimpleName(), (String)"authentication-subtype-rate", tag), "authentication-subtype", TimeUnit.SECONDS));
        }
    }

    private static enum AuthenticationSubtype {
        OAUTH,
        DPAT,
        FDPAT,
        AUPM;

    }
}

