/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.CallingResourceIdentityType;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.ZoneAlignment;
import io.confluent.kafka.multitenant.metrics.ApiKeyConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ApiKeysVersionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ApiKeysVersionSensors;
import io.confluent.kafka.multitenant.metrics.ConnectionInformationSensors;
import io.confluent.kafka.multitenant.metrics.ConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.DeprecatedRequestSensors;
import io.confluent.kafka.multitenant.metrics.FailedAuthSensors;
import io.confluent.kafka.multitenant.metrics.FetchApiSensorBuilder;
import io.confluent.kafka.multitenant.metrics.IpConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.IpFailedAuthenticationByIpSensorBuilder;
import io.confluent.kafka.multitenant.metrics.PartitionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.PartitionSensors;
import java.net.InetAddress;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.apache.kafka.server.metrics.TenantRequestSensorBuilder;
import org.apache.kafka.server.metrics.TenantRequestSensors;
import org.apache.kafka.server.metrics.utils.MetricUtils;

public class TenantMetrics
implements Configurable {
    static final String API_KEY_METHOD = "SASL/PLAIN";
    private TenantRequestSensors tenantRequestSensors;
    final EnumMap<ApiKeys, ApiSensors> apiSensors = new EnumMap(ApiKeys.class);
    private final Map<ApiKeys, ApiKeysVersionSensors> apiKeysVersionSensors = new ConcurrentHashMap<ApiKeys, ApiKeysVersionSensors>();
    private final EnumMap<ApiKeys, DeprecatedRequestSensors> deprecatedRequestSensors = new EnumMap(ApiKeys.class);
    private ConnectionSensors connectionSensors;
    private ConnectionSensors ipConnectionSensors;
    private FailedAuthSensors ipFailedAuthSensors;
    private ConnectionSensors apiKeySensors;
    private ConnectionInformationSensors connectionInformationSensors;
    private PartitionSensors partitionSensors;
    private ZoneAlignment zoneAlignment = ZoneAlignment.UNSET;
    private boolean isSupportedFFFClient;
    private int uniqueDeprecatedRequestMetricsPerTenant;
    private boolean emitNetworkTypeTag;

    public void recordAuthenticatedConnection(Metrics metrics, MultiTenantPrincipal principal, InetAddress clientAddress) {
        if (this.connectionSensors == null) {
            this.connectionSensors = new ConnectionSensorBuilder(metrics, principal).build();
            this.connectionSensors.recordAuthenticatedConnection();
        }
        if (this.ipConnectionSensors == null) {
            this.ipConnectionSensors = new IpConnectionSensorBuilder(metrics, principal, clientAddress).build();
            this.ipConnectionSensors.recordAuthenticatedConnection();
        }
        if (this.apiKeySensors == null && principal.tenantMetadata().isApiKeyAuthenticated) {
            this.apiKeySensors = new ApiKeyConnectionSensorBuilder(metrics, principal).build();
            this.apiKeySensors.recordAuthenticatedConnection();
        }
    }

    public void recordAuthenticatedDisconnection() {
        if (this.connectionSensors != null) {
            this.connectionSensors.recordAuthenticatedDisconnection();
            this.connectionSensors = null;
        }
        if (this.ipConnectionSensors != null) {
            this.ipConnectionSensors.recordAuthenticatedDisconnection();
            this.ipConnectionSensors = null;
        }
        if (this.apiKeySensors != null) {
            this.apiKeySensors.recordAuthenticatedDisconnection();
            this.apiKeySensors = null;
        }
        if (this.connectionInformationSensors != null) {
            this.connectionInformationSensors.recordAuthenticatedDisconnection();
            this.connectionInformationSensors = null;
        }
    }

    public void recordFailedAuthentication(Metrics metrics, InetAddress clientAddress) {
        if (this.ipFailedAuthSensors == null) {
            this.ipFailedAuthSensors = new IpFailedAuthenticationByIpSensorBuilder(metrics, clientAddress).build();
            this.ipFailedAuthSensors.recordFailedAuthentication();
        }
    }

    public void recordClientInformation(Metrics metrics, MultiTenantPrincipal principal, ClientInformation clientInformation, String clientId, int maxConnectionInfoMetricsPerTenant) {
        if (this.connectionInformationSensors == null) {
            this.connectionInformationSensors = new ConnectionInformationSensors(metrics, principal, clientInformation, clientId, maxConnectionInfoMetricsPerTenant);
            this.connectionInformationSensors.recordAuthenticatedConnection();
        }
    }

    public void recordRequest(Metrics metrics, MetricsRequestContext context, long requestSize, long currentTimeMs) {
        ApiSensors sensors = this.apiSensors(metrics, context, apiSensors -> apiSensors.requestSensorsExpired(metrics));
        sensors.recordRequest(requestSize, currentTimeMs);
        this.tenantRequestSensors.recordRequest(currentTimeMs);
        if (context.isVersionDeprecated()) {
            DeprecatedRequestSensors deprecatedSensors = this.deprecatedRequestSensors(metrics, context);
            deprecatedSensors.recordDeprecatedRequest();
        }
    }

    public void recordResponse(Metrics metrics, MetricsRequestContext context, long responseSize, long responseTimeNanos, Map<Errors, Integer> errorCounts, long currentTimeMs) {
        ApiKeys apiKey = context.apiKey();
        ApiSensors sensors = this.apiSensors(metrics, context, apiSensors -> apiSensors.responseSensorsExpired(metrics));
        Set newErrors = sensors.errorsWithoutSensors(metrics, errorCounts.keySet());
        if (!newErrors.isEmpty()) {
            ApiSensorBuilder builder = new ApiSensorBuilder(metrics, (MetricsBuilderContext)context, apiKey);
            builder.addErrorSensors(sensors, newErrors);
        }
        sensors.recordResponse(responseSize, responseTimeNanos, currentTimeMs);
        sensors.recordErrors(errorCounts, currentTimeMs);
    }

    public void recordPartitionStatsIn(Metrics metrics, MetricsRequestContext context, TopicPartition topicPartition, int size, int numRecords, long timeMs) {
        this.partitionSensors(metrics, context).recordStatsIn(topicPartition, size, numRecords, timeMs);
    }

    public void recordPartitionStatsOut(Metrics metrics, MetricsRequestContext context, TopicPartition topicPartition, int size, int numRecords, long timeMs) {
        this.partitionSensors(metrics, context).recordStatsOut(topicPartition, size, numRecords, timeMs);
    }

    public void recordApiKeyMaxVersion(Metrics metrics, ApiKeys apiKey, int maxVersion) {
        ApiKeysVersionSensors sensors = this.apiKeysVersionSensors.get(apiKey);
        if (sensors == null || TenantMetrics.isExpired(metrics, sensors.sensor)) {
            sensors = new ApiKeysVersionSensorBuilder(metrics, apiKey).build();
            this.apiKeysVersionSensors.put(apiKey, sensors);
        }
        sensors.recordMaxVersion(maxVersion);
    }

    public static boolean isExpired(Metrics metrics, Sensor sensor) {
        return MetricUtils.isExpired((Metrics)metrics, (Sensor)sensor);
    }

    private ApiSensors apiSensors(Metrics metrics, MetricsRequestContext context, Predicate<ApiSensors> expiredPred) {
        ApiKeys apiKey = context.apiKey();
        ApiSensors sensors = this.apiSensors.get(apiKey);
        if (this.tenantRequestSensors == null || this.tenantRequestSensors.requestSensorsExpired(metrics)) {
            this.tenantRequestSensors = new TenantRequestSensorBuilder(metrics, (MetricsBuilderContext)new TenantLevelMetricsContext(context.principal())).build();
        }
        if (sensors == null || expiredPred.test(sensors)) {
            Object wrappedContext = context;
            if (this.emitNetworkTypeTag) {
                wrappedContext = new ApiSensorsMetricsRequestContext(context);
            }
            sensors = apiKey == ApiKeys.FETCH && this.zoneAlignment != ZoneAlignment.UNSET ? new FetchApiSensorBuilder(metrics, (MetricsBuilderContext)wrappedContext, apiKey, this.zoneAlignment, this.isSupportedFFFClient).build() : new ApiSensorBuilder(metrics, (MetricsBuilderContext)wrappedContext, apiKey).build();
            this.apiSensors.put(apiKey, sensors);
        }
        return sensors;
    }

    private DeprecatedRequestSensors deprecatedRequestSensors(Metrics metrics, MetricsRequestContext context) {
        ApiKeys apiKey = context.apiKey();
        MultiTenantPrincipal principal = context.principal();
        String clientId = context.clientId();
        return this.deprecatedRequestSensors.computeIfAbsent(apiKey, key -> new DeprecatedRequestSensors(metrics, principal, (ApiKeys)key, clientId, this.uniqueDeprecatedRequestMetricsPerTenant));
    }

    public void setFetchFromFollowerTags(Metrics metrics, MetricsBuilderContext context, ApiKeys fetchApiKey, ZoneAlignment zoneAlignment, boolean isSupportedFFFClient) {
        this.zoneAlignment = zoneAlignment;
        this.isSupportedFFFClient = isSupportedFFFClient;
        if (context instanceof MetricsRequestContext && this.emitNetworkTypeTag) {
            context = new ApiSensorsMetricsRequestContext((MetricsRequestContext)context);
        }
        ApiSensors fetchSensors = new FetchApiSensorBuilder(metrics, context, fetchApiKey, zoneAlignment, isSupportedFFFClient).build();
        this.apiSensors.put(fetchApiKey, fetchSensors);
    }

    private PartitionSensors partitionSensors(Metrics metrics, MetricsRequestContext context) {
        if (this.partitionSensors == null) {
            this.partitionSensors = new PartitionSensorBuilder(metrics, context).build();
        }
        return this.partitionSensors;
    }

    public void configure(Map<String, ?> configs) {
        this.uniqueDeprecatedRequestMetricsPerTenant = ConfluentConfigs.uniqueDeprecatedRequestMetricsPerTenant(configs);
        Boolean emitNetworkTypeTagConfig = (Boolean)configs.get("confluent.emit.network.type.tag");
        this.emitNetworkTypeTag = Objects.requireNonNullElse(emitNetworkTypeTagConfig, false);
    }

    public static class MetricsRequestContext
    extends TenantMetricsContext {
        private final String clientId;
        private final ApiKeys apiKey;
        private final boolean isVersionDeprecated;
        private final boolean isFetchFromFollowerEnabled;
        private final String applicationIdentity;
        private final String networkType;

        public MetricsRequestContext(MultiTenantPrincipal principal, String clientId, ApiKeys apiKey) {
            this(principal, clientId, apiKey, apiKey.latestVersion(), false, null);
        }

        public MetricsRequestContext(MultiTenantPrincipal principal, String clientId, ApiKeys apiKey, short apiVersion) {
            this(principal, clientId, apiKey, apiVersion, false, null);
        }

        public MetricsRequestContext(MultiTenantPrincipal principal, String clientId, ApiKeys apiKey, short apiVersion, boolean isFetchFromFollowerEnabled, String networkType) {
            super(principal);
            this.clientId = clientId;
            this.apiKey = apiKey;
            this.isVersionDeprecated = apiKey.isVersionDeprecated(apiVersion);
            this.isFetchFromFollowerEnabled = isFetchFromFollowerEnabled;
            this.applicationIdentity = CallingResourceIdentityType.fromPrincipal((MultiTenantPrincipal)principal).applicationIdentity();
            this.networkType = networkType;
        }

        public String clientId() {
            return this.clientId;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public boolean isVersionDeprecated() {
            return this.isVersionDeprecated;
        }

        public boolean isFetchFromFollowerEnabled() {
            return this.isFetchFromFollowerEnabled;
        }

        public String networkType() {
            return this.networkType;
        }

        @Override
        public Map<String, String> metricTags() {
            Map<String, String> tags = super.metricTags();
            tags.put("application-identity", this.applicationIdentity);
            return tags;
        }

        @Override
        public String sensorSuffix() {
            return super.sensorSuffix() + String.format(":%s-%s", "application-identity", this.applicationIdentity);
        }
    }

    public static class TenantLevelMetricsContext
    implements MetricsBuilderContext {
        private final MultiTenantPrincipal principal;

        public TenantLevelMetricsContext(MultiTenantPrincipal principal) {
            this.principal = principal;
        }

        public String metricsGroup() {
            return "tenant-metrics";
        }

        public Map<String, String> metricTags() {
            return Collections.singletonMap("tenant", this.principal.tenantMetadata().tenantName);
        }

        public String sensorSuffix() {
            return String.format(":%s-%s", "tenant", this.principal.tenantMetadata().tenantName);
        }
    }

    private record ApiSensorsMetricsRequestContext(MetricsRequestContext ctx) implements MetricsBuilderContext
    {
        public String metricsGroup() {
            return this.ctx.metricsGroup();
        }

        public Map<String, String> metricTags() {
            Map<String, String> tags = this.ctx.metricTags();
            String networkType = this.ctx.networkType();
            if (networkType != null && !networkType.isEmpty()) {
                tags.put("networking-type", networkType);
            }
            return tags;
        }

        public String sensorSuffix() {
            return this.ctx.sensorSuffix();
        }
    }

    public static class ZoneDataMetricsRequestContext
    extends MetricsRequestContext {
        private final String clientZoneId;
        private final String gatewayZoneId;
        private final String brokerZoneId;

        public ZoneDataMetricsRequestContext(MultiTenantPrincipal principal, String clientId, ApiKeys apiKey, short apiVersion, boolean isFetchFromFollowerEnabled, Optional<String> clientZoneId, Optional<String> gatewayZoneId, Optional<String> brokerZoneId, String networkType) {
            super(principal, clientId, apiKey, apiVersion, isFetchFromFollowerEnabled, networkType);
            this.clientZoneId = clientZoneId.orElse("");
            this.gatewayZoneId = gatewayZoneId.orElse("");
            this.brokerZoneId = brokerZoneId.orElse("");
        }

        @Override
        public Map<String, String> metricTags() {
            HashMap<String, String> tags = new HashMap<String, String>(super.metricTags());
            tags.put("client-zone-id", this.clientZoneId);
            tags.put("gateway-zone-id", this.gatewayZoneId);
            tags.put("broker-zone-id", this.brokerZoneId);
            return tags;
        }
    }

    public static class ApiKeysVersionContext
    implements MetricsBuilderContext {
        private final ApiKeys apiKey;

        public ApiKeysVersionContext(ApiKeys apiKey) {
            this.apiKey = apiKey;
        }

        public String metricsGroup() {
            return "tenant-metrics";
        }

        public Map<String, String> metricTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("request", this.apiKey.name());
            return tags;
        }

        public String sensorSuffix() {
            return String.format(":%s-%s", "request", this.apiKey.name());
        }
    }

    public static class IpMetricsContext
    implements MetricsBuilderContext {
        private final InetAddress clientAddress;

        public IpMetricsContext(InetAddress clientAddress) {
            this.clientAddress = clientAddress;
        }

        public String metricsGroup() {
            return "tenant-metrics";
        }

        public Map<String, String> metricTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("ip", this.clientAddress.getHostAddress());
            return tags;
        }

        public String sensorSuffix() {
            return String.format(":%s-%s", "ip", this.clientAddress.getHostAddress());
        }
    }

    public static class ApiKeyMetricsContext
    extends TenantMetricsContext {
        public ApiKeyMetricsContext(MultiTenantPrincipal principal) {
            super(principal);
        }

        public static Map<String, String> metricTags(String key, String user) {
            return ApiKeyMetricsContext.metricTags(TenantMetrics.API_KEY_METHOD, key, user, null);
        }

        private static Map<String, String> metricTags(String method, String key, String user, String userResourceId) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("auth-method", method);
            tags.put("auth-credential", key);
            tags.put("user", user);
            if (userResourceId != null) {
                tags.put("user-resource-id", userResourceId);
            }
            return tags;
        }

        @Override
        public Map<String, String> metricTags() {
            assert (this.principal().tenantMetadata().isApiKeyAuthenticated);
            return ApiKeyMetricsContext.metricTags(TenantMetrics.API_KEY_METHOD, this.principal().authenticationId(), this.principal().user(), this.principal().tenantMetadata().userResourceId);
        }

        @Override
        public String sensorSuffix() {
            StringBuilder builder = new StringBuilder();
            this.metricTags().forEach((tag, value) -> builder.append(":").append((String)tag).append("-").append((String)value));
            return builder.toString();
        }
    }

    public static class TenantConnectionInformationMetricsContext
    extends TenantMetricsContext {
        private final ClientInformation clientInformation;
        private final String clientId;

        public TenantConnectionInformationMetricsContext(MultiTenantPrincipal principal, ClientInformation clientInformation, String clientId) {
            super(principal);
            this.clientInformation = clientInformation;
            this.clientId = clientId;
        }

        @Override
        public Map<String, String> metricTags() {
            Map<String, String> tags = super.metricTags();
            tags.put("io-confluent-jmx-ignore", "");
            tags.put("client-software-name", this.clientInformation.softwareName());
            tags.put("client-software-version", this.clientInformation.softwareVersion());
            if (this.clientId != null) {
                tags.put("client-id", this.clientId);
            }
            return tags;
        }

        @Override
        public String sensorSuffix() {
            return MetricUtils.tagsToSensorSuffix(this.metricTags());
        }
    }

    public static class TenantIpMetricsContext
    extends TenantMetricsContext {
        private final InetAddress clientAddress;

        public TenantIpMetricsContext(MultiTenantPrincipal principal, InetAddress clientAddress) {
            super(principal);
            this.clientAddress = clientAddress;
        }

        @Override
        public Map<String, String> metricTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tenant", this.principal().tenantMetadata().tenantName);
            tags.put("ip", this.clientAddress.getHostAddress());
            return tags;
        }

        @Override
        public String sensorSuffix() {
            return String.format(":%s-%s:%s-%s", "tenant", this.principal().tenantMetadata().tenantName, "ip", this.clientAddress.getHostAddress());
        }
    }

    public static class TenantMetricsContext
    implements MetricsBuilderContext {
        private final MultiTenantPrincipal principal;

        public TenantMetricsContext(MultiTenantPrincipal principal) {
            this.principal = principal;
        }

        public MultiTenantPrincipal principal() {
            return this.principal;
        }

        public String metricsGroup() {
            return "tenant-metrics";
        }

        public Map<String, String> metricTags() {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("tenant", this.principal.tenantMetadata().tenantName);
            tags.put("user", this.principal.user());
            if (this.principal.tenantMetadata().userResourceId != null) {
                tags.put("user-resource-id", this.principal.tenantMetadata().userResourceId);
            }
            return tags;
        }

        public String sensorSuffix() {
            if (this.principal.tenantMetadata().userResourceId != null) {
                return String.format(":%s-%s:%s-%s:%s-%s", "tenant", this.principal.tenantMetadata().tenantName, "user", this.principal.user(), "user-resource-id", this.principal.tenantMetadata().userResourceId);
            }
            return String.format(":%s-%s:%s-%s", "tenant", this.principal.tenantMetadata().tenantName, "user", this.principal.user());
        }
    }
}

