/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.InvalidRoleDefinitionException;
import io.confluent.security.roledefinitions.RbacQuotas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Role {
    public static final String NAMESPACE_PUBLIC = "public";
    public static final String NAMESPACE_CONFLUENT = "confluent";
    public static final String NAMESPACE_CDX = "cdx";
    public static final String NAMESPACE_DATAPLANE = "dataplane";
    public static final String NAMESPACE_DATAGOVERNANCE = "datagovernance";
    public static final String NAMESPACE_STREAMCATALOG = "streamcatalog";
    public static final String NAMESPACE_KSMS = "ksms";
    public static final String NAMESPACE_NETWORKING = "networking";
    public static final String NAMESPACE_CONNECT = "connect";
    public static final String NAMESPACE_CONNECT_V2 = "connectv2";
    public static final String NAMESPACE_CONNECT_V3 = "connectv3";
    public static final String NAMESPACE_KSQL = "ksql";
    public static final String NAMESPACE_FLINK = "flink";
    public static final String NAMESPACE_PIPELINES = "pipelines";
    public static final String NAMESPACE_KAFKAQUEUES = "kafkaqueues";
    public static final String NAMESPACE_WORKLOAD = "workload";
    public static final String NAMESPACE_BILLING = "billing";
    public static final String NAMESPACE_BASEPERMISSION = "basepermission";
    public static final String NAMESPACE_CLOUDACCESSIDENTITY = "cloudaccessidentity";
    private final String name;
    private final String displayName;
    private final String namespace;
    private final boolean internal;
    private final RbacQuotas.RbacQuota rbacQuota;
    private final Map<String, Collection<AccessPolicy>> accessPolicies;
    private String mostSpecificBindingScope = null;

    @JsonCreator
    public Role(@JsonProperty(value="name") String name, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="internal") boolean internal, @JsonProperty(value="rbacQuota") RbacQuotas.RbacQuota rbacQuota, @JsonProperty(value="policy") AccessPolicy accessPolicy, @JsonProperty(value="policies") List<AccessPolicy> accessPolicies) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Role name must be non-empty");
        }
        this.name = name;
        this.displayName = displayName == null ? name : displayName;
        this.namespace = namespace;
        this.internal = internal;
        this.rbacQuota = rbacQuota == null ? RbacQuotas.RbacQuota.NONE : rbacQuota;
        HashMap<String, Collection> policies = new HashMap<String, Collection>();
        if (accessPolicy != null) {
            if (accessPolicies != null) {
                throw new InvalidRoleDefinitionException("role must not define both 'accessPolicy' and 'accessPolicies'");
            }
            policies.put(accessPolicy.bindingScope(), Collections.singletonList(accessPolicy));
        }
        if (accessPolicies != null) {
            for (AccessPolicy policy : accessPolicies) {
                String bindingScope = policy.bindingScope();
                policies.computeIfAbsent(bindingScope, k -> new ArrayList()).add(policy);
            }
        }
        if (policies.isEmpty()) {
            throw new InvalidRoleDefinitionException("at least one access policy must be supplied");
        }
        this.accessPolicies = Collections.unmodifiableMap(policies);
    }

    private Role(String name, String displayName, String namespace, boolean internal, RbacQuotas.RbacQuota rbacQuota, Map<String, Collection<AccessPolicy>> policies) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Role name must be non-empty");
        }
        this.name = name;
        this.displayName = displayName == null ? name : displayName;
        this.namespace = namespace;
        this.internal = internal;
        this.rbacQuota = rbacQuota;
        if (policies.isEmpty()) {
            throw new InvalidRoleDefinitionException("at least one access policy must be supplied");
        }
        this.accessPolicies = Collections.unmodifiableMap(policies);
    }

    public static Role merge(Role role1, Role role2) {
        if (!Objects.equals(role1.name, role2.name)) {
            throw new IllegalArgumentException("Role name does not match");
        }
        if (!Objects.equals(role1.displayName(), role2.displayName())) {
            throw new IllegalArgumentException("Role display name does not match");
        }
        if (!Objects.equals(role1.namespace, role2.namespace)) {
            throw new IllegalArgumentException("Role namespace does not match");
        }
        if (!Objects.equals(role1.internal, role2.internal)) {
            throw new IllegalArgumentException("Role state internal does not match");
        }
        if (!Objects.equals((Object)role1.rbacQuota, (Object)role2.rbacQuota)) {
            throw new IllegalArgumentException("Role rbacQuota does not match");
        }
        HashMap<String, Collection<AccessPolicy>> mergedAccessPolicies = new HashMap<String, Collection<AccessPolicy>>(role1.accessPolicies);
        role2.accessPolicies.forEach((key, value) -> mergedAccessPolicies.merge((String)key, (Collection<AccessPolicy>)value, Role::mergeAtBindingScope));
        return new Role(role1.name, role1.displayName(), role1.namespace, role1.internal, role1.rbacQuota, mergedAccessPolicies);
    }

    public static Role mergeYaml(Role role1, Role role2) {
        if (!Objects.equals(role1.name, role2.name)) {
            throw new IllegalArgumentException("Role name does not match");
        }
        if (!Objects.equals(role1.displayName(), role2.displayName())) {
            throw new IllegalArgumentException("Role display name does not match");
        }
        if (!Objects.equals(role1.namespace, role2.namespace)) {
            throw new IllegalArgumentException("Role namespace does not match");
        }
        if (!Objects.equals(role1.internal, role2.internal)) {
            throw new IllegalArgumentException("Role state internal does not match");
        }
        if (!Objects.equals((Object)role1.rbacQuota, (Object)role2.rbacQuota)) {
            throw new IllegalArgumentException("Role rbacQuota does not match");
        }
        HashMap<String, Collection<AccessPolicy>> mergedAccessPolicies = new HashMap<String, Collection<AccessPolicy>>(role1.accessPolicies);
        role2.accessPolicies.forEach((key, value) -> mergedAccessPolicies.merge((String)key, (Collection<AccessPolicy>)value, Role::mergeAtBindingScopeYaml));
        return new Role(role1.name, role1.displayName(), role1.namespace, role1.internal, role1.rbacQuota, mergedAccessPolicies);
    }

    public static Collection<AccessPolicy> mergeAtBindingScope(Collection<AccessPolicy> accessPolicies1, Collection<AccessPolicy> accessPolicies2) {
        Role.validateAccessPoliciesAtBindingScope(accessPolicies1);
        Role.validateAccessPoliciesAtBindingScope(accessPolicies2);
        return Stream.concat(accessPolicies1.stream(), accessPolicies2.stream()).collect(Collectors.toMap(AccessPolicy::bindWithResource, Function.identity(), AccessPolicy::merge)).values();
    }

    public static Collection<AccessPolicy> mergeAtBindingScopeYaml(Collection<AccessPolicy> accessPolicies1, Collection<AccessPolicy> accessPolicies2) {
        Role.validateAccessPoliciesAtBindingScope(accessPolicies1);
        Role.validateAccessPoliciesAtBindingScope(accessPolicies2);
        return Stream.concat(accessPolicies1.stream(), accessPolicies2.stream()).collect(Collectors.toMap(AccessPolicy::bindWithResource, Function.identity(), AccessPolicy::mergeYaml)).values();
    }

    private static void validateAccessPoliciesAtBindingScope(Collection<AccessPolicy> accessPolicies) {
        if (accessPolicies.size() > 2) {
            throw new IllegalArgumentException("We can have at most 2 accessPolicies at a given BindingScope. accessPolicies = " + accessPolicies);
        }
        if (accessPolicies.stream().filter(AccessPolicy::bindWithResource).count() > 1L) {
            throw new IllegalArgumentException("We can have at most 1 accessPolicy at a given BindingScope with bindWithResource=true. accessPolicies = " + accessPolicies);
        }
        if (accessPolicies.stream().filter(a -> !a.bindWithResource()).count() > 1L) {
            throw new IllegalArgumentException("We can have at most 1 accessPolicy at a given BindingScope with bindWithResource=false. accessPolicies = " + accessPolicies);
        }
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public String displayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    @JsonProperty
    public String namespace() {
        return this.namespace;
    }

    @JsonProperty
    public boolean internal() {
        return this.internal;
    }

    @JsonProperty
    public RbacQuotas.RbacQuota rbacQuota() {
        return this.rbacQuota;
    }

    public boolean isInNamespace(String organization) {
        return this.namespace.equals(organization);
    }

    @JsonProperty(value="policies")
    public Map<String, Collection<AccessPolicy>> accessPolicies() {
        return this.accessPolicies;
    }

    public Collection<AccessPolicy> flatAccessPolicies() {
        return this.accessPolicies.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Set<String> bindingScopes() {
        return this.accessPolicies.keySet();
    }

    public boolean bindWithResource() {
        return this.accessPolicies.values().stream().anyMatch(policies -> policies.stream().anyMatch(AccessPolicy::bindWithResource));
    }

    void setMostSpecificBindingScope(String bindingScope) {
        this.mostSpecificBindingScope = bindingScope;
    }

    public String mostSpecificBindingScope() {
        return this.mostSpecificBindingScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role that = (Role)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.accessPolicies, that.accessPolicies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.accessPolicies);
    }

    public String toString() {
        return "Role{name='" + this.name + '\'' + ", displayName='" + this.displayName + '\'' + ", namespace='" + this.namespace + '\'' + ", internal='" + this.internal + '\'' + ", rbacQuota='" + (Object)((Object)this.rbacQuota) + '\'' + ", accessPolicies=" + this.accessPolicies + ", mostSpecificBindingScope='" + this.mostSpecificBindingScope + '\'' + '}';
    }
}

