/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.BindingScopes;
import io.confluent.security.roledefinitions.InvalidRoleDefinitionException;
import io.confluent.security.roledefinitions.RbacResourcesLoader;
import io.confluent.security.roledefinitions.Role;
import io.confluent.security.roledefinitions.RolePermissionsFilter;
import io.confluent.security.roledefinitions.Roles;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RbacRoles {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_OBJECT_MAPPER;
    private static final String CP_POLICY_FILE = "cp_rbac_roles.json";
    private static final String CP_HIERARCHY_FILE = "cp_hierarchy.json";
    private static final String CLOUD_HIERARCHY_FILE = "cloud_hierarchy.json";
    public static final String ROLE_DEFINITIONS_FOLDER = "role-definitions/";
    public static final String ROLE_PERMISSION_FILTERS_FOLDER = "role-permission-filters/";
    private BindingScopes bindingScopes;
    private final Map<String, Role> roles;
    public static final BindingScopes CP_BINDING_SCOPES;
    public static final BindingScopes CLOUD_BINDING_SCOPES;

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }

    public static ObjectMapper yamlObjectMapper() {
        return YAML_OBJECT_MAPPER;
    }

    public RbacRoles(List<Role> roles, LinkedHashMap<String, Object> bindingScopes) {
        this.bindingScopes = new BindingScopes(bindingScopes);
        this.roles = new HashMap<String, Role>();
        roles.forEach(this::addRole);
    }

    public RbacRoles(List<Role> roles, BindingScopes bindingScopes) {
        this.bindingScopes = bindingScopes;
        this.roles = new HashMap<String, Role>();
        roles.forEach(this::addRole);
    }

    public Role role(String roleName, String namespace) {
        Role role = this.roles.get(roleName);
        if (role != null && role.isInNamespace(namespace)) {
            return role;
        }
        return null;
    }

    public Role role(String roleName) {
        return this.roles.get(roleName);
    }

    public Collection<Role> roles(String namespace) {
        return this.roles.values().stream().filter(role -> role.isInNamespace(namespace)).collect(Collectors.toList());
    }

    public Collection<Role> roles() {
        return new ArrayList<Role>(this.roles.values());
    }

    public Map<String, Role> rolesMap() {
        return this.roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RbacRoles)) {
            return false;
        }
        RbacRoles that = (RbacRoles)o;
        return Objects.equals(this.roles, that.roles);
    }

    public int hashCode() {
        return Objects.hash(this.roles);
    }

    final void addRole(Role role) {
        for (Collection<AccessPolicy> accessPoliciesByScope : role.accessPolicies().values()) {
            for (AccessPolicy accessPolicy : accessPoliciesByScope) {
                if (!this.bindingScopes.isKnownScope(accessPolicy.bindingScope())) {
                    throw new InvalidRoleDefinitionException("Unknown binding scope '" + accessPolicy.bindingScope() + "' defined for " + role);
                }
                accessPolicy.allowedOperations().forEach(resourceOp -> {
                    if (resourceOp.resourceType() == null || resourceOp.resourceType().isEmpty()) {
                        throw new InvalidRoleDefinitionException("Resource type not specified in role definition ops for " + role);
                    }
                    resourceOp.operations().forEach(op -> {
                        if (op.isEmpty()) {
                            throw new InvalidRoleDefinitionException("Operation name not specified in role definition ops for " + role);
                        }
                    });
                });
            }
        }
        if (!this.bindingScopes.isPartialBindingScopePathUnique(role.bindingScopes())) {
            throw new InvalidRoleDefinitionException("Role should have binding scopes that follow a linear path in the tree");
        }
        role.setMostSpecificBindingScope(this.mostSpecificBindingScope(role));
        this.roles.put(role.name(), role);
    }

    public static RbacRoles loadRolesWithFilters(List<String> filters) {
        ArrayList<RbacRoles> listOfLoadedRoles = new ArrayList<RbacRoles>();
        for (String filter : filters) {
            listOfLoadedRoles.add(RbacResourcesLoader.loadFilteredRoles(filter));
        }
        RbacRoles mergedRbacRoles = (RbacRoles)listOfLoadedRoles.remove(0);
        for (RbacRoles rbacRole : listOfLoadedRoles) {
            mergedRbacRoles = RbacRoles.mergeYaml(mergedRbacRoles, rbacRole);
        }
        return mergedRbacRoles;
    }

    public static RbacRoles loadDefaultPolicy(boolean isConfluentCloud) throws InvalidRoleDefinitionException {
        if (isConfluentCloud) {
            return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_CORE_POLICY_FILTER.filterName());
        }
        return RbacRoles.load(Roles.class.getClassLoader(), CP_POLICY_FILE);
    }

    public static RbacRoles loadCloudPolicyWithFilters(List<String> filters) {
        ArrayList<RbacRoles> listOfLoadedRoles = new ArrayList<RbacRoles>();
        listOfLoadedRoles.add(RbacRoles.loadDefaultPolicy(true));
        for (String filter : filters) {
            listOfLoadedRoles.add(RbacResourcesLoader.loadFilteredRoles(filter));
        }
        RbacRoles mergedRbacRoles = (RbacRoles)listOfLoadedRoles.remove(0);
        for (RbacRoles rbacRole : listOfLoadedRoles) {
            mergedRbacRoles = RbacRoles.mergeYaml(mergedRbacRoles, rbacRole);
        }
        return mergedRbacRoles;
    }

    public static RbacRoles loadDataPlanePolicy() throws InvalidRoleDefinitionException {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_KAFKA_FILTER.filterName());
    }

    public static RbacRoles loadSDSPolicy() throws InvalidRoleDefinitionException {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_SDS_FILTER.filterName());
    }

    public static RbacRoles loadCatalogKafkaResourceLevelPolicy() {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_CATALOG_KAFKA_RESOURCE_FILTER.filterName());
    }

    public static RbacRoles loadSDSKsqlPolicy() {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_SDS_KSQL_FILTER.filterName());
    }

    public static RbacRoles loadSDSSetuPolicy() {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_SDS_SETU_FILTER.filterName());
    }

    public static RbacRoles loadSDSSchemaRegistryPolicy() {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_SDS_SR_FILTER.filterName());
    }

    public static RbacRoles loadRbacKekResourceOwnerPolicy() {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_RBAC_KEK_RESOURCE_OWNER_FILTER.filterName());
    }

    public static RbacRoles loadServiceAccountCreateRolesPolicy() {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_SA_CREATE_FILTER.filterName());
    }

    public static RbacRoles loadPrincipalDescribeRolesPolicy() {
        return RbacResourcesLoader.loadFilteredRoles(RolePermissionsFilter.FilterNames.CLOUD_PRINCIPAL_DESCRIBE_FILTER.filterName());
    }

    public static BindingScopes loadBindingScopes(ClassLoader classLoader, String resourceName) {
        BindingScopes bindingScopes;
        BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(resourceName), StandardCharsets.UTF_8));
        try {
            bindingScopes = (BindingScopes)RbacRoles.objectMapper().readValue((Reader)reader, BindingScopes.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidRoleDefinitionException("BindingScopes could not be loaded from " + resourceName, e);
            }
        }
        reader.close();
        return bindingScopes;
    }

    public static RbacRoles load(ClassLoader classLoader, String policyResourceName) throws InvalidRoleDefinitionException {
        return RbacRoles.load(classLoader, Collections.singletonList(policyResourceName));
    }

    public static RbacRoles load(ClassLoader classLoader, List<String> policyResourceNames) throws InvalidRoleDefinitionException {
        if (policyResourceNames.size() == 0) {
            throw new InvalidRoleDefinitionException("Invalid RBAC policies");
        }
        if (policyResourceNames.size() == 1) {
            return RbacRoles.parseRbacRoles(classLoader, policyResourceNames.get(0));
        }
        return RbacRoles.mergedRbacRoles(classLoader, policyResourceNames);
    }

    public static RbacRoles loadRbacRolesForTesting(String roleFile, String hierarchyFile) {
        RbacRoles rbacRoles;
        BindingScopes bindingScopes = RbacRoles.loadBindingScopes(BindingScopes.class.getClassLoader(), hierarchyFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader(Roles.class.getClassLoader().getResourceAsStream(roleFile), StandardCharsets.UTF_8));
        try {
            Roles roles = (Roles)RbacRoles.objectMapper().readValue((Reader)reader, Roles.class);
            rbacRoles = new RbacRoles(roles.roles, bindingScopes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InvalidRoleDefinitionException("RBAC roles could not be loaded from " + roleFile, e);
            }
        }
        reader.close();
        return rbacRoles;
    }

    public static RbacRoles mergedRbacRoles(ClassLoader classLoader, List<String> policyResourceNames) {
        List rbacRoles = policyResourceNames.stream().map(policy -> RbacRoles.parseRbacRoles(classLoader, policy)).collect(Collectors.toList());
        RbacRoles mergedRbacRoles = (RbacRoles)rbacRoles.remove(0);
        for (RbacRoles rbacRole : rbacRoles) {
            mergedRbacRoles = RbacRoles.merge(mergedRbacRoles, rbacRole);
        }
        return mergedRbacRoles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RbacRoles parseRbacRoles(ClassLoader classLoader, String policyResourceName) {
        try {
            if (policyResourceName.endsWith(".yaml")) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(ROLE_DEFINITIONS_FOLDER + policyResourceName), StandardCharsets.UTF_8));){
                    Role role = (Role)RbacRoles.yamlObjectMapper().readValue((Reader)reader, Role.class);
                    RbacRoles rbacRoles = new RbacRoles(new ArrayList<Role>(Collections.singletonList(role)), CLOUD_BINDING_SCOPES);
                    return rbacRoles;
                }
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(policyResourceName), StandardCharsets.UTF_8));){
                Roles roles = (Roles)RbacRoles.objectMapper().readValue((Reader)reader, Roles.class);
                RbacRoles rbacRoles = new RbacRoles(roles.roles, CP_BINDING_SCOPES);
                return rbacRoles;
            }
        }
        catch (IOException e) {
            throw new InvalidRoleDefinitionException("RBAC policies could not be loaded from " + policyResourceName, e);
        }
        catch (NullPointerException e) {
            throw new InvalidRoleDefinitionException("No role definition file named " + policyResourceName, e);
        }
    }

    private String mostSpecificBindingScope(Role role) {
        Set<String> roleBindingScopes = role.bindingScopes();
        return this.bindingScopes.findMostSpecificBindingScope(roleBindingScopes);
    }

    public static RbacRoles merge(RbacRoles roles1, RbacRoles roles2) {
        if (!roles1.bindingScopes.equals(roles2.bindingScopes)) {
            throw new IllegalArgumentException("bindingScopes are not equal");
        }
        HashMap<String, Role> mergedRolesMap = new HashMap<String, Role>(roles1.rolesMap());
        roles2.rolesMap().forEach((key, value) -> mergedRolesMap.merge((String)key, (Role)value, Role::merge));
        return new RbacRoles(new ArrayList<Role>(mergedRolesMap.values()), roles1.bindingScopes);
    }

    public static RbacRoles mergeYaml(RbacRoles roles1, RbacRoles roles2) {
        if (!roles1.bindingScopes.equals(roles2.bindingScopes)) {
            throw new IllegalArgumentException("bindingScopes are not equal");
        }
        HashMap<String, Role> mergedRolesMap = new HashMap<String, Role>(roles1.rolesMap());
        roles2.rolesMap().forEach((key, value) -> mergedRolesMap.merge((String)key, (Role)value, Role::mergeYaml));
        return new RbacRoles(new ArrayList<Role>(mergedRolesMap.values()), roles1.bindingScopes);
    }

    public BindingScopes bindingScopes() {
        return this.bindingScopes;
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        YAML_OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
        CP_BINDING_SCOPES = RbacRoles.loadBindingScopes(BindingScopes.class.getClassLoader(), CP_HIERARCHY_FILE);
        CLOUD_BINDING_SCOPES = RbacRoles.loadBindingScopes(BindingScopes.class.getClassLoader(), CLOUD_HIERARCHY_FILE);
    }
}

