/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.config;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    public static Properties translateDeprecated(Properties props, String[][] synonymGroups) {
        HashSet<String> synonymSet = new HashSet<String>();
        String[][] stringArray = synonymGroups;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] synonymGroup;
            for (String synonym : synonymGroup = stringArray[i]) {
                if (synonymSet.add(synonym)) continue;
                log.warn("reused synonym={}", (Object)synonym);
            }
        }
        Properties newProps = new Properties();
        Enumeration<?> keyEnumerator = props.propertyNames();
        while (keyEnumerator.hasMoreElements()) {
            String key = (String)keyEnumerator.nextElement();
            if (synonymSet.contains(key)) continue;
            newProps.put(key, props.get(key));
        }
        for (String[] synonymGroup : synonymGroups) {
            String target = synonymGroup[0];
            ArrayList<String> deprecated = new ArrayList<String>();
            for (int i = 1; i < synonymGroup.length; ++i) {
                if (!props.containsKey(synonymGroup[i])) continue;
                deprecated.add(synonymGroup[i]);
            }
            if (deprecated.isEmpty()) {
                if (!props.containsKey(target)) continue;
                newProps.put(target, props.get(target));
                continue;
            }
            StringBuilder synonymString = new StringBuilder((String)deprecated.get(0));
            for (int i = 1; i < deprecated.size(); ++i) {
                synonymString.append(", ");
                synonymString.append((String)deprecated.get(i));
            }
            if (props.containsKey(target)) {
                log.error(target + " was configured, as well as the deprecated synonym(s) " + String.valueOf(synonymString) + ".  Using the value of " + target);
                newProps.put(target, props.get(target));
                continue;
            }
            if (deprecated.size() > 1) {
                log.error("The configuration keys " + String.valueOf(synonymString) + " are deprecated and may be removed in the future.  Additionally, this configuration is ambigous because these configuration keys are all synonyms for " + target + ".  Please update your configuration to have only " + target + " set.");
                newProps.put(target, props.get(deprecated.get(0)));
                continue;
            }
            log.warn("Configuration key " + (String)deprecated.get(0) + " is deprecated and may be removed in the future.  Please update your configuration to use " + target + " instead.");
            newProps.put(target, props.get(deprecated.get(0)));
        }
        return newProps;
    }
}

