/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rm.kafka.v1;

import io.confluent.resourcemanager.api.client.Client;
import io.confluent.resourcemanager.api.client.Watcher;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ObjectMeta;
import io.confluent.rm.kafka.v1.DeletedTopic;
import io.confluent.rm.kafka.v1.DynamicConfigs;
import io.confluent.rm.kafka.v1.Partitions;
import io.confluent.rm.kafka.v1.Topic;
import io.confluent.rm.kafka.v1.TopicSpec;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmTopicClient {
    private static final Logger log = LoggerFactory.getLogger(RmTopicClient.class);
    public static String PK2C_ID_KEY = "pkc2Id";
    public static String FINALIZER_KEY = "k2-topic-protection";
    private final Client client;

    public RmTopicClient(Client client) {
        this.client = client;
    }

    public CompletableFuture<Topic> createTopic(Topic topic) {
        return this.client.create((HasMetadata)topic).execute();
    }

    public CompletableFuture<Optional<Topic>> deleteTopic(ObjectIdentifier<Topic> id) {
        return this.client.delete(id).execute();
    }

    public CompletableFuture<Optional<Topic>> getTopic(ObjectIdentifier<Topic> id) {
        return this.client.get(id).execute();
    }

    public CompletableFuture<Optional<Topic>> updateTopicPartitions(Topic topic, Partitions topicPartitions) {
        TopicSpec newSpec = topic.getSpec().toBuilder().setPartitions(topicPartitions).build();
        Topic newTopic = topic.toBuilder().setSpec(newSpec).build();
        return this.client.update((HasMetadata)newTopic).execute();
    }

    public CompletableFuture<Optional<Topic>> updateDynamicConfigs(Topic topic, DynamicConfigs dynamicConfigs) {
        TopicSpec newSpec = topic.getSpec().toBuilder().setDynamicConfigs(dynamicConfigs).build();
        Topic newTopic = topic.toBuilder().setSpec(newSpec).build();
        return this.client.update((HasMetadata)newTopic).execute();
    }

    public CompletableFuture<Optional<Topic>> removeFinalizer(Topic topic, String finalizer) {
        HashSet finalizers = new HashSet(topic.getMetadata().getFinalizersList());
        finalizers.remove(finalizer);
        ObjectMeta newMeta = topic.getMetadata().toBuilder().addAllFinalizers(finalizers).build();
        Topic newTopic = topic.toBuilder().setMetadata(newMeta).build();
        return this.client.update((HasMetadata)newTopic).execute();
    }

    public Watcher<Topic> topicWatch() {
        return this.client.watch(Topic.class);
    }

    public CompletableFuture<DeletedTopic> createDeletedTopic(DeletedTopic topic) {
        return this.client.create((HasMetadata)topic).execute();
    }

    public CompletableFuture<Optional<DeletedTopic>> deleteDeletedTopic(ObjectIdentifier<DeletedTopic> id) {
        return this.client.delete(id).execute();
    }

    public Watcher<DeletedTopic> deletedTopicWatch() {
        return this.client.watch(DeletedTopic.class);
    }
}

