/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;

public record K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState, Map<String, String> topicConfigs) {
    public K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState) {
        this(topicName, topicId, numPartitions, k2TopicLifecycleState, Collections.emptyMap());
    }

    public K2TopicMetadata {
        Objects.requireNonNull(topicName);
        Objects.requireNonNull(topicId);
        Objects.requireNonNull(k2TopicLifecycleState);
        Objects.requireNonNull(topicConfigs);
    }

    public Stream<TopicIdPartition> partitions() {
        return IntStream.range(0, this.numPartitions).mapToObj(part -> new TopicIdPartition(this.topicId, part, this.topicName));
    }

    public static enum K2TopicLifecycleState {
        CREATING,
        ONLINE,
        DELETING;

    }
}

