/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka.coordinators;

import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TransactionVersion;

public class K2TransactionCoordinator {
    public static final long FIXED_PRODUCER_ID = 0L;
    public static final short FIXED_PRODUCER_EPOCH = 0;

    public static void maybeRejectProducerIdGeneratedByK1TransactionCoordinator(long generatedK1ProducerId) {
        if (generatedK1ProducerId == 0L) {
            throw new CoordinatorLoadInProgressException("ProducerId generation failed, but the failure is temporary and should succeed upon retry");
        }
    }

    public K2TransactionResult handleInitProducerId(boolean enableTwoPC) {
        if (!enableTwoPC) {
            throw new UnsupportedVersionException(ApiKeys.INIT_PRODUCER_ID.name + " is not supported in Freight");
        }
        return new K2TransactionResult(new ProducerIdAndEpoch(0L, 0), Errors.NONE);
    }

    public K2TransactionResult handleEndTransaction(long producerId, short producerEpoch) {
        if (producerId != 0L || producerEpoch != 0) {
            throw new UnsupportedVersionException(ApiKeys.END_TXN.name + " is not supported in Freight");
        }
        return new K2TransactionResult(new ProducerIdAndEpoch(0L, 0), Errors.NONE);
    }

    public Errors handleAddPartitionsToTransaction(long producerId, short producerEpoch) {
        if (producerId != 0L || producerEpoch != 0) {
            throw new UnsupportedVersionException(ApiKeys.ADD_PARTITIONS_TO_TXN.name + " is not supported in Freight");
        }
        return Errors.NONE;
    }

    public Errors handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> authorizedPartitions, Consumer<Errors> callback, TransactionVersion txnVersion, RequestLocal requestLocal) {
        throw new UnsupportedVersionException("Adding offset is not supported for transactions on Freight clusters (should not happen).");
    }

    public Errors handleVerifyPartitionsInTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> authorizedPartitions, Consumer<AddPartitionsToTxnResponseData.AddPartitionsToTxnResult> callback) {
        throw new UnsupportedVersionException("VerifyOnly flag is not supported for transactions on Freight clusters (should not happen).");
    }

    public record K2TransactionResult(ProducerIdAndEpoch producerIdAndEpoch, Errors errors) {
    }
}

