/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.crn;

import io.confluent.crn.ConfluentResourceName;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class CrnPatternMatcher<T> {
    HashMap<String, NavigableMap<ConfluentResourceName, T>> patternsByResourceType = new HashMap();

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private CrnPatternMatcher(Map<String, Map<ConfluentResourceName, T>> patternsByResourceType) {
        patternsByResourceType.forEach((resourceType, patterns) -> this.patternsByResourceType.put((String)resourceType, new TreeMap(patterns)));
    }

    public T match(ConfluentResourceName crn) {
        Map.Entry<ConfluentResourceName, T> entry = this.matchEntry(crn);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry<ConfluentResourceName, T> matchEntry(ConfluentResourceName crn) {
        NavigableMap<ConfluentResourceName, T> skipListMap = this.patternsByResourceType.get(crn.resourceType());
        if (skipListMap == null) {
            return null;
        }
        NavigableMap<ConfluentResourceName, T> candidates = skipListMap.subMap(crn.allWildcards(), true, crn, true).descendingMap();
        for (Map.Entry candidate : candidates.entrySet()) {
            if (!((ConfluentResourceName)candidate.getKey()).matches(crn)) continue;
            return candidate;
        }
        return null;
    }

    public String toString() {
        return "CrnPatternMatcher(" + String.valueOf(this.patternsByResourceType) + ")";
    }

    public static class Builder<T> {
        Map<String, Map<ConfluentResourceName, T>> patternsByResourceType = new HashMap<String, Map<ConfluentResourceName, T>>();

        public Builder<T> setPattern(ConfluentResourceName crn, T value) {
            this.patternsByResourceType.computeIfAbsent(crn.resourceType(), k -> new HashMap()).put(crn, value);
            return this;
        }

        public CrnPatternMatcher<T> build() {
            return new CrnPatternMatcher<T>(this.patternsByResourceType);
        }
    }
}

