/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.common.security.auth.TokenProvider;
import io.confluent.common.security.auth.entity.ImpersonateTokenRequest;
import io.confluent.security.auth.client.rest.RestClient;
import io.confluent.security.auth.client.rest.RestRequest;
import io.confluent.security.auth.client.rest.entities.AuthenticationResponse;
import io.confluent.security.auth.client.rest.exceptions.RestClientException;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpersonationTokenProvider
implements TokenProvider<String> {
    private static final Logger log = LoggerFactory.getLogger(ImpersonationTokenProvider.class);
    private final RestClient restClient;
    private static final String IMPERSONATE_TOKEN_ENDPOINT = "/impersonate";
    private static final TypeReference<AuthenticationResponse> AUTHENTICATION_RESPONSE_TYPE = new TypeReference<AuthenticationResponse>(){};

    public ImpersonationTokenProvider(RestClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public String get(String principalName) {
        try {
            return this.getImpersonatedToken(principalName);
        }
        catch (Exception e) {
            log.error("Error while impersonating user {}", (Object)principalName, (Object)e);
            return null;
        }
    }

    private String getImpersonatedToken(String targetPrincipalName) throws RestClientException, URISyntaxException {
        RestRequest request = this.restClient.newRequest(IMPERSONATE_TOKEN_ENDPOINT);
        ImpersonateTokenRequest impersonateTokenRequest = new ImpersonateTokenRequest(targetPrincipalName, ImpersonateTokenRequest.PrincipalType.USER.type);
        request.setRequest((Object)impersonateTokenRequest);
        request.setRequestMethod("POST");
        request.setResponse(AUTHENTICATION_RESPONSE_TYPE);
        AuthenticationResponse response = (AuthenticationResponse)this.restClient.sendRequest(request);
        return response.authenticationToken();
    }
}

