/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth.schemaregistry;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.auth.client.provider.HttpBearerCredentialProvider;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import io.confluent.security.auth.client.rest.RestClient;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsBearerAuthProvider
implements BearerAuthCredentialProvider {
    private static final Logger log = LoggerFactory.getLogger(MdsBearerAuthProvider.class);
    private static final double TOKEN_REFRESH_RATE = 0.8;
    private ScheduledExecutorService tokenRefreshscheduler;
    private Throwable refreshError;
    private RestClient restClient;
    private OAuthBearerToken currentToken;
    private HttpCredentialProvider restClientCredentialProvider;
    private static final String USER_OPTION = "username";
    private static final String PASSWORD_OPTION = "password";
    private static final String LOGIN_SERVER_OPTION = "metadataServerUrls";
    private static final String TOKEN_OPTION = "authenticationToken";

    public void configure(Map<String, ?> props) {
        Map<String, Object> configMap = this.restClientConfigs(props);
        this.restClient = new RestClient(configMap);
        this.currentToken = this.restClient.login();
        this.refreshError = null;
        this.restClientCredentialProvider = new HttpBearerCredentialProvider();
        this.restClientCredentialProvider.configure(Collections.singletonMap("confluent.metadata.token.auth.credential", this.currentToken.value()));
        this.restClient.setCredentialProvider(this.restClientCredentialProvider);
        this.tokenRefreshscheduler = MdsBearerAuthProvider.newTokenRefreshService();
        this.scheduleNextTokenRefresh();
    }

    private static ScheduledExecutorService newTokenRefreshService() {
        return Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    public String alias() {
        return "MDS";
    }

    public String getBearerToken(URL url) {
        if (this.refreshError != null) {
            log.warn("An error occurred while trying to refresh the current token; as a result, it may be expired", this.refreshError);
        }
        return this.currentToken.value();
    }

    public void close() {
        if (this.tokenRefreshscheduler != null) {
            this.tokenRefreshscheduler.shutdown();
            try {
                if (!this.tokenRefreshscheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.tokenRefreshscheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.tokenRefreshscheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    private void scheduleNextTokenRefresh() {
        long nextRefreshTimeMs = this.currentToken.startTimeMs() + (long)((double)(this.currentToken.lifetimeMs() - this.currentToken.startTimeMs()) * 0.8);
        log.info("[Principal={}]: Expiring credential valid from {} to {}", new Object[]{this.currentToken.principalName(), new Date(this.currentToken.startTimeMs()), new Date(this.currentToken.lifetimeMs())});
        log.info("[Principal={}]: Expiring credential re-login sleeping until: {}", (Object)this.currentToken.principalName(), (Object)new Date(nextRefreshTimeMs));
        this.tokenRefreshscheduler.schedule(() -> {
            try {
                this.currentToken = this.restClient.login();
                this.restClientCredentialProvider.configure(Collections.singletonMap("confluent.metadata.token.auth.credential", this.currentToken.value()));
                this.scheduleNextTokenRefresh();
            }
            catch (Throwable t) {
                log.error("Failed to refresh token", t);
                this.refreshError = t;
            }
        }, nextRefreshTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    protected Map<String, Object> restClientConfigs(Map<String, ?> props) {
        JaasContext jaasContext = JaasContext.loadClientContext(this.extractSaslConfig(props));
        Map<String, String> moduleOptions = this.jaasConfigDef(jaasContext.configurationEntries());
        String loginServer = moduleOptions.getOrDefault(LOGIN_SERVER_OPTION, "");
        String user = moduleOptions.getOrDefault(USER_OPTION, "");
        String password = moduleOptions.getOrDefault(PASSWORD_OPTION, "");
        String token = moduleOptions.getOrDefault(TOKEN_OPTION, "");
        this.validateHaveCredentials(user, password, token);
        if (loginServer == null || loginServer.isEmpty()) {
            throw new ConfigException(String.format("Missing required configuration %s which has no default value.", LOGIN_SERVER_OPTION));
        }
        HashMap<String, Object> restClientConfig = new HashMap<String, Object>(props);
        restClientConfig.put("confluent.metadata.bootstrap.server.urls", loginServer);
        restClientConfig.put("confluent.metadata.basic.auth.user.info", user + ":" + password);
        restClientConfig.put("confluent.metadata.token.auth.credential", token);
        if (user.isEmpty()) {
            restClientConfig.put("confluent.metadata.http.auth.credentials.provider", BuiltInAuthProviders.HttpCredentialProviders.BEARER.name());
        }
        return restClientConfig;
    }

    private Map<String, Object> extractSaslConfig(Map<String, ?> configs) {
        Object saslJaasConfig;
        HashMap<String, Object> updatedConfigs = new HashMap<String, Object>(configs);
        if (updatedConfigs.containsKey("sasl.jaas.config") && (saslJaasConfig = updatedConfigs.get("sasl.jaas.config")) instanceof String) {
            updatedConfigs.put("sasl.jaas.config", new Password((String)saslJaasConfig));
        }
        return updatedConfigs;
    }

    private Map<String, String> jaasConfigDef(List<AppConfigurationEntry> jaasConfigEntries) {
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        return Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
    }

    private void validateHaveCredentials(String user, String password, String authToken) throws ConfigException {
        if (user.isEmpty() && authToken.isEmpty()) {
            throw new ConfigException("Must supply either a user or token credentials");
        }
        if (!user.isEmpty() && password.isEmpty()) {
            throw new ConfigException("Option username specified with an empty password");
        }
    }
}

