/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.JwtWithFallbackLoginService;
import io.confluent.common.security.jetty.MdsBasicLoginService;
import io.confluent.common.security.jetty.OAuthOrBasicAuthenticator;
import io.confluent.common.security.jetty.initializer.ConnectConstraintSecurityHandler;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticatorConfig;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigDef;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;

public class InstallBearerOrBasicSecurityHandler
implements Consumer<ServletContextHandler>,
Configurable {
    private BearerConfig config;

    public void configure(Map<String, ?> map) {
        HashMap rolesMap = new HashMap(map);
        rolesMap.put("authentication.roles", "**");
        this.config = new BearerConfig(rolesMap);
    }

    @Override
    public void accept(ServletContextHandler context) {
        context.setSecurityHandler((SecurityHandler)this.createOAuthOrBasicSecurityHandler());
    }

    public ConstraintSecurityHandler createOAuthOrBasicSecurityHandler() {
        String realm = this.config.getString("authentication.realm");
        ConstraintMapping globalConstraints = AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
        ConstraintSecurityHandler securityHandler = this.newConstraintSecurityHandler();
        securityHandler.addConstraintMapping(globalConstraints);
        securityHandler.setAuthenticator((Authenticator)new OAuthOrBasicAuthenticator());
        JwtLoginService jwtLoginService = new JwtLoginService(realm, new JwtAuthenticator(this.config.jwtAuthenticatorConfig()));
        MdsBasicLoginService mdsBasicLoginService = new MdsBasicLoginService(this.config.originals(), realm);
        securityHandler.setLoginService((LoginService)new JwtWithFallbackLoginService(jwtLoginService, (LoginService)mdsBasicLoginService));
        securityHandler.setIdentityService((IdentityService)new DefaultIdentityService());
        securityHandler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    private ConstraintSecurityHandler newConstraintSecurityHandler() {
        return this.config.exposeInternalConnectEndpoints() ? new ConnectConstraintSecurityHandler() : new ConstraintSecurityHandler();
    }

    public static class BearerConfig
    extends RestConfig {
        public static final String TOKEN_ISSUER_PROP = "token.issuer";
        public static final String TOKEN_ISSUER_DEFAULT = "Confluent";
        public static final String TOKEN_ISSUER_DOC = "An identifier for the token issuer.";
        public static final String TOKEN_PUBLIC_KEY_PATH_PROP = "public.key.path";
        public static final String TOKEN_PUBLIC_KEY_PATH_DOC = "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.";
        private static final String EXPOSE_INTERNAL_CONNECT_ENDPOINTS_CONFIG = "expose.internal.connect.endpoints";
        private static final boolean EXPOSE_INTERNAL_CONNECT_ENDPOINTS_DEFAULT = false;
        private static final ConfigDef CONFIG = BearerConfig.baseConfigDef().define("public.key.path", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.").define("token.issuer", ConfigDef.Type.STRING, (Object)"Confluent", ConfigDef.Importance.HIGH, "An identifier for the token issuer.").defineInternal("expose.internal.connect.endpoints", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW);

        boolean exposeInternalConnectEndpoints() {
            return this.getBoolean(EXPOSE_INTERNAL_CONNECT_ENDPOINTS_CONFIG);
        }

        public BearerConfig(Map<String, ?> originals) {
            super(CONFIG, originals);
        }

        public JwtAuthenticatorConfig jwtAuthenticatorConfig(String prefix) {
            Map authConfig = this.originalsWithPrefix(prefix, true);
            authConfig.put("jwksLocation", this.get(TOKEN_PUBLIC_KEY_PATH_PROP));
            return new JwtAuthenticatorConfig(authConfig);
        }

        public JwtAuthenticatorConfig jwtAuthenticatorConfig() {
            return this.jwtAuthenticatorConfig("");
        }
    }
}

