/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.metrics;

import io.confluent.common.security.metrics.AbstractAuthSensor;
import io.confluent.common.security.metrics.AuthenticationType;
import java.util.Map;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;

public class MdsOAuthSensor
extends AbstractAuthSensor {
    private final Sensor mdsOauthSuccessCountSensor;
    private final Sensor mdsOauthFailedCountSensor;
    private final Sensor mdsOauthSuccessLatencySensor;
    private final Sensor mdsOauthFailedLatencySensor;

    public MdsOAuthSensor(Metrics metrics, Map<String, String> configuredTags) {
        this.mdsOauthSuccessCountSensor = metrics.sensor("mdsOauthSuccessCountSensor");
        this.mdsOauthFailedCountSensor = metrics.sensor("mdsOauthFailedCountSensor");
        this.mdsOauthSuccessLatencySensor = metrics.sensor("mdsOauthSuccessLatencySensor");
        this.mdsOauthFailedLatencySensor = metrics.sensor("mdsOauthFailedLatencySensor");
        this.mdsOauthSuccessCountSensor.add(this.getMetricName("successful-auth-count", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "Total number of successful Authentications", configuredTags), (MeasurableStat)new CumulativeCount());
        this.mdsOauthFailedCountSensor.add(this.getMetricName("unsuccessful-auth-count", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "Total number of unsuccessful Authentications", configuredTags), (MeasurableStat)new CumulativeCount());
        this.mdsOauthSuccessLatencySensor.add(this.getMetricName("successful-auth-latency", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "Time taken for a successful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Value());
        this.mdsOauthFailedLatencySensor.add(this.getMetricName("unsuccessful-auth-latency", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "Time taken for an unsuccessful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Value());
        this.mdsOauthSuccessLatencySensor.add(this.getMetricName("successful-auth-latency-max", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "Maximum time taken for a successful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Max());
        this.mdsOauthSuccessLatencySensor.add(this.getMetricName("successful-auth-latency-avg", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "Average time taken for a successful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Avg());
        this.mdsOauthSuccessLatencySensor.add((CompoundStat)new Percentiles(800, 0.0, PERCENTILE_MAX_LATENCY_IN_MS, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(this.getMetricName("successful-auth-latency-95", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "The 95th percentile request latency in ms", configuredTags), 95.0), new Percentile(this.getMetricName("successful-auth-latency-99", "auth-" + AuthenticationType.MDS_OAUTH.getValue(), "The 99th percentile request latency in ms", configuredTags), 99.0)}));
    }

    public Sensor getMdsOauthSuccessCountSensor() {
        return this.mdsOauthSuccessCountSensor;
    }

    public Sensor getMdsOauthFailedCountSensor() {
        return this.mdsOauthFailedCountSensor;
    }

    public Sensor getMdsOauthSuccessLatencySensor() {
        return this.mdsOauthSuccessLatencySensor;
    }

    public Sensor getMdsOauthFailedLatencySensor() {
        return this.mdsOauthFailedLatencySensor;
    }
}

