/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.AuditJobHandle;
import io.confluent.rest.InternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditJobHandler
extends Handler.Abstract {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final AuditJobHandle auditJobHandle;
    public static final String JOB_ID = "jobId";
    public static final String STATUS = "status";
    public static final String NEW_JOB = "newJob";

    public AuditJobHandler(AuditJobHandle auditJobHandle) {
        this.auditJobHandle = auditJobHandle;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String target = request.getHttpURI().getPath();
        if (target.endsWith("/start-audit-job")) {
            log.info("Handling start-audit-job request");
            this.handleStartAuditJob(request, response);
        } else if (target.endsWith("/get-audit-job-status")) {
            log.info("Handling get-audit-job-status request");
            this.handleGetAuditJobStatus(request, response);
        } else if (target.endsWith("/stop-audit-job")) {
            log.info("Handling stop-audit-job request");
            this.handleStopAuditJob(response);
        } else {
            log.warn("Unknown target");
            this.handleUnknownTarget(response);
        }
        return true;
    }

    private void handleStartAuditJob(Request request, Response response) throws IOException {
        try (InputStream inputStream = Content.Source.asInputStream((Content.Source)request);){
            StartAuditJobRequest startAuditJobRequest = (StartAuditJobRequest)OBJECT_MAPPER.readValue(inputStream, StartAuditJobRequest.class);
            log.info("Received StartAuditJobRequest: {}", (Object)startAuditJobRequest.toString());
            Map<String, String> responseMap = this.auditJobHandle.mayBeStartAuditJob(startAuditJobRequest.topicPartitionsMap, startAuditJobRequest.jobId, startAuditJobRequest.forceStart, startAuditJobRequest.compactionCheckNeeded);
            if (!responseMap.isEmpty()) {
                boolean newJobStarted = Boolean.parseBoolean(responseMap.get(NEW_JOB));
                int jobId = Integer.parseInt(responseMap.get(JOB_ID));
                int status = Integer.parseInt(responseMap.get(STATUS));
                StartAuditJobResponse cmdResponse = new StartAuditJobResponse(jobId, status, newJobStarted);
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            } else {
                AuditJobHandler.generateErrorResponse("Failed to start audit job", response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to start audit job";
            log.error(errorMessage, (Throwable)e);
            AuditJobHandler.generateErrorResponse(errorMessage + e.getMessage(), response);
        }
    }

    private void handleGetAuditJobStatus(Request request, Response response) throws IOException {
        try (InputStream inputStream = Content.Source.asInputStream((Content.Source)request);){
            GetAuditJobStatusRequest getAuditJobStatusRequest = (GetAuditJobStatusRequest)OBJECT_MAPPER.readValue(inputStream, GetAuditJobStatusRequest.class);
            log.info("Received GetAuditJobStatusRequest: {}", (Object)getAuditJobStatusRequest.toString());
            if (getAuditJobStatusRequest.detail) {
                Map<String, Map<String, String>> detail = this.auditJobHandle.mayBeGetAuditJobStatusDetail();
                log.info("detail status size " + detail.size());
                ArrayList<PartitionStatus> partitionStatusList = new ArrayList<PartitionStatus>();
                for (String key : detail.keySet()) {
                    if (key.equals(JOB_ID)) continue;
                    Map<String, String> partitionStatusMap = detail.get(key);
                    PartitionStatus partitionStatus = new PartitionStatus(partitionStatusMap.get("topicName"), Integer.parseInt(partitionStatusMap.get("partition")), Integer.parseInt(partitionStatusMap.get("totalOffsetCount")), Integer.parseInt(partitionStatusMap.get("totalGapCount")));
                    partitionStatusList.add(partitionStatus);
                }
                log.info("partition status list size " + partitionStatusList.size());
                GetAuditJobStatusDetail cmdResponse = new GetAuditJobStatusDetail(partitionStatusList, Integer.parseInt(detail.get(JOB_ID).get(JOB_ID)));
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            } else {
                Map<String, String> summary = this.auditJobHandle.mayBeGetAuditJobStatusSummary();
                GetAuditJobStatusResponseSummary cmdResponse = new GetAuditJobStatusResponseSummary(Integer.parseInt(summary.get(JOB_ID)), Integer.parseInt(summary.get("topicPartitionsRequested")), summary.get(STATUS), Integer.parseInt(summary.get("topicPartitionScannedSuccess")), Integer.parseInt(summary.get("topicPartitionSkipped")), Integer.parseInt(summary.get("topicPartitionScanned")), Integer.parseInt(summary.get("totalTierCompactedPartitionsRequested")), Integer.parseInt(summary.get("totalOffsetCountAcrossPartitions")), Integer.parseInt(summary.get("totalGapCountAcrossPartitions")), Integer.parseInt(summary.get("totalTimeTakeInMillis")), summary.get("jobType"), summary.get("startTime"), summary.get("completionTime"));
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to get audit job status";
            log.error(errorMessage, (Throwable)e);
            AuditJobHandler.generateErrorResponse(errorMessage + e.getMessage(), response);
        }
    }

    private void handleStopAuditJob(Response response) throws IOException {
        try {
            Map<String, String> responseMap = this.auditJobHandle.mayBeStopAuditJob();
            if (!responseMap.isEmpty()) {
                int status = Integer.parseInt(responseMap.get(STATUS));
                int jobId = Integer.parseInt(responseMap.get(JOB_ID));
                StopAuditJobResponse cmdResponse = new StopAuditJobResponse(jobId, status);
                ResponseContainer.dataResponse(cmdResponse).write(OBJECT_MAPPER, response);
            } else {
                AuditJobHandler.generateErrorResponse("Failed to stop audit job", response);
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to stop audit job";
            log.error(errorMessage, (Throwable)e);
            AuditJobHandler.generateErrorResponse(errorMessage + e.getMessage(), response);
        }
    }

    private void handleUnknownTarget(Response response) throws IOException {
        AuditJobHandler.generateErrorResponse("Unknown command", response);
    }

    private static void generateErrorResponse(String message, Response response) throws IOException {
        log.error("send error message to rest client: " + message);
        ResponseContainer.ErrorResponse errResponse = new ResponseContainer.ErrorResponse(0, 500, message);
        ResponseContainer<?> responseContainer = ResponseContainer.errorResponse(Collections.singletonList(errResponse));
        responseContainer.write(OBJECT_MAPPER, response);
    }

    static final class StartAuditJobRequest {
        @JsonProperty(value="topic_partitions_map")
        final Map<String, Set<Integer>> topicPartitionsMap;
        @JsonProperty(value="job_id")
        final int jobId;
        @JsonProperty(value="force_start")
        final boolean forceStart;
        @JsonProperty(value="compaction_check_needed")
        final boolean compactionCheckNeeded;

        @JsonCreator
        public StartAuditJobRequest(@JsonProperty(value="topic_partitions_map", required=true) Map<String, Set<Integer>> topicPartitionsMap, @JsonProperty(value="job_id", required=true) int jobId, @JsonProperty(value="force_start", required=true) boolean forceStart, @JsonProperty(value="compaction_check_needed", required=true) boolean compactionCheckNeeded) {
            this.topicPartitionsMap = topicPartitionsMap;
            this.jobId = jobId;
            this.forceStart = forceStart;
            this.compactionCheckNeeded = compactionCheckNeeded;
        }

        public String toString() {
            return "StartAuditJobRequest{topicPartitions=" + this.topicPartitionsMap.toString() + "jobId=" + this.jobId + "forceStart=" + this.forceStart + "compactionCheckNeeded=" + this.compactionCheckNeeded + "}";
        }
    }

    static final class StartAuditJobResponse {
        @JsonProperty(value="jobId")
        final Integer jobId;
        @JsonProperty(value="status")
        final Integer status;
        @JsonProperty(value="newJob")
        final Boolean newJobStarted;

        @JsonCreator
        public StartAuditJobResponse(@JsonProperty(value="jobId") Integer jobId, @JsonProperty(value="status", required=true) Integer status, @JsonProperty(value="newJob", required=true) Boolean newJobStarted) {
            this.jobId = jobId;
            this.status = status;
            this.newJobStarted = newJobStarted;
        }

        public String toString() {
            return "StartAuditJobResponse{jobId=" + this.jobId + "status=" + this.status + "newJobStarted=" + this.newJobStarted + "}";
        }
    }

    static final class GetAuditJobStatusRequest {
        @JsonProperty(value="detail")
        final boolean detail;

        @JsonCreator
        public GetAuditJobStatusRequest(@JsonProperty(value="detail", required=true) boolean detail) {
            this.detail = detail;
        }

        public String toString() {
            return "GetAuditJobStatusRequest{detail=" + this.detail + "}";
        }
    }

    static final class PartitionStatus {
        @JsonProperty(value="topicName")
        final String topicName;
        @JsonProperty(value="partition")
        final Integer partition;
        @JsonProperty(value="totalOffsetCount")
        final Integer totalOffsetCount;
        @JsonProperty(value="totalGapCount")
        final Integer totalGapCount;

        @JsonCreator
        public PartitionStatus(@JsonProperty(value="topicName", required=true) String topicName, @JsonProperty(value="partition", required=true) Integer partition, @JsonProperty(value="totalOffsetCount", required=true) Integer totalOffsetCount, @JsonProperty(value="totalGapCount", required=true) Integer totalGapCount) {
            this.topicName = topicName;
            this.partition = partition;
            this.totalOffsetCount = totalOffsetCount;
            this.totalGapCount = totalGapCount;
        }

        public String toString() {
            return "PartitionStatus{topicName=" + this.topicName + "partition=" + this.partition + "totalOffsetCount=" + this.totalOffsetCount + "totalGapCount=" + this.totalGapCount + "}";
        }
    }

    static final class GetAuditJobStatusDetail {
        @JsonProperty(value="partitionStatusList")
        final List<PartitionStatus> partitionStatusList;
        @JsonProperty(value="jobId")
        final Integer jobId;

        @JsonCreator
        public GetAuditJobStatusDetail(@JsonProperty(value="partitionStatusList", required=true) List<PartitionStatus> partitionStatusList, @JsonProperty(value="jobId", required=true) Integer jobId) {
            this.partitionStatusList = partitionStatusList;
            this.jobId = jobId;
        }

        public String toString() {
            return "GetAuditJobStatusDetail{partitionStatusList=" + String.valueOf(this.partitionStatusList) + "jobId=" + this.jobId + "}";
        }
    }

    static final class GetAuditJobStatusResponseSummary {
        @JsonProperty(value="jobId")
        final Integer jobId;
        @JsonProperty(value="topicPartitionsRequested")
        final Integer topicPartitionsRequested;
        @JsonProperty(value="status")
        final String status;
        @JsonProperty(value="topicPartitionScannedSuccess")
        final Integer topicPartitionScannedSuccess;
        @JsonProperty(value="topicPartitionSkipped")
        final Integer topicPartitionSkipped;
        @JsonProperty(value="topicPartitionScanned")
        final Integer topicPartitionScanned;
        @JsonProperty(value="totalTierCompactedPartitionsRequested")
        final Integer totalTierCompactedPartitionsRequested;
        @JsonProperty(value="totalOffsetCountAcrossPartitions")
        final Integer totalOffsetCountAcrossPartitions;
        @JsonProperty(value="totalGapCountAcrossPartitions")
        final Integer totalGapCountAcrossPartitions;
        @JsonProperty(value="totalTimeTakeInMillis")
        final Integer totalTimeTakeInMillis;
        @JsonProperty(value="jobType")
        final String jobType;
        @JsonProperty(value="startTime")
        final String startTime;
        @JsonProperty(value="completionTime")
        final String completionTime;

        @JsonCreator
        public GetAuditJobStatusResponseSummary(@JsonProperty(value="jobId", required=true) Integer jobId, @JsonProperty(value="topicPartitionsRequested", required=true) Integer topicPartitionsRequested, @JsonProperty(value="status", required=true) String status, @JsonProperty(value="topicPartitionScannedSuccess", required=true) Integer topicPartitionScannedSuccess, @JsonProperty(value="topicPartitionSkipped", required=true) Integer topicPartitionSkipped, @JsonProperty(value="topicPartitionScanned", required=true) Integer topicPartitionScanned, @JsonProperty(value="totalTierCompactedPartitionsRequested", required=true) Integer totalTierCompactedPartitionsRequested, @JsonProperty(value="totalOffsetCountAcrossPartitions", required=true) Integer totalOffsetCountAcrossPartitions, @JsonProperty(value="totalGapCountAcrossPartitions", required=true) Integer totalGapCountAcrossPartitions, @JsonProperty(value="totalTimeTakeInMillis", required=true) Integer totalTimeTakeInMillis, @JsonProperty(value="jobType", required=true) String jobType, @JsonProperty(value="startTime", required=true) String startTime, @JsonProperty(value="completionTime", required=true) String completionTime) {
            this.jobId = jobId;
            this.topicPartitionsRequested = topicPartitionsRequested;
            this.status = status;
            this.topicPartitionScannedSuccess = topicPartitionScannedSuccess;
            this.topicPartitionSkipped = topicPartitionSkipped;
            this.topicPartitionScanned = topicPartitionScanned;
            this.totalTierCompactedPartitionsRequested = totalTierCompactedPartitionsRequested;
            this.totalOffsetCountAcrossPartitions = totalOffsetCountAcrossPartitions;
            this.totalGapCountAcrossPartitions = totalGapCountAcrossPartitions;
            this.totalTimeTakeInMillis = totalTimeTakeInMillis;
            this.jobType = jobType;
            this.startTime = startTime;
            this.completionTime = completionTime;
        }

        public String toString() {
            return "GetAuditJobStatusResponseSummary{jobId=" + this.jobId + "topicPartitionsRequested=" + this.topicPartitionsRequested + "status=" + this.status + "topicPartitionScannedSuccess=" + this.topicPartitionScannedSuccess + "topicPartitionSkipped=" + this.topicPartitionSkipped + "topicPartitionScanned=" + this.topicPartitionScanned + "totalTierCompactedPartitionsRequested=" + this.totalTierCompactedPartitionsRequested + "totalOffsetCountAcrossPartitions=" + this.totalOffsetCountAcrossPartitions + "totalGapCountAcrossPartitions=" + this.totalGapCountAcrossPartitions + "totalTimeTakeInMillis=" + this.totalTimeTakeInMillis + "jobType=" + this.jobType + "startTime=" + this.startTime + "completionTime=" + this.completionTime + "}";
        }
    }

    static final class StopAuditJobResponse {
        @JsonProperty(value="jobId")
        final Integer jobId;
        @JsonProperty(value="status")
        final Integer status;

        @JsonCreator
        public StopAuditJobResponse(@JsonProperty(value="jobId") Integer jobId, @JsonProperty(value="status", required=true) Integer status) {
            this.jobId = jobId;
            this.status = status;
        }

        public String toString() {
            return "StopAuditJobResponse{jobId=" + this.jobId + "status=" + this.status + "}";
        }
    }
}

