/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.ParsedSchemaAndValue;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import java.util.Objects;
import org.apache.avro.generic.GenericContainer;

public class GenericContainerWithVersion
implements ParsedSchemaAndValue {
    private final AvroSchema schema;
    private final GenericContainer container;
    private final Integer version;

    public GenericContainerWithVersion(GenericContainer container, Integer version) {
        this.schema = new AvroSchema(container.getSchema());
        this.container = container;
        this.version = version;
    }

    public GenericContainerWithVersion(AvroSchema schema, GenericContainer container, Integer version) {
        this.schema = schema;
        this.container = container;
        this.version = version;
    }

    public ParsedSchema getSchema() {
        return this.schema;
    }

    public Object getValue() {
        return this.container;
    }

    public GenericContainer container() {
        return this.container;
    }

    public Integer version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericContainerWithVersion that = (GenericContainerWithVersion)o;
        return Objects.equals(this.container, that.container) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.version);
    }
}

