/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.oauth;

import io.confluent.kafka.clients.plugins.auth.oauth.ClusterLinkHttpAccessTokenRetriever;
import io.confluent.kafka.clients.plugins.auth.oauth.FilteringDnsResolver;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;

public class ClusterLinkAccessTokenRetrieverFactory {
    public static AccessTokenRetriever create(Map<String, ?> configs, Map<String, Object> jaasConfig) {
        return ClusterLinkAccessTokenRetrieverFactory.create(configs, null, jaasConfig);
    }

    public static AccessTokenRetriever create(Map<String, ?> configs, String saslMechanism, Map<String, Object> jaasConfig) {
        boolean hasViolatingIpAddress;
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        URL tokenEndpointUrl = cu.validateUrl("sasl.oauthbearer.token.endpoint.url");
        if (tokenEndpointUrl.getProtocol().toLowerCase(Locale.ROOT).equals("file")) {
            throw new PolicyViolationException("sasl.oauthbearer.token.endpoint.url=" + String.valueOf(tokenEndpointUrl) + " contains unsupported protocol 'file', only http and https are supported.");
        }
        JaasOptionsUtils jou = new JaasOptionsUtils(jaasConfig);
        String clientId = jou.validateString("clientId");
        String clientSecret = jou.validateString("clientSecret");
        String scope = jou.validateString("scope", false);
        SSLSocketFactory sslSocketFactory = null;
        if (jou.shouldCreateSSLSocketFactory(tokenEndpointUrl)) {
            sslSocketFactory = jou.createSSLSocketFactory();
        }
        try {
            FilteringDnsResolver dnsResolver = new FilteringDnsResolver(true, true, true, Collections.emptyList(), Collections.emptyList());
            hasViolatingIpAddress = dnsResolver.hasViolatingIpAddress(tokenEndpointUrl.getHost());
        }
        catch (UnknownHostException e) {
            throw new KafkaException("Failed to resolve tokenEndpointUrl: " + String.valueOf(tokenEndpointUrl) + ": " + String.valueOf(e));
        }
        if (hasViolatingIpAddress) {
            throw new PolicyViolationException("tokenEndpointUrl: " + String.valueOf(tokenEndpointUrl) + " contains invalid IP address");
        }
        return new ClusterLinkHttpAccessTokenRetriever(clientId, clientSecret, scope, sslSocketFactory, tokenEndpointUrl.toString(), cu.validateLong("sasl.login.retry.backoff.ms"), cu.validateLong("sasl.login.retry.backoff.max.ms"), cu.validateInteger("sasl.login.connect.timeout.ms", false), cu.validateInteger("sasl.login.read.timeout.ms", false), (Boolean)cu.get("sasl.oauthbearer.header.urlencode"));
    }
}

