/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication;

public class AuthenticationExceptionReasonCodes {
    public static final String INCORRECT_AUTHENTICATOR_TYPE = "INCORRECT_AUTHENTICATOR_TYPE";
    public static final String IDENTITY_POOL_NOT_FOUND = "IDENTITY_POOL_NOT_FOUND";
    public static final String NO_VALID_IDENTITY_PROVIDER_FOUND = "NO_VALID_IDENTITY_PROVIDER_FOUND";
    public static final String NO_VALID_IDENTITY_POOLS_FOUND = "NO_VALID_IDENTITY_POOLS_FOUND";
    public static final String CLAIM_ISSUER_POOL_FILTER_MISMATCH = "CLAIM_ISSUER_POOL_FILTER_MISMATCH";
    public static final String CLAIMS_POOL_FILTER_MISMATCH = "CLAIMS_POOL_FILTER_MISMATCH";
    public static final String ORG_ID_POOL_FILTER_MISMATCH = "ORG_ID_POOL_FILTER_MISMATCH";
    public static final String IDENTITY_POOL_IDENTITY_CLAIM_ABSENT_IN_CLAIMS = "IDENTITY_POOL_IDENTITY_CLAIM_ABSENT_IN_CLAIMS";
    public static final String TOKEN_VALUE_ABSENT = "TOKEN_VALUE_ABSENT";
    public static final String FAILED_TO_READ_CLAIMS = "FAILED_TO_READ_CLAIMS";
    public static final String CLUSTER_NOT_FOUND = "CLUSTER_NOT_FOUND";
    public static final String CLUSTER_NOT_ALLOWED = "CLUSTER_NOT_ALLOWED";
    public static final String CLUSTER_ID_MISSING_OR_EMPTY = "CLUSTER_ID_MISSING_OR_EMPTY";
    public static final String SNI_ID_CLUSTER_ID_MISMATCH = "SNI_ID_CLUSTER_ID_MISMATCH";
    public static final String NETWORK_ID_DISALLOWED = "NETWORK_ID_DISALLOWED";
    public static final String DATA_POLICY_DISALLOWED = "DATA_POLICY_DISALLOWED";
    public static final String ORG_ID_CLUSTER_ID_MISMATCH = "ORG_ID_CLUSTER_ID_MISMATCH";
    public static final String BAD_POOL_EXTENSION = "IMPROPERLY_FORMATTED_IDENTITY_POOL_EXTENSION";
    public static final String INVALID_POOL_ID = "INVALID_POOL_ID";
    public static final String POOL_PROVIDER_LIST_MISMATCH = "LIST_OF_POOLS_HAS_MULTIPLE_PROVIDERS";
    public static final String AUD_CLAIM_MISMATCH = "AUD_CLAIM_MISMATCH";
    public static final String ISSUER_INVALID = "ISSUER_INVALID";
    public static final String CALLING_RESOURCE_IDENTITY_MISSING_OR_EMPTY = "CALLING_RESOURCE_IDENTITY_MISSING_OR_EMPTY";
    public static final String TOKEN_ISSUER_CLAIM_ABSENT = "TOKEN_ISSUER_CLAIM_ABSENT";
    public static final String TOKEN_ISSUER_CLAIM_UNRECOGNIZED = "TOKEN_ISSUER_UNRECOGNIZED";
    public static final String TOKEN_PROCESSING_FAILURE = "TOKEN_PROCESSING_FAILURE";

    public static enum ErrorTypes {
        JWT_EXPIRED("JWT is expired"),
        JWT_EXP_CLAIM_MISSING("JWT exp claim missing"),
        JWT_IAT_CLAIM_MISSING("JWT iat claim missing"),
        JWT_NBF_CLAIM_MISSING("JWT nbf claim missing"),
        JWT_EXP_CLAIM_TOO_FAR_IN_FUTURE("JWT exp claim too far in the future"),
        JWT_NBF_CLAIM_NOT_VALID_YET("JWT nbf claim is not valid yet"),
        JWT_AUD_CLAIM_MISSING("JWT aud claim missing"),
        JWT_AUD_CLAIM_INVALID("JWT aud claim has unexpected value"),
        JWT_SIGNATURE_VERIFICATION_FAILED("JWT signature could not be verified"),
        JWT_SIGNATURE_MISSING("JWT signature missing"),
        JWT_ISS_CLAIM_MISSING("JWT iss claim missing"),
        JWT_ISS_CLAIM_INVALID("JWT iss claim has unexpected value"),
        JWT_JTI_CLAIM_MISSING("JWT jti claim missing"),
        JWT_SUB_CLAIM_MISSING("JWT sub claim missing"),
        JWT_SUB_CLAIM_INVALID("JWT sub claim has unexpected value"),
        JWT_PAYLOAD_JSON_INVALID("JWT payload could not be parsed as valid JSON"),
        JWT_PROCESSING_FAILED("JWT processing failed"),
        JWT_CLAIM_MALFORMED("JWT claim is of incorrect type or malformed"),
        JWT_ENCRYPTION_MISSING("JWT encryption missing"),
        JWT_INTEGRITY_PROTECTION_MISSING("JWT integrity protection required by algorithm missing"),
        JWT_TYP_CLAIM_MISSING("JWT typ claim missing"),
        JWT_TYP_CLAIM_INVALID("JWT typ claim has unexpected value"),
        JWT_IAT_CLAIM_TOO_FAR_IN_FUTURE("JWT iat claim is too far in the future"),
        JWT_IAT_CLAIM_TOO_FAR_IN_PAST("JWT iat claim is too far in the past"),
        JWT_HEADER_KID_LOOKUP_FAILED("JWT header field kid has no mapped public keys"),
        JWT_HEADER_ALG_INVALID("JWT header field alg is not allow listed"),
        JWT_HEADER_JKU_INVALID("JWT header field jku is invalid"),
        JWT_ISS_CLAIM_LOOKUP_FAILED("JWT iss claim could not be found in the system"),
        AUTHENTICATION_EXCEPTION("Authentication Exception"),
        ILLEGAL_ARGUMENT_EXCEPTION("Illegal Argument Exception"),
        JWT_UNKNOWN_ERROR("Unknown JWT error");

        private final String msg;

        private ErrorTypes(String msg) {
            this.msg = msg;
        }

        public String toString() {
            return this.msg;
        }
    }
}

