/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.security.PemKey;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyJwks {
    private static final Logger log = LoggerFactory.getLogger(PublicKeyJwks.class);
    private final List<JsonWebKey> jwks;

    public PublicKeyJwks(Collection<PublicKey> publicKeys) {
        if (publicKeys == null || publicKeys.isEmpty()) {
            throw new ConfigException("At least 1 PublicKey must be provided");
        }
        this.jwks = publicKeys.stream().map(PublicKeyJwks::tryConvertKey).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (this.jwks.isEmpty()) {
            throw new ConfigException("Failed to convert PublicKey(s) to JsonWebKey collection");
        }
    }

    public static Collection<PublicKey> loadPublicKey(String pemLocation) throws IOException {
        if (pemLocation == null || pemLocation.isEmpty()) {
            throw new ConfigException("Missing required PEM file location");
        }
        return PublicKeyJwks.getPublicKeyPaths(Paths.get(pemLocation, new String[0])).stream().map(PemKey::readPublicKey).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public List<JsonWebKey> getJsonWebKeys() {
        return Collections.unmodifiableList(this.jwks);
    }

    private static Optional<JsonWebKey> tryConvertKey(PublicKey publicKey) {
        try {
            return Optional.of(JsonWebKey.Factory.newJwk((Key)publicKey));
        }
        catch (JoseException e) {
            log.error("Unable to convert public key", (Throwable)e);
            return Optional.empty();
        }
    }

    private static List<Path> getPublicKeyPaths(Path pemPath) throws IOException {
        if (Files.isRegularFile(pemPath, new LinkOption[0])) {
            return Collections.singletonList(pemPath);
        }
        ArrayList<Path> keys = new ArrayList<Path>();
        Files.newDirectoryStream(pemPath, "*.pem").forEach(keys::add);
        return keys;
    }
}

