/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryMojo;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="set-compatibility", configurator="custom-basic")
public class SetCompatibilityMojo
extends SchemaRegistryMojo {
    @Parameter(required=true)
    Map<String, String> compatibilityLevels = new HashMap<String, String>();

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Plugin execution has been skipped");
            return;
        }
        for (Map.Entry<String, String> entry : this.compatibilityLevels.entrySet()) {
            if (entry.getValue().equalsIgnoreCase("null")) {
                this.deleteConfig(entry.getKey());
                continue;
            }
            this.updateConfig(entry.getKey(), CompatibilityLevel.valueOf((String)entry.getValue()));
        }
    }

    public void updateConfig(String subject, CompatibilityLevel compatibility) throws MojoExecutionException {
        try {
            if (subject.equalsIgnoreCase("null") || subject.equals("__GLOBAL")) {
                String updatedCompatibility = this.client().updateCompatibility(null, compatibility.toString());
                this.getLog().info((CharSequence)("Global Compatibility set to " + updatedCompatibility));
            } else {
                Collection allSubjects = this.client().getAllSubjects();
                if (!allSubjects.contains(subject)) {
                    throw new MojoExecutionException("Subject not found");
                }
                String updatedCompatibility = this.client().updateCompatibility(subject, compatibility.toString());
                this.getLog().info((CharSequence)("Compatibility of " + subject + " set to " + updatedCompatibility));
            }
        }
        catch (RestClientException | IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Exception thrown while updating config", (Exception)e);
        }
    }

    public void deleteConfig(String subject) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)"Deleting compatibility");
        }
        try {
            this.client().deleteCompatibility(subject);
            if (subject.equalsIgnoreCase("null") || subject.equals("__GLOBAL")) {
                this.getLog().info((CharSequence)"Deleted global compatibility");
            } else {
                this.getLog().info((CharSequence)String.format("Deleted compatibility of %s", subject));
            }
        }
        catch (RestClientException | IOException e) {
            throw new MojoExecutionException("Exception thrown while updating config", (Exception)e);
        }
    }

    public String getConfig(String subject) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)String.format("Getting compatibility of %s", subject));
        }
        try {
            return String.format(this.client().getCompatibility(subject), new Object[0]);
        }
        catch (RestClientException | IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Exception thrown while getting config", (Exception)e);
        }
    }
}

