/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.MutableHttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.MDC;

public class RequestIdHandler
extends HandlerWrapper {
    public static final String REQUEST_ID_HEADER = "X-Request-ID";

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MDC.clear();
        MutableHttpServletRequest mutableRequest = new MutableHttpServletRequest(request);
        ArrayList<String> inputHeaders = Collections.list(baseRequest.getHeaders(REQUEST_ID_HEADER));
        String requestId = this.getRequestId(inputHeaders);
        mutableRequest.putHeader(REQUEST_ID_HEADER, requestId);
        response.setHeader(REQUEST_ID_HEADER, requestId);
        MDC.put((String)"requestId", (String)requestId);
        super.handle(target, baseRequest, (HttpServletRequest)mutableRequest, response);
    }

    protected String getRequestId(List<String> headers) {
        if (headers.size() == 1 && StringUtil.isNotBlank((String)headers.get(0))) {
            return headers.get(0);
        }
        return UUID.randomUUID().toString();
    }
}

