/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.filters;

import io.confluent.kafka.schemaregistry.metrics.SchemaRegistryMetric;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

public class RestCallMetricFilter
implements ContainerResponseFilter {
    private final SchemaRegistryMetric metricSucceeded;
    private final SchemaRegistryMetric metricFailed;

    public RestCallMetricFilter(SchemaRegistryMetric metricSucceeded, SchemaRegistryMetric metricFailed) {
        this.metricSucceeded = metricSucceeded;
        this.metricFailed = metricFailed;
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        switch (containerResponseContext.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                this.metricSucceeded.record();
                break;
            }
            case CLIENT_ERROR: 
            case SERVER_ERROR: {
                this.metricFailed.record();
                break;
            }
        }
    }
}

