/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import java.util.Iterator;

public class FilteredIterator<T>
implements CloseableIterator<T> {
    final CloseableIterator<T> backingIterator;
    final Iterator<T> filteredIterator;

    public static <T> CloseableIterator<T> filter(CloseableIterator<T> fromIterator, Predicate<? super T> predicate) {
        return new FilteredIterator<T>(fromIterator, predicate);
    }

    FilteredIterator(CloseableIterator<T> backingIterator, Predicate<? super T> predicate) {
        this.backingIterator = backingIterator;
        this.filteredIterator = Iterators.filter(backingIterator, predicate);
    }

    @Override
    public final boolean hasNext() {
        return this.filteredIterator.hasNext();
    }

    @Override
    public final T next() {
        return this.filteredIterator.next();
    }

    @Override
    public final void remove() {
        this.filteredIterator.remove();
    }

    @Override
    public final void close() {
        this.backingIterator.close();
    }
}

