/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import kafka.security.JaasTestUtils;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.junit.jupiter.api.AfterEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLClusterTestHarness
extends ClusterTestHarness {
    public static final String JAAS_CONF = "java.security.auth.login.config";
    public static final String ZK_AUTH_PROVIDER = "zookeeper.authProvider.1";
    private MiniKdc kdc = null;
    private File kdcHome = TestUtils.tempDir();
    private Properties kdcProps = MiniKdc.createConfig();
    private static final Logger log = LoggerFactory.getLogger(SASLClusterTestHarness.class);

    public SASLClusterTestHarness() {
        super(1);
    }

    @Override
    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    @Override
    protected void setUp() throws Exception {
        LoginManager.closeAll();
        File serverKeytab = File.createTempFile("server-", ".keytab");
        File clientKeytab = File.createTempFile("client-", ".keytab");
        Optional<File> serverKeytabOption = Optional.of(serverKeytab);
        Optional<File> clientKeytabOption = Optional.of(clientKeytab);
        List<String> serverSaslMechanisms = Arrays.asList("GSSAPI");
        Optional<String> clientSaslMechanism = Optional.of("GSSAPI");
        ArrayList<JaasTestUtils.JaasSection> jaasSections = new ArrayList<JaasTestUtils.JaasSection>();
        jaasSections.add(JaasTestUtils.kafkaServerSection((String)"KafkaServer", serverSaslMechanisms, serverKeytabOption));
        jaasSections.add(JaasTestUtils.kafkaClientSection(clientSaslMechanism, clientKeytabOption));
        String jaasFilePath = JaasTestUtils.writeJaasContextsToFile(jaasSections).getAbsolutePath();
        log.info("Using KDC home: {}", (Object)this.kdcHome.getAbsolutePath());
        this.kdc = new MiniKdc(this.kdcProps, this.kdcHome);
        this.kdc.start();
        this.createPrincipal(serverKeytab, "kafka/localhost");
        this.createPrincipal(clientKeytab, "client");
        this.createPrincipal(clientKeytab, "client2");
        Configuration.setConfiguration(null);
        System.setProperty(JAAS_CONF, jaasFilePath);
        System.setProperty(ZK_AUTH_PROVIDER, "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp();
    }

    private void createPrincipal(File keytab, String principalNoRealm) throws Exception {
        this.kdc.createPrincipal(keytab, Arrays.asList(principalNoRealm));
    }

    @Override
    protected KafkaConfig getKafkaConfig(int brokerId) {
        Optional<File> trustStoreFileOption = Optional.empty();
        Optional<SecurityProtocol> saslInterBrokerSecurityProtocol = Optional.of(SecurityProtocol.SASL_PLAINTEXT);
        Properties props = SASLClusterTestHarness.createBrokerConfig(brokerId, false, false, TestUtils.RandomPort(), saslInterBrokerSecurityProtocol, trustStoreFileOption, EMPTY_SASL_PROPERTIES, false, true, TestUtils.RandomPort(), false, TestUtils.RandomPort(), false, TestUtils.RandomPort(), Optional.empty(), false, 1, (short)1, false);
        this.injectProperties(props);
        props.setProperty("sasl.mechanism.inter.broker.protocol", "GSSAPI");
        props.setProperty("sasl.enabled.mechanisms", "GSSAPI");
        return KafkaConfig.fromProps((Properties)props);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.kdc != null) {
            this.kdc.stop();
        }
        LoginManager.closeAll();
        System.clearProperty(JAAS_CONF);
        System.clearProperty(ZK_AUTH_PROVIDER);
        Configuration.setConfiguration(null);
        super.tearDown();
    }
}

