/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestSslUtils;

public class SSLClusterTestHarness
extends ClusterTestHarness {
    public Map<String, Object> clientSslConfigs;

    public SSLClusterTestHarness() {
        super(1);
    }

    @Override
    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SSL;
    }

    @Override
    protected KafkaConfig getKafkaConfig(int brokerId) {
        File trustStoreFile;
        try {
            trustStoreFile = File.createTempFile("SSLClusterTestHarness-truststore", ".jks");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary file for the truststore.");
        }
        Optional<File> trustStoreFileOption = Optional.of(trustStoreFile);
        Optional<SecurityProtocol> sslInterBrokerSecurityProtocol = Optional.of(SecurityProtocol.SSL);
        Properties props = SSLClusterTestHarness.createBrokerConfig(brokerId, false, false, TestUtils.RandomPort(), sslInterBrokerSecurityProtocol, trustStoreFileOption, EMPTY_SASL_PROPERTIES, false, false, TestUtils.RandomPort(), true, TestUtils.RandomPort(), false, TestUtils.RandomPort(), Optional.empty(), false, 1, (short)1, false);
        try {
            this.clientSslConfigs = TestSslUtils.createSslConfig((boolean)true, (boolean)true, (ConnectionMode)ConnectionMode.CLIENT, (File)trustStoreFile, (String)"client", (String)"localhost");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.injectProperties(props);
        if (this.requireSSLClientAuth()) {
            props.setProperty("ssl.client.auth", "required");
        }
        return KafkaConfig.fromProps((Properties)props);
    }

    protected boolean requireSSLClientAuth() {
        return true;
    }
}

