/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiSchemaTooLargeTest
extends ClusterTestHarness {
    private static final String schema = "{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}";

    public RestApiSchemaTooLargeTest() {
        super(1, true);
    }

    @Test
    public void testSchemaTooLarge() throws Exception {
        String subject = "testTopic1";
        try {
            this.restApp.restClient.registerSchema(schema, subject);
            Assertions.fail((String)"Registering a schema should return 40401");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus());
            Assertions.assertEquals((int)42209, (int)e.getErrorCode());
        }
    }

    @Override
    protected void injectProperties(Properties props) {
        super.injectProperties(props);
        props.setProperty("message.max.bytes", "900");
    }
}

