/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.rest.SecureTestUtils;
import java.io.File;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.security.auth.login.Configuration;
import org.apache.avro.Schema;
import org.apache.kafka.common.config.types.Password;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiSslTest
extends ClusterTestHarness {
    Properties props = new Properties();

    public RestApiSslTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testRegisterWithClientSecurity() throws Exception {
        this.setupHostNameVerifier();
        String subject = "testSubject";
        Schema schema = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").rawSchema();
        int expectedIdSchema1 = 1;
        HashMap<String, Object> clientsslConfigs = new HashMap<String, Object>();
        clientsslConfigs.put("schema.registry.ssl.protocol", "TLS");
        clientsslConfigs.put("schema.registry.ssl.keystore.location", this.props.get("ssl.keystore.location"));
        clientsslConfigs.put("schema.registry.ssl.keystore.password", this.props.get("ssl.keystore.password"));
        clientsslConfigs.put("schema.registry.ssl.key.password", this.props.get("ssl.keystore.password"));
        clientsslConfigs.put("schema.registry.ssl.keystore.type", this.props.get("ssl.keystore.type"));
        clientsslConfigs.put("schema.registry.ssl.truststore.location", this.props.get("ssl.truststore.location"));
        clientsslConfigs.put("schema.registry.ssl.truststore.password", this.props.get("ssl.truststore.password"));
        clientsslConfigs.put("schema.registry.ssl.truststore.type", this.props.get("ssl.truststore.type"));
        CachedSchemaRegistryClient schemaRegistryClient = new CachedSchemaRegistryClient(this.restApp.restClient, 10, clientsslConfigs);
        Assertions.assertEquals((int)expectedIdSchema1, (int)schemaRegistryClient.register(subject, (ParsedSchema)new AvroSchema(schema)), (String)"Registering should succeed");
    }

    @Test
    public void testRegisterWithClientSecurityWithMinimalProperties() throws Exception {
        this.setupHostNameVerifier();
        String subject = "testSubject";
        Schema schema = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f2\"}]}").rawSchema();
        int expectedIdSchema1 = 1;
        HashMap<String, Object> clientsslConfigs = new HashMap<String, Object>();
        clientsslConfigs.put("schema.registry.ssl.keystore.location", this.props.get("ssl.keystore.location"));
        clientsslConfigs.put("schema.registry.ssl.keystore.password", this.props.get("ssl.keystore.password"));
        clientsslConfigs.put("schema.registry.ssl.keystore.type", this.props.get("ssl.keystore.type"));
        clientsslConfigs.put("schema.registry.ssl.truststore.location", this.props.get("ssl.truststore.location"));
        clientsslConfigs.put("schema.registry.ssl.truststore.password", this.props.get("ssl.truststore.password"));
        clientsslConfigs.put("schema.registry.ssl.truststore.type", this.props.get("ssl.truststore.type"));
        CachedSchemaRegistryClient schemaRegistryClient = new CachedSchemaRegistryClient(this.restApp.restClient, 10, clientsslConfigs);
        Assertions.assertEquals((int)expectedIdSchema1, (int)schemaRegistryClient.register(subject, (ParsedSchema)new AvroSchema(schema)), (String)"Registering should succeed");
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Configuration.setConfiguration(null);
        this.props.put("schema.registry.inter.instance.protocol", "https");
        this.props.put("ssl.endpoint.identification.algorithm", "");
        try {
            File trustStoreFile = File.createTempFile("truststore", ".jks");
            trustStoreFile.deleteOnExit();
            ArrayList<X509Certificate> clientCerts = new ArrayList<X509Certificate>();
            ArrayList<KeyPair> keyPairs = new ArrayList<KeyPair>();
            this.props.putAll((Map<?, ?>)SecureTestUtils.clientSslConfigsWithKeyStore(1, trustStoreFile, new Password("TrustPassword"), clientCerts, keyPairs));
            this.props.put("ssl.client.authentication", "REQUIRED");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creation SSL properties ", e);
        }
        this.props.put("listeners", this.getSchemaRegistryProtocol() + "://localhost:" + this.schemaRegistryPort);
        return this.props;
    }

    @Override
    protected String getSchemaRegistryProtocol() {
        return "https";
    }

    private void setupHostNameVerifier() {
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

