/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.Configuration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SchemaRegistryExtensionTest
extends ClusterTestHarness {
    private static final String SUBJECT = "testSubject";
    BasicAuthCredentialProvider basicAuthCredentialProvider = new BasicAuthCredentialProvider(){

        public String alias() {
            return "TEST";
        }

        public void configure(Map<String, ?> configs) {
        }

        public String getUserInfo(URL url) {
            return "testuser:testpass";
        }
    };

    public SchemaRegistryExtensionTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testAllowResource() throws Exception {
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        this.restApp.restClient.setBasicAuthCredentialProvider(this.basicAuthCredentialProvider);
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, SUBJECT), (String)"Registering should succeed");
    }

    @Test
    public void tesRejectResource() throws Exception {
        try {
            this.restApp.restClient.setBasicAuthCredentialProvider(this.basicAuthCredentialProvider);
            this.restApp.restClient.getLatestVersion(SUBJECT);
            Assertions.fail((String)"Getting all versions from non-existing subject1 should fail with 401");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)401, (int)rce.getStatus(), (String)"Should get a 401 status for GET operations");
        }
    }

    @Test
    public void testExtensionAddedHandler() throws Exception {
        KafkaSchemaRegistry kafkaSchemaRegistry = (KafkaSchemaRegistry)this.restApp.schemaRegistry();
        Assert.assertEquals((long)kafkaSchemaRegistry.getCustomHandler().size(), (long)2L);
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        this.restApp.restClient.setBasicAuthCredentialProvider(this.basicAuthCredentialProvider);
        this.restApp.restClient.registerSchema(schemaString1, SUBJECT);
        Assert.assertEquals((long)kafkaSchemaRegistry.getCustomHandler().size(), (long)3L);
    }

    @Test
    public void testSecurityHandlerBeforeCustomHandler() throws Exception {
        AtomicReference testHandlerRef = new AtomicReference();
        KafkaSchemaRegistry kafkaSchemaRegistry = (KafkaSchemaRegistry)this.restApp.schemaRegistry();
        kafkaSchemaRegistry.getCustomHandler().forEach(handler -> {
            if (handler instanceof TestSecurityOrderHandler) {
                testHandlerRef.set((TestSecurityOrderHandler)((Object)handler));
            }
        });
        TestSecurityOrderHandler testHandler = (TestSecurityOrderHandler)((Object)testHandlerRef.get());
        Assert.assertNotNull((String)"TestSecurityOrderHandler should be found in custom handlers", (Object)((Object)testHandler));
        testHandler.reset();
        String schemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(schemaString, SUBJECT);
            Assertions.fail((String)"Request without authentication should be blocked by security handler");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)401, (int)rce.getStatus(), (String)"Should get 401 from security handler");
            Assert.assertFalse((String)"Custom handler should not be called when security blocks request", (boolean)testHandler.wasHandlerCalled());
        }
        testHandler.reset();
        this.restApp.restClient.setBasicAuthCredentialProvider(this.basicAuthCredentialProvider);
        this.restApp.restClient.registerSchema(schemaString, SUBJECT);
        Assert.assertTrue((String)"Custom handler should be called for authenticated requests that pass security", (boolean)testHandler.wasHandlerCalled());
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.put("resource.extension.class", TestSchemaRegistryExtension.class.getName() + "," + TestSchemaRegistryHandlerExtension.class.getName());
        props.put("authentication.method", "BASIC");
        props.put("authentication.realm", "SchemaRegistry-Test");
        props.put("authentication.roles", "admin");
        try {
            File jaasConfigFile = File.createTempFile("test-jaas-", ".conf");
            jaasConfigFile.deleteOnExit();
            File userPropsFile = File.createTempFile("test-users-", ".properties");
            userPropsFile.deleteOnExit();
            Files.write(userPropsFile.toPath(), "testuser: testpass,admin\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ArrayList<Object> jaasLines = new ArrayList<Object>();
            jaasLines.add("SchemaRegistry-Test {");
            jaasLines.add("  org.eclipse.jetty.security.jaas.spi.PropertyFileLoginModule required");
            jaasLines.add("  file=\"" + userPropsFile.getAbsolutePath() + "\";");
            jaasLines.add("};");
            Files.write(jaasConfigFile.toPath(), jaasLines, StandardCharsets.UTF_8, new OpenOption[0]);
            System.setProperty("java.security.auth.login.config", jaasConfigFile.getAbsolutePath());
            Configuration.setConfiguration(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to setup authentication", e);
        }
        return props;
    }

    public static class TestSecurityOrderHandler
    extends Handler.Wrapper {
        private volatile boolean handlerCalled = false;

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            this.handlerCalled = true;
            return super.handle(request, response, callback);
        }

        public boolean wasHandlerCalled() {
            return this.handlerCalled;
        }

        public void reset() {
            this.handlerCalled = false;
        }
    }

    public static class TestSchemaRegistryExtension
    implements SchemaRegistryResourceExtension {
        public void register(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) {
            config.register((Object)new ContainerRequestFilter(){

                public void filter(ContainerRequestContext requestContext) throws IOException {
                    if (!requestContext.getMethod().equalsIgnoreCase("POST")) {
                        requestContext.abortWith(jakarta.ws.rs.core.Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource.").build());
                    }
                }
            });
        }

        public void close() {
        }
    }

    public static class TestSchemaRegistryHandlerExtension
    implements SchemaRegistryResourceExtension {
        public void register(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) {
            final KafkaSchemaRegistry kafkaSchemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
            TestSecurityOrderHandler testHandler = new TestSecurityOrderHandler();
            kafkaSchemaRegistry.addCustomHandler((Handler.Singleton)testHandler);
            kafkaSchemaRegistry.addCustomHandler((Handler.Singleton)new Handler.Wrapper(){

                public boolean handle(Request request, Response response, Callback callback) throws Exception {
                    kafkaSchemaRegistry.addCustomHandler((Handler.Singleton)new Handler.Wrapper());
                    super.handle(request, response, callback);
                    return true;
                }
            });
        }

        public void close() {
        }
    }
}

