/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.protobuf;

import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.utils.ResourceLoader;
import io.confluent.kafka.serializers.protobuf.test.Root;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiTest
extends ClusterTestHarness {
    private static final Random random = new Random();

    public RestApiTest() {
        super(1, true);
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", ProtobufSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = RestApiTest.getRandomProtobufSchemas(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = RestApiTest.getRandomProtobufSchemas(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should return empty");
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, "PROTOBUF", Collections.emptyList(), subject1).getId();
            Assertions.assertEquals((int)expectedId, (int)foundId, (String)"Re-registering an existing schema should return the existing version");
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assertions.assertEquals(allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1), (String)"Getting all versions from subject1 should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2), (String)"Getting all versions from subject2 should match all registered versions");
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
    }

    @Test
    public void testSchemaReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getProtobufSchemaWithDependencies();
        String subject = "confluent/meta.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemas.get("confluent/meta.proto"), 1, subject);
        subject = "reference";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemas.get("ref.proto"), 2, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("root.proto"));
        request.setSchemaType("PROTOBUF");
        SchemaReference ref = new SchemaReference("ref.proto", "reference", Integer.valueOf(1));
        SchemaReference meta = new SchemaReference("confluent/meta.proto", "confluent/meta.proto", Integer.valueOf(1));
        List<SchemaReference> refs = Arrays.asList(ref, meta);
        request.setReferences(refs);
        int registeredId = this.restApp.restClient.registerSchema(request, "referrer", false).getId();
        Assertions.assertEquals((int)3, (int)registeredId, (String)"Registering a new schema should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(3);
        Assertions.assertEquals((Object)schemas.get("root.proto"), (Object)schemaString.getSchemaString(), (String)"Registered schema should be found");
        schemaString = this.restApp.restClient.getId(RestService.DEFAULT_REQUEST_PROPERTIES, 3, null, "serialized", null, false);
        Assertions.assertEquals((Object)schemas.get("root.proto"), (Object)new ProtobufSchema(schemaString.getSchemaString()).canonicalString(), (String)"Registered schema should be found");
        Assertions.assertEquals(refs, (Object)schemaString.getReferences(), (String)"Schema dependencies should be found");
        Root.ReferrerMessage referrer = Root.ReferrerMessage.newBuilder().build();
        ProtobufSchema schema = ProtobufSchemaUtils.getSchema((Message)referrer);
        schema = schema.copy(refs);
        Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "PROTOBUF", schema.references(), "referrer", false);
        Assertions.assertEquals((int)3, (int)registeredSchema.getId(), (String)"Registered schema should be found");
        request = new RegisterSchemaRequest();
        request.setSchema(schema.canonicalString());
        request.setSchemaType(schema.schemaType());
        request.setReferences(schema.references());
        Schema registeredSchema2 = this.restApp.restClient.lookUpSubjectVersion(RestService.DEFAULT_REQUEST_PROPERTIES, request, "referrer", false, "serialized", false);
        Assertions.assertEquals((Object)registeredSchema.getSchema(), (Object)new ProtobufSchema(registeredSchema2.getSchema()).canonicalString(), (String)"Registered schema should be found");
        Schema latestSchema = this.restApp.restClient.getLatestVersion("referrer");
        Assertions.assertEquals((int)3, (int)latestSchema.getId(), (String)"Registered schema should be found");
        Schema latestSchema2 = this.restApp.restClient.getLatestVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "referrer", "serialized", null);
        Assertions.assertEquals((Object)latestSchema.getSchema(), (Object)new ProtobufSchema(latestSchema2.getSchema()).canonicalString(), (String)"Registered schema should be found");
    }

    @Test
    public void testSchemaReferencesPkg() throws Exception {
        String msg1 = "syntax = \"proto3\";\npackage pkg1;\n\noption go_package = \"pkg1pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg1Proto\";\noption java_package = \"com.pkg1\";\n\nmessage Message1 {\n  string s = 1;\n}\n";
        String subject = "pkg1/msg1.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, msg1, 1, subject);
        subject = "pkg2/msg2.proto";
        String msg2 = "syntax = \"proto3\";\npackage pkg2;\n\noption go_package = \"pkg2pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg2Proto\";\noption java_package = \"com.pkg2\";\n\nimport \"pkg1/msg1.proto\";\n\nmessage Message2 {\n  map<string, pkg1.Message1> map = 1;\n  pkg1.Message1 f2 = 2;\n}\n";
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(msg2);
        request.setSchemaType("PROTOBUF");
        SchemaReference meta = new SchemaReference("pkg1/msg1.proto", "pkg1/msg1.proto", Integer.valueOf(1));
        List<SchemaReference> refs = Arrays.asList(meta);
        request.setReferences(refs);
        int registeredId = this.restApp.restClient.registerSchema(request, subject, false).getId();
        Assertions.assertEquals((int)2, (int)registeredId, (String)"Registering a new schema should succeed");
    }

    @Test
    public void testSchemaMissingReferences() throws Exception {
        Assertions.assertThrows(RestClientException.class, () -> {
            Map<String, String> schemas = RestApiTest.getProtobufSchemaWithDependencies();
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get("root.proto"));
            request.setSchemaType("PROTOBUF");
            request.setReferences(Collections.emptyList());
            this.restApp.restClient.registerSchema(request, "referrer", false);
        });
    }

    @Test
    public void testIncompatibleSchema() throws Exception {
        String subject = "testSubject";
        String schema1String = "syntax = \"proto3\";\npackage pkg3;\n\nmessage Schema1 {\n  string f1 = 1;\n  string f2 = 2;\n}\n";
        RegisterSchemaRequest registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(schema1String);
        registerRequest.setSchemaType("PROTOBUF");
        String schema2String = "syntax = \"proto3\";\npackage pkg3;\n\nmessage Schema1 {\n  string f1 = 1;\n  int32 f2 = 2;\n}\n";
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, subject);
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(registerRequest, subject, true).getId();
        try {
            registerRequest.setSchema(schema2String);
            registerRequest.setSchemaType("PROTOBUF");
            this.restApp.restClient.registerSchema(registerRequest, subject, true);
            Assertions.fail((String)("Registering incompatible schema should fail with " + Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE));
        }
        catch (RestClientException e) {
            Assertions.assertTrue((e.getMessage().length() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)e.getMessage().contains("oldSchemaVersion:"));
            Assertions.assertTrue((boolean)e.getMessage().contains("oldSchema:"));
            Assertions.assertTrue((boolean)e.getMessage().contains("compatibility:"));
        }
        List response = this.restApp.restClient.testCompatibility(registerRequest, subject, String.valueOf(idOfRegisteredSchema1Subject1), false, true);
        Assertions.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)response.get(2)).contains("oldSchemaVersion:"));
        Assertions.assertTrue((boolean)((String)response.get(3)).contains("oldSchema:"));
        Assertions.assertTrue((boolean)((String)response.get(4)).contains("compatibility:"));
    }

    @Test
    public void testSchemaNormalization() throws Exception {
        String subject1 = "testSubject1";
        String msg1 = "syntax = \"proto3\";\npackage pkg1;\n\noption go_package = \"pkg1pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg1Proto\";\noption java_package = \"com.pkg1\";\n\nmessage Message1 {\n  string s = 1;\n}\n";
        String subject = "pkg1/msg1.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, msg1, 1, subject);
        String msg2 = "syntax = \"proto3\";\npackage pkg2;\n\noption go_package = \"pkg2pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg2Proto\";\noption java_package = \"com.pkg2\";\n\nmessage Message2 {\n  string s = 1;\n}\n";
        subject = "pkg2/msg2.proto";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, msg2, 2, subject);
        String msg3 = "syntax = \"proto3\";\npackage pkg3;\n\noption go_package = \"pkg3pb\";\noption java_multiple_files = true;\noption java_outer_classname = \"Msg3Proto\";\noption java_package = \"com.pkg3\";\n\nimport \"pkg1/msg1.proto\";\nimport \"pkg2/msg2.proto\";\n\nmessage Message3 {\n  map<string, pkg1.Message1> map = 1;\n  pkg1.Message1 f1 = 2;\n  pkg2.Message2 f2 = 3;\n}\n";
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(msg3);
        request.setSchemaType("PROTOBUF");
        SchemaReference ref1 = new SchemaReference("pkg1/msg1.proto", "pkg1/msg1.proto", Integer.valueOf(1));
        SchemaReference ref2 = new SchemaReference("pkg2/msg2.proto", "pkg2/msg2.proto", Integer.valueOf(1));
        List<SchemaReference> refs = Arrays.asList(ref1, ref2);
        request.setReferences(refs);
        int registeredId = this.restApp.restClient.registerSchema(request, subject1, true).getId();
        Assertions.assertEquals((int)3, (int)registeredId, (String)"Registering a new schema should succeed");
        msg3 = "syntax = \"proto3\";\npackage pkg3;\n\noption java_package = \"com.pkg3\";\noption java_outer_classname = \"Msg3Proto\";\noption java_multiple_files = true;\noption go_package = \"pkg3pb\";\n\nimport \"pkg2/msg2.proto\";\nimport \"pkg1/msg1.proto\";\n\nmessage Message3 {\n  pkg2.Message2 f2 = 3;\n  pkg1.Message1 f1 = 2;\n  map<string, pkg1.Message1> map = 1;\n}\n";
        RegisterSchemaRequest lookUpRequest = new RegisterSchemaRequest();
        lookUpRequest.setSchema(msg3);
        lookUpRequest.setSchemaType("PROTOBUF");
        lookUpRequest.setReferences(Arrays.asList(ref2, ref1));
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSchema1Subject1, (String)"1st schema under subject1 should have version 1");
        Assertions.assertEquals((int)3, (int)registeredId, (String)"1st schema registered globally should have id 3");
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should return empty");
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getBadSchema(), 1, subject1);
            Assertions.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getRandomProtobufSchemas(1).get(0), Arrays.asList(new SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assertions.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
    }

    @Test
    public void testCustomOption() throws Exception {
        String subject = "test-proto";
        String enumOptionSchemaString = "syntax = \"proto3\";\n\nimport \"google/protobuf/descriptor.proto\";\n\noption java_package = \"io.confluent.kafka.serializers.protobuf.test\";\noption java_outer_classname = \"TestEnumProtos\";\noption php_namespace = \"Bug\\\\V1\";\n\nmessage TestEnum {\n  option (some_ref) = \"https://test.com\";\n\n  Suit suit = 1;\n\n  oneof test_oneof {\n    option (some_ref) = \"https://test.com\";\n  \n    string name = 2;\n    int32 age = 3;\n  }\n\n  enum Suit {\n    option (some_ref) = \"https://test.com\";\n    SPADES = 0;\n    HEARTS = 1;\n    DIAMONDS = 2;\n    CLUBS = 3;\n  }\n}\n";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, enumOptionSchemaString, 1, subject);
    }

    @Test
    public void testRegisterSchemaTagsBasic() throws Exception {
        String subject = "test";
        String schemaString = "syntax = \"proto3\";\npackage com.example;\n\nmessage Message1 {\n  string f1 = 1;\n  string f2 = 2;\n}\n";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemaString, 1, subject);
        RegisterSchemaRequest tagSchemaRequest = new RegisterSchemaRequest((ParsedSchema)new ProtobufSchema(schemaString));
        tagSchemaRequest.setSchemaTagsToAdd(Arrays.asList(new SchemaTags(new SchemaEntity("Message1.f1", SchemaEntity.EntityType.SR_FIELD), Arrays.asList("TAG1")), new SchemaTags(new SchemaEntity(".Message1.f1", SchemaEntity.EntityType.SR_FIELD), Arrays.asList("TAG2"))));
        String newSchemaString = "syntax = \"proto3\";\npackage com.example;\n\nmessage Message1 {\n  string f1 = 1 [(confluent.field_meta) = {\n    tags: [\n      \"TAG1\",\n      \"TAG2\"\n    ]\n  }];\n  string f2 = 2;\n}\n";
        RegisterSchemaResponse responses = this.restApp.restClient.registerSchema(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, false);
        Assertions.assertEquals((int)2, (int)responses.getId());
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)newSchemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        tagSchemaRequest = new RegisterSchemaRequest((ParsedSchema)new ProtobufSchema(newSchemaString));
        tagSchemaRequest.setVersion(Integer.valueOf(3));
        tagSchemaRequest.setSchemaTagsToRemove(Collections.singletonList(new SchemaTags(new SchemaEntity("Message1.f1", SchemaEntity.EntityType.SR_FIELD), Arrays.asList("TAG2"))));
        newSchemaString = "syntax = \"proto3\";\npackage com.example;\n\nmessage Message1 {\n  string f1 = 1 [(confluent.field_meta) = {\n    tags: [\n      \"TAG1\"\n    ]\n  }];\n  string f2 = 2;\n}\n";
        responses = this.restApp.restClient.registerSchema(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, false);
        Assertions.assertEquals((int)3, (int)responses.getId());
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)newSchemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)3, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"3", responses.getMetadata().getProperties().get("confluent:version"));
    }

    @Test
    public void testRegisterSchemaTagsBasicDeprecated() throws Exception {
        String subject = "test";
        String schemaString = "syntax = \"proto3\";\npackage com.example;\n\nmessage Message1 {\n  string f1 = 1;\n  string f2 = 2;\n}\n";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemaString, 1, subject);
        TagSchemaRequest tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setTagsToAdd(Arrays.asList(new SchemaTags(new SchemaEntity("Message1.f1", SchemaEntity.EntityType.SR_FIELD), Arrays.asList("TAG1")), new SchemaTags(new SchemaEntity(".Message1.f1", SchemaEntity.EntityType.SR_FIELD), Arrays.asList("TAG2"))));
        String expectedSchema = "syntax = \"proto3\";\npackage com.example;\n\nmessage Message1 {\n  string f1 = 1 [(confluent.field_meta) = {\n    tags: [\n      \"TAG1\",\n      \"TAG2\"\n    ]\n  }];\n  string f2 = 2;\n}\n";
        RegisterSchemaResponse responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assertions.assertEquals((int)2, (int)responses.getId());
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)expectedSchema, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        tagSchemaRequest = new TagSchemaRequest();
        tagSchemaRequest.setNewVersion(Integer.valueOf(3));
        tagSchemaRequest.setTagsToRemove(Collections.singletonList(new SchemaTags(new SchemaEntity("Message1.f1", SchemaEntity.EntityType.SR_FIELD), Arrays.asList("TAG2"))));
        expectedSchema = "syntax = \"proto3\";\npackage com.example;\n\nmessage Message1 {\n  string f1 = 1 [(confluent.field_meta) = {\n    tags: [\n      \"TAG1\"\n    ]\n  }];\n  string f2 = 2;\n}\n";
        responses = this.restApp.restClient.modifySchemaTags(RestService.DEFAULT_REQUEST_PROPERTIES, tagSchemaRequest, subject, "latest");
        Assertions.assertEquals((int)3, (int)responses.getId());
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)expectedSchema, (Object)result.getSchema());
        Assertions.assertEquals((Integer)3, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"3", responses.getMetadata().getProperties().get("confluent:version"));
    }

    @Test
    public void testConfluentVersion() throws Exception {
        String subject = "test";
        String schemaString = "syntax = \"proto3\";\npackage com.example;\n\nmessage Message1 {\n  string f1 = 1;\n  string f2 = 2;\n}\n";
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchemaType("PROTOBUF");
        request.setSchema(schemaString);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 1, subject);
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 1, subject);
        request.setVersion(Integer.valueOf(2));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "1"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "2"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(3));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)3, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"3", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(3));
        request.setMetadata(null);
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
            Assertions.fail((String)"Registering version that is not next version should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        request.setVersion(Integer.valueOf(4));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 4, subject);
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)4, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"4", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "-1"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 5, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)5, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"5", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "2"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "3"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "0"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 6, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)6, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"6", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.emptyMap(), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 6, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 7, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)7, (Integer)result.getVersion());
        Assertions.assertNull(result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 8, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)8, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"8", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)7, (Integer)result.getVersion());
        Assertions.assertNull(result.getMetadata().getProperties().get("confluent:version"));
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "7");
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)8, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"8", result.getMetadata().getProperties().get("confluent:version"));
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        RestApiTest.registerAndVerifySchema(restService, schemaString, Collections.emptyList(), expectedId, subject);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<SchemaReference> references, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, "PROTOBUF", references, subject).getId();
        Assertions.assertEquals((long)expectedId, (long)registeredId, (String)"Registering a new schema should succeed");
        Assertions.assertEquals((Object)schemaString.trim(), (Object)restService.getId(expectedId).getSchemaString().trim(), (String)"Registered schema should be found");
    }

    public static void registerAndVerifySchema(RestService restService, RegisterSchemaRequest request, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(request, subject, false).getId();
        Assertions.assertEquals((long)expectedId, (long)registeredId, (String)"Registering a new schema should succeed");
        Assertions.assertEquals((Object)request.getSchema().trim(), (Object)restService.getId(expectedId).getSchemaString().trim(), (String)"Registered schema should be found");
    }

    public static List<String> getRandomProtobufSchemas(int num) {
        ArrayList<String> schemas = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            String schema = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nmessage MyMessage {\n  string f" + random.nextInt(Integer.MAX_VALUE) + " = 1;\n  bool is_active = 2;\n}\n";
            schemas.add(schema);
        }
        return schemas;
    }

    public static Map<String, String> getProtobufSchemaWithDependencies() {
        HashMap<String, String> schemas = new HashMap<String, String>();
        String meta = ResourceLoader.DEFAULT.toString("confluent/meta.proto");
        schemas.put("confluent/meta.proto", meta);
        String reference = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nmessage ReferencedMessage {\n  string ref_id = 1;\n  bool is_active = 2;\n}\n";
        schemas.put("ref.proto", reference);
        String schemaString = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nimport \"ref.proto\";\nimport \"confluent/meta.proto\";\n\nmessage ReferrerMessage {\n  option (confluent.message_meta) = {\n    doc: \"ReferrerMessage\"\n  };\n\n  string root_id = 1;\n  .io.confluent.kafka.serializers.protobuf.test.ReferencedMessage ref = 2 [(confluent.field_meta) = {\n    doc: \"ReferencedMessage\"\n  }];\n}\n";
        schemas.put("root.proto", schemaString);
        return schemas;
    }

    public static String getBadSchema() {
        String schema = "syntax = \"proto3\";\npackage io.confluent.kafka.serializers.protobuf.test;\n\nbad-message MyMessage {\n  string f" + random.nextInt(Integer.MAX_VALUE) + " = 1;\n  bool is_active = 2;\n}\n";
        return schema;
    }
}

