/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/compatibility")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class CompatibilityResource {
    public static final String apiTag = "Compatibility (v1)";
    private static final Logger log = LoggerFactory.getLogger(CompatibilityResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public CompatibilityResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @POST
    @Path(value="/subjects/{subject}/versions/{version}")
    @DocumentedName(value="testVersionCompatibility")
    @Operation(summary="Test schema compatibility against a particular schema subject-version", description="Test input schema against a particular version of a subject's schema for compatibility. The compatibility level applied for the check is the configured compatibility level for the subject (http:get:: /config/(string: subject)). If this subject's compatibility level was never changed, then the global compatibility level applies (http:get:: /config).", responses={@ApiResponse(responseCode="200", description="Compatibility check result.", content={@Content(schema=@Schema(implementation=CompatibilityCheckResponse.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found. Error code 40402 indicates version not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="422", description="Unprocessable entity. Error code 42201 indicates an invalid schema or schema type. Error code 42202 indicates an invalid version.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Compatibility (v1)")})
    @PerformanceMetric(value="compatibility.subjects.versions.verify")
    public void testCompatibilityBySubjectName(@Suspended AsyncResponse asyncResponse, @Parameter(description="Subject of the schema version against which compatibility is to be tested", required=true) @PathParam(value="subject") String subject, @Parameter(description="Version of the subject's schema against which compatibility is to be tested. Valid values for versionId are between [1,2^31-1] or the string \"latest\".\"latest\" checks compatibility of the input schema with the last registered schema under the specified subject", required=true) @PathParam(value="version") String version, @Parameter(description="Whether to normalize the given schema") @QueryParam(value="normalize") boolean normalize, @Parameter(description="Schema", required=true) @NotNull RegisterSchemaRequest request, @Parameter(description="Whether to return detailed error messages") @QueryParam(value="verbose") boolean verbose) {
        List<String> errorMessages;
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema schemaForSpecifiedVersion;
        log.info("Testing schema subject {} compatibility between existing version {} and specified version {}, id {}, type {}", new Object[]{subject, version, request.getVersion(), request.getId(), request.getSchemaType()});
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        VersionId versionId = CompatibilityResource.parseVersionId(version);
        try {
            schemaForSpecifiedVersion = this.schemaRegistry.get(subject, versionId.getVersionId(), false);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.storeException("Error while retrieving schema for subject " + subject + " and version " + versionId.getVersionId(), e);
        }
        if (schemaForSpecifiedVersion == null && !versionId.isLatest()) {
            throw Errors.versionNotFoundException(versionId.getVersionId());
        }
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema schema = new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(subject, request);
        try {
            if (!normalize) {
                normalize = Boolean.TRUE.equals(this.schemaRegistry.getConfigInScope(subject).isNormalize());
            }
            errorMessages = this.schemaRegistry.isCompatible(subject, schema, schemaForSpecifiedVersion != null ? Collections.singletonList(new SchemaKey(subject, schemaForSpecifiedVersion.getVersion())) : Collections.emptyList(), normalize);
        }
        catch (InvalidSchemaException e) {
            if (verbose) {
                errorMessages = Collections.singletonList(e.getMessage());
            }
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while getting compatibility level for subject " + subject, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while getting compatibility level for subject " + subject, e);
        }
        CompatibilityCheckResponse compatibilityCheckResponse = CompatibilityResource.createCompatibilityCheckResponse(errorMessages, verbose);
        asyncResponse.resume((Object)compatibilityCheckResponse);
    }

    @POST
    @Path(value="/subjects/{subject}/versions")
    @DocumentedName(value="testSubjectCompatibility")
    @Operation(summary="Test schema compatibility against all schemas under a subject", description="Test input schema against a subject's schemas for compatibility, based on the configured compatibility level of the subject. In other words, it will perform the same compatibility check as register for that subject. The compatibility level applied for the check is the configured compatibility level for the subject (http:get:: /config/(string: subject)). If this subject's compatibility level was never changed, then the global compatibility level applies (http:get:: /config).", responses={@ApiResponse(responseCode="200", description="Compatibility check result.", content={@Content(schema=@Schema(implementation=CompatibilityCheckResponse.class))}), @ApiResponse(responseCode="422", description="Unprocessable Entity. Error code 42201 indicates an invalid schema or schema type. Error code 42202 indicates an invalid version.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Compatibility (v1)")})
    @PerformanceMetric(value="compatibility.subjects.versions.verify")
    public void testCompatibilityForSubject(@Suspended AsyncResponse asyncResponse, @Parameter(description="Subject of the schema version against which compatibility is to be tested", required=true) @PathParam(value="subject") String subject, @Parameter(description="Whether to normalize the given schema") @QueryParam(value="normalize") boolean normalize, @Parameter(description="Schema", required=true) @NotNull RegisterSchemaRequest request, @Parameter(description="Whether to return detailed error messages") @QueryParam(value="verbose") boolean verbose) {
        List<String> errorMessages;
        log.info("Testing schema subject {} compatibility with specified version {}, id {}, type {}", new Object[]{subject, request.getVersion(), request.getId(), request.getSchemaType()});
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        ArrayList<SchemaKey> previousSchemas = new ArrayList<SchemaKey>();
        try {
            this.schemaRegistry.getAllVersions(subject, LookupFilter.DEFAULT).forEachRemaining(previousSchemas::add);
        }
        catch (SchemaRegistryException e) {
            throw Errors.storeException("Error while retrieving schema for subject " + subject, e);
        }
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema schema = new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(subject, request);
        try {
            if (!normalize) {
                normalize = Boolean.TRUE.equals(this.schemaRegistry.getConfigInScope(subject).isNormalize());
            }
            errorMessages = this.schemaRegistry.isCompatible(subject, schema, previousSchemas, normalize);
        }
        catch (InvalidSchemaException e) {
            if (verbose) {
                errorMessages = Collections.singletonList(e.getMessage());
            }
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while getting compatibility level for subject " + subject, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while getting compatibility level for subject " + subject, e);
        }
        CompatibilityCheckResponse compatibilityCheckResponse = CompatibilityResource.createCompatibilityCheckResponse(errorMessages, verbose);
        asyncResponse.resume((Object)compatibilityCheckResponse);
    }

    private static CompatibilityCheckResponse createCompatibilityCheckResponse(List<String> errorMessages, boolean verbose) {
        CompatibilityCheckResponse compatibilityCheckResponse = new CompatibilityCheckResponse();
        compatibilityCheckResponse.setIsCompatible(errorMessages.isEmpty());
        if (verbose) {
            compatibilityCheckResponse.setMessages(errorMessages);
        }
        return compatibilityCheckResponse;
    }

    private static VersionId parseVersionId(String version) {
        VersionId versionId;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        return versionId;
    }
}

