/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.Metadata;
import io.confluent.kafka.schemaregistry.storage.RuleSet;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigValue
extends SubjectValue {
    private String alias;
    private Boolean normalize;
    private Boolean validateFields;
    private Boolean validateRules;
    private CompatibilityLevel compatibilityLevel;
    private String compatibilityGroup;
    private Metadata defaultMetadata;
    private Metadata overrideMetadata;
    private RuleSet defaultRuleSet;
    private RuleSet overrideRuleSet;

    public ConfigValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="alias") String alias, @JsonProperty(value="normalize") Boolean normalize, @JsonProperty(value="validateFields") Boolean validateFields, @JsonProperty(value="validateRules") Boolean validateRules, @JsonProperty(value="compatibilityLevel") CompatibilityLevel compatibilityLevel, @JsonProperty(value="compatibilityGroup") String compatibilityGroup, @JsonProperty(value="defaultMetadata") Metadata defaultMetadata, @JsonProperty(value="overrideMetadata") Metadata overrideMetadata, @JsonProperty(value="defaultRuleSet") RuleSet defaultRuleSet, @JsonProperty(value="overrideRuleSet") RuleSet overrideRuleSet) {
        super(subject);
        this.alias = alias;
        this.normalize = normalize;
        this.validateFields = validateFields;
        this.validateRules = validateRules;
        this.compatibilityLevel = compatibilityLevel;
        this.compatibilityGroup = compatibilityGroup;
        this.defaultMetadata = defaultMetadata;
        this.overrideMetadata = overrideMetadata;
        this.defaultRuleSet = defaultRuleSet;
        this.overrideRuleSet = overrideRuleSet;
    }

    public ConfigValue(String subject, Config configEntity) {
        super(subject);
        this.alias = configEntity.getAlias();
        this.normalize = configEntity.isNormalize();
        this.validateRules = configEntity.isValidateRules();
        this.compatibilityLevel = CompatibilityLevel.forName((String)configEntity.getCompatibilityLevel());
        this.compatibilityGroup = configEntity.getCompatibilityGroup();
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata defaultMetadata = configEntity.getDefaultMetadata();
        this.defaultMetadata = defaultMetadata != null ? new Metadata(defaultMetadata) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata overrideMetadata = configEntity.getOverrideMetadata();
        this.overrideMetadata = overrideMetadata != null ? new Metadata(overrideMetadata) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet defaultRuleSet = configEntity.getDefaultRuleSet();
        this.defaultRuleSet = defaultRuleSet != null ? new RuleSet(defaultRuleSet) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet overrideRuleSet = configEntity.getOverrideRuleSet();
        this.overrideRuleSet = overrideRuleSet != null ? new RuleSet(overrideRuleSet) : null;
    }

    public ConfigValue(String subject, Config configEntity, RuleSetHandler ruleSetHandler) {
        super(subject);
        this.alias = configEntity.getAlias();
        this.normalize = configEntity.isNormalize();
        this.validateFields = configEntity.isValidateFields();
        this.validateRules = configEntity.isValidateRules();
        this.compatibilityLevel = CompatibilityLevel.forName((String)configEntity.getCompatibilityLevel());
        this.compatibilityGroup = configEntity.getCompatibilityGroup();
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata defaultMetadata = configEntity.getDefaultMetadata();
        this.defaultMetadata = defaultMetadata != null ? new Metadata(defaultMetadata) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata overrideMetadata = configEntity.getOverrideMetadata();
        this.overrideMetadata = overrideMetadata != null ? new Metadata(overrideMetadata) : null;
        this.defaultRuleSet = ruleSetHandler.transform(configEntity.getDefaultRuleSet());
        this.overrideRuleSet = ruleSetHandler.transform(configEntity.getOverrideRuleSet());
    }

    public ConfigValue(String subject, CompatibilityLevel compatibilityLevel) {
        super(subject);
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonProperty(value="alias")
    public String getAlias() {
        return this.alias;
    }

    @JsonProperty(value="alias")
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @JsonProperty(value="normalize")
    public Boolean isNormalize() {
        return this.normalize;
    }

    @JsonProperty(value="normalize")
    public void setNormalize(Boolean normalize) {
        this.normalize = normalize;
    }

    @JsonProperty(value="validateFields")
    public Boolean isValidateFields() {
        return this.validateFields;
    }

    @JsonProperty(value="validateFields")
    public void setValidateFields(Boolean validateFields) {
        this.validateFields = validateFields;
    }

    @JsonProperty(value="validateRules")
    public Boolean isValidateRules() {
        return this.validateRules;
    }

    @JsonProperty(value="validateRules")
    public void setValidateRules(Boolean validateRules) {
        this.validateRules = validateRules;
    }

    @JsonProperty(value="compatibilityLevel")
    public CompatibilityLevel getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonProperty(value="compatibilityLevel")
    public void setCompatibilityLevel(CompatibilityLevel compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonProperty(value="compatibilityGroup")
    public String getCompatibilityGroup() {
        return this.compatibilityGroup;
    }

    @JsonProperty(value="compatibilityGroup")
    public void setCompatibilityGroup(String compatibilityGroup) {
        this.compatibilityGroup = compatibilityGroup;
    }

    @JsonProperty(value="defaultMetadata")
    public Metadata getDefaultMetadata() {
        return this.defaultMetadata;
    }

    @JsonProperty(value="defaultMetadata")
    public void setDefaultMetadata(Metadata defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public Metadata getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Metadata overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    @JsonProperty(value="defaultRuleSet")
    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    @JsonProperty(value="defaultRuleSet")
    public void setDefaultRuleSet(RuleSet defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public RuleSet getOverrideRuleSet() {
        return this.overrideRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public void setOverrideRuleSet(RuleSet overrideRuleSet) {
        this.overrideRuleSet = overrideRuleSet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.normalize, that.normalize) && Objects.equals(this.validateFields, that.validateFields) && Objects.equals(this.validateRules, that.validateRules) && this.compatibilityLevel == that.compatibilityLevel && Objects.equals(this.compatibilityGroup, that.compatibilityGroup) && Objects.equals(this.defaultMetadata, that.defaultMetadata) && Objects.equals(this.overrideMetadata, that.overrideMetadata) && Objects.equals(this.defaultRuleSet, that.defaultRuleSet) && Objects.equals(this.overrideRuleSet, that.overrideRuleSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alias, this.normalize, this.validateFields, this.validateRules, this.compatibilityLevel, this.compatibilityGroup, this.defaultMetadata, this.overrideMetadata, this.defaultRuleSet, this.overrideRuleSet);
    }

    public String toString() {
        return "ConfigValue{alias='" + this.alias + "', normalize=" + this.normalize + ", validateFields=" + this.validateFields + ", validateRules=" + this.validateRules + ", compatibilityLevel=" + String.valueOf(this.compatibilityLevel) + ", compatibilityGroup='" + this.compatibilityGroup + "', defaultMetadata=" + String.valueOf(this.defaultMetadata) + ", overrideMetadata=" + String.valueOf(this.overrideMetadata) + ", defaultRuleSet=" + String.valueOf(this.defaultRuleSet) + ", overrideRuleSet=" + String.valueOf(this.overrideRuleSet) + "}";
    }

    @Override
    public ConfigKey toKey() {
        return new ConfigKey(this.getSubject());
    }

    public Config toConfigEntity() {
        return new Config(this.alias, this.normalize, this.validateFields, this.validateRules, this.compatibilityLevel != null ? this.compatibilityLevel.name : null, this.compatibilityGroup, this.defaultMetadata != null ? this.defaultMetadata.toMetadataEntity() : null, this.overrideMetadata != null ? this.overrideMetadata.toMetadataEntity() : null, this.defaultRuleSet != null ? this.defaultRuleSet.toRuleSetEntity() : null, this.overrideRuleSet != null ? this.overrideRuleSet.toRuleSetEntity() : null);
    }

    public static ConfigValue update(String subject, ConfigValue oldConfig, ConfigUpdateRequest newConfig, RuleSetHandler ruleSetHandler) {
        RuleSet defaultRuleSet;
        Metadata overrideMetadata;
        Metadata defaultMetadata;
        if (oldConfig == null) {
            return new ConfigValue(subject, new Config(newConfig), ruleSetHandler);
        }
        if (newConfig == null) {
            return oldConfig;
        }
        Optional optDefaultMd = newConfig.getOptionalDefaultMetadata();
        Optional optOverrideMd = newConfig.getOptionalOverrideMetadata();
        Optional optDefaultRs = newConfig.getOptionalDefaultRuleSet();
        Optional optOverrideRs = newConfig.getOptionalOverrideRuleSet();
        Metadata metadata = optDefaultMd != null ? (optDefaultMd.isPresent() ? new Metadata((io.confluent.kafka.schemaregistry.client.rest.entities.Metadata)optDefaultMd.get()) : null) : (defaultMetadata = oldConfig.getDefaultMetadata());
        Metadata metadata2 = optOverrideMd != null ? (optOverrideMd.isPresent() ? new Metadata((io.confluent.kafka.schemaregistry.client.rest.entities.Metadata)optOverrideMd.get()) : null) : (overrideMetadata = oldConfig.getOverrideMetadata());
        RuleSet ruleSet = optDefaultRs != null ? (optDefaultRs.isPresent() ? ruleSetHandler.transform((io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet)optDefaultRs.get()) : null) : (defaultRuleSet = oldConfig.getDefaultRuleSet());
        RuleSet overrideRuleSet = optOverrideRs != null ? (optOverrideRs.isPresent() ? ruleSetHandler.transform((io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet)optOverrideRs.get()) : null) : oldConfig.getOverrideRuleSet();
        return new ConfigValue(subject, newConfig.getOptionalAlias() != null ? newConfig.getAlias() : oldConfig.getAlias(), newConfig.isOptionalNormalize() != null ? newConfig.isNormalize() : oldConfig.isNormalize(), newConfig.isOptionalValidateFields() != null ? newConfig.isValidateFields() : oldConfig.isValidateFields(), newConfig.isOptionalValidateRules() != null ? newConfig.isValidateRules() : oldConfig.isValidateRules(), newConfig.getOptionalCompatibilityLevel() != null ? CompatibilityLevel.forName((String)newConfig.getCompatibilityLevel()) : oldConfig.getCompatibilityLevel(), newConfig.getOptionalCompatibilityGroup() != null ? newConfig.getCompatibilityGroup() : oldConfig.getCompatibilityGroup(), defaultMetadata, overrideMetadata, defaultRuleSet, overrideRuleSet);
    }
}

