/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.Metadata;
import io.confluent.kafka.schemaregistry.storage.RuleSet;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaReference;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaValue
extends SubjectValue
implements Comparable<SchemaValue> {
    public static final String ENCODED_PROPERTY = "__enc__";
    @Min(value=1L)
    private @Min(value=1L) Integer version;
    @Min(value=0L)
    private @Min(value=0L) Integer id;
    private String md5;
    @NotEmpty
    private String schema;
    private String schemaType = "AVRO";
    private List<SchemaReference> references = Collections.emptyList();
    private Metadata metadata = null;
    private RuleSet ruleSet = null;
    @NotEmpty
    private boolean deleted;

    @VisibleForTesting
    public SchemaValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        super(subject);
        this.version = version;
        this.id = id;
        this.schema = schema;
        this.deleted = deleted;
    }

    @VisibleForTesting
    public SchemaValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        super(subject);
        this.version = version;
        this.id = id;
        this.schemaType = schemaType != null ? schemaType : "AVRO";
        this.references = references != null ? references : Collections.emptyList();
        this.schema = schema;
        this.deleted = deleted;
    }

    @JsonCreator
    public SchemaValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="md5") String md5, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="ruleSet") RuleSet ruleSet, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        super(subject);
        this.version = version;
        this.id = id;
        this.md5 = md5;
        this.schemaType = schemaType != null ? schemaType : "AVRO";
        this.references = references != null ? references : Collections.emptyList();
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.schema = schema;
        this.deleted = deleted;
    }

    public SchemaValue(Schema schemaEntity) {
        super(schemaEntity.getSubject());
        this.version = schemaEntity.getVersion();
        this.id = schemaEntity.getId();
        this.schemaType = schemaEntity.getSchemaType();
        List refs = schemaEntity.getReferences();
        this.references = refs == null ? null : refs.stream().map(SchemaReference::new).collect(Collectors.toList());
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata metadata = schemaEntity.getMetadata();
        this.metadata = metadata != null ? new Metadata(metadata) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet = schemaEntity.getRuleSet();
        this.ruleSet = ruleSet != null ? new RuleSet(ruleSet) : null;
        this.schema = schemaEntity.getSchema();
        this.deleted = false;
    }

    public SchemaValue(Schema schemaEntity, RuleSetHandler ruleSetHandler) {
        super(schemaEntity.getSubject());
        this.version = schemaEntity.getVersion();
        this.id = schemaEntity.getId();
        this.schemaType = schemaEntity.getSchemaType();
        List refs = schemaEntity.getReferences();
        this.references = refs == null ? null : refs.stream().map(SchemaReference::new).collect(Collectors.toList());
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata metadata = schemaEntity.getMetadata();
        this.metadata = metadata != null ? new Metadata(metadata) : null;
        this.ruleSet = ruleSetHandler.transform(schemaEntity.getRuleSet());
        this.schema = schemaEntity.getSchema();
        this.deleted = false;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="md5")
    public String getMd5() {
        return this.md5;
    }

    @JsonProperty(value="md5")
    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @JsonIgnore
    public byte[] getMd5Bytes() {
        return this.md5 != null ? Base64.getDecoder().decode(this.md5) : null;
    }

    @JsonIgnore
    public void setMd5Bytes(byte[] bytes) {
        this.md5 = bytes != null ? Base64.getEncoder().encodeToString(bytes) : null;
    }

    @JsonProperty(value="schemaType")
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType != null ? schemaType : "AVRO";
    }

    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaValue that = (SchemaValue)o;
        return this.deleted == that.deleted && Objects.equals(this.version, that.version) && Objects.equals(this.id, that.id) && Objects.equals(this.md5, that.md5) && Objects.equals(this.schema, that.schema) && Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.references, that.references) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version, this.id, this.md5, this.schema, this.schemaType, this.references, this.metadata, this.ruleSet, this.deleted);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{subject=" + this.getSubject() + ",");
        sb.append("version=" + this.version + ",");
        sb.append("id=" + this.id + ",");
        sb.append("md5=" + this.md5 + ",");
        sb.append("schemaType=" + this.schemaType + ",");
        sb.append("references=" + String.valueOf(this.references) + ",");
        sb.append("metadata=" + String.valueOf(this.metadata) + ",");
        sb.append("ruleSet=" + String.valueOf(this.ruleSet) + ",");
        sb.append("schema=" + this.schema + ",");
        sb.append("deleted=" + this.deleted + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(SchemaValue that) {
        int result = this.getSubject().compareTo(that.getSubject());
        if (result != 0) {
            return result;
        }
        result = this.version - that.version;
        return result;
    }

    @Override
    public SchemaKey toKey() {
        return new SchemaKey(this.getSubject(), this.getVersion());
    }

    public Schema toSchemaEntity() {
        List<io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference> references = this.getReferences() == null ? null : this.getReferences().stream().map(SchemaReference::toRefEntity).collect(Collectors.toList());
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata metadata = this.getMetadata() == null ? null : this.getMetadata().toMetadataEntity();
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet = this.getRuleSet() == null ? null : this.getRuleSet().toRuleSetEntity();
        byte[] bytes = this.getMd5Bytes();
        MD5 md5 = bytes != null ? new MD5(bytes) : MD5.ofSchema(this.getSchema(), references, metadata, ruleSet);
        return new Schema(this.getSubject(), this.getVersion(), this.getId(), md5.toString(), this.getSchemaType(), references, metadata, ruleSet, this.getSchema(), null, this.getTimestamp(), Boolean.valueOf(this.isDeleted()));
    }

    public Schema toHashKey() {
        return new Schema(this.getSubject(), null, null, this.getSchemaType(), this.getReferences() == null ? null : this.getReferences().stream().map(SchemaReference::toRefEntity).collect(Collectors.toList()), this.getMetadata() == null ? null : this.getMetadata().toMetadataEntity(), this.getRuleSet() == null ? null : this.getRuleSet().toRuleSetEntity(), this.getSchema());
    }
}

