/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import io.confluent.kafka.serializers.context.strategy.ContextNameStrategy;
import io.confluent.kafka.serializers.schema.id.HeaderSchemaIdSerializer;
import io.confluent.kafka.serializers.wrapper.CompositeDeserializer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class CachedSchemaRegistryClientTest
extends ClusterTestHarness {
    private final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    private String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";

    public CachedSchemaRegistryClientTest() {
        super(1, true);
    }

    private IndexedRecord createAvroRecord() {
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(this.userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    private Properties createConsumerProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("group.id", "avroGroup");
        props.put("session.timeout.ms", "6000");
        props.put("heartbeat.interval.ms", "2000");
        props.put("auto.commit.interval.ms", "1000");
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", KafkaAvroDeserializer.class);
        props.put("schema.registry.url", this.restApp.restConnect);
        return props;
    }

    private Properties createCompositeConsumerProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("group.id", "avroGroup");
        props.put("session.timeout.ms", "6000");
        props.put("heartbeat.interval.ms", "2000");
        props.put("auto.commit.interval.ms", "1000");
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", CompositeDeserializer.class);
        props.put("composite.old.deserializer", StringDeserializer.class);
        props.put("composite.confluent.deserializer", KafkaAvroDeserializer.class);
        props.put("schema.registry.url", this.restApp.restConnect);
        return props;
    }

    private Consumer<String, Object> createConsumer(Properties props) {
        return new KafkaConsumer(props);
    }

    private ArrayList<Object> consume(Consumer<String, Object> consumer, String topic, int numMessages) {
        ArrayList<Object> recordList = new ArrayList<Object>();
        consumer.subscribe(Arrays.asList(topic));
        int i = 0;
        while (i < numMessages) {
            ConsumerRecords records = consumer.poll(Duration.ofMillis(1000L));
            for (ConsumerRecord record : records) {
                recordList.add(record.value());
                ++i;
            }
        }
        consumer.close();
        return recordList;
    }

    private Properties createNewProducerProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("schema.registry.url", this.restApp.restConnect);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", KafkaAvroSerializer.class);
        return props;
    }

    private KafkaProducer createNewProducer(Properties props) {
        return new KafkaProducer(props);
    }

    private void newProduce(KafkaProducer producer, String topic, Object[] objects) {
        for (Object object : objects) {
            ProducerRecord record = new ProducerRecord(topic, object);
            producer.send(record);
        }
    }

    private Properties createProducerProps() {
        Properties props = new Properties();
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", KafkaAvroSerializer.class);
        props.put("bootstrap.servers", this.brokerList);
        props.put("schema.registry.url", this.restApp.restConnect);
        return props;
    }

    private Properties createBinaryProducerProps() {
        Properties props = new Properties();
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        props.put("bootstrap.servers", this.brokerList);
        props.put("schema.registry.url", this.restApp.restConnect);
        return props;
    }

    private Producer<String, Object> createProducer(Properties props) {
        return new KafkaProducer(props);
    }

    private void produce(Producer<String, Object> producer, String topic, Object[] objects) {
        this.produce(producer, topic, null, objects);
    }

    private void produce(Producer<String, Object> producer, String topic, Iterable<Header>[] headers, Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            Iterable<Header> header = headers != null ? headers[i] : null;
            ProducerRecord message = new ProducerRecord(topic, null, null, objects[i], header);
            producer.send(message);
        }
    }

    @Test
    public void testAvroProducer() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Object[] objects = new Object[]{avroRecord};
        Properties producerProps = this.createProducerProps();
        Producer<String, Object> producer = this.createProducer(producerProps);
        this.produce(producer, topic, objects);
        Properties consumerProps = this.createConsumerProps();
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroProducerWithCompositeDeserializer() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Properties producerProps = this.createProducerProps();
        KafkaAvroSerializer serializer = new KafkaAvroSerializer();
        KafkaAvroSerializerConfig config = new KafkaAvroSerializerConfig((Map)producerProps);
        serializer.configure(config.originals(), false);
        byte[] bytes = serializer.serialize(topic, (Object)avroRecord);
        byte[] bytes2 = new StringSerializer().serialize(topic, "testString");
        Object[] objects = new Object[]{bytes, bytes2};
        Properties binaryProducerProps = this.createBinaryProducerProps();
        Producer<String, Object> producer = this.createProducer(binaryProducerProps);
        this.produce(producer, topic, objects);
        Properties consumerProps = this.createCompositeConsumerProps();
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])new Object[]{avroRecord, "testString"}, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroProducerWithHeadersAndCompositeDeserializer() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Properties producerProps = this.createProducerProps();
        producerProps.put("value.schema.id.serializer", HeaderSchemaIdSerializer.class.getName());
        KafkaAvroSerializer serializer = new KafkaAvroSerializer();
        KafkaAvroSerializerConfig config = new KafkaAvroSerializerConfig((Map)producerProps);
        serializer.configure(config.originals(), false);
        RecordHeaders headers1 = new RecordHeaders();
        byte[] bytes = serializer.serialize(topic, (Headers)headers1, (Object)avroRecord);
        byte[] bytes2 = new StringSerializer().serialize(topic, "testString");
        Object[] objects = new Object[]{bytes, bytes2};
        Iterable[] headers = new Iterable[]{headers1, null};
        Properties binaryProducerProps = this.createBinaryProducerProps();
        Producer<String, Object> producer = this.createProducer(binaryProducerProps);
        this.produce(producer, topic, headers, objects);
        Properties consumerProps = this.createCompositeConsumerProps();
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])new Object[]{avroRecord, "testString"}, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroNewProducer() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Object[] objects = new Object[]{avroRecord, true, 130, 345L, Float.valueOf(1.23f), 2.34, "abc", "def".getBytes()};
        Properties producerProps = this.createNewProducerProps();
        KafkaProducer producer = this.createNewProducer(producerProps);
        this.newProduce(producer, topic, objects);
        Properties consumerProps = this.createConsumerProps();
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroNewProducerUsingContextUrl() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Object[] objects = new Object[]{avroRecord, true, 130, 345L, Float.valueOf(1.23f), 2.34, "abc", "def".getBytes()};
        Properties producerProps = this.createNewProducerProps();
        producerProps.put("schema.registry.url", this.restApp.restConnect + "/contexts/.ctx1");
        KafkaProducer producer = this.createNewProducer(producerProps);
        this.newProduce(producer, topic, objects);
        Properties consumerProps = this.createConsumerProps();
        consumerProps.put("schema.registry.url", this.restApp.restConnect + "/contexts/.ctx1");
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroNewProducerWithContext() throws Exception {
        String topic = "testAvro";
        this.restApp.restClient.registerSchema(this.userSchema, ":.context02:" + topic + "-value");
        IndexedRecord avroRecord = this.createAvroRecord();
        Object[] objects = new Object[]{avroRecord};
        Properties producerProps = this.createNewProducerProps();
        producerProps.put("auto.register.schemas", (Object)false);
        producerProps.put("use.latest.version", (Object)true);
        KafkaProducer producer = this.createNewProducer(producerProps);
        this.newProduce(producer, topic, objects);
        Properties consumerProps = this.createConsumerProps();
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroNewProducerUsingContextStrategy() {
        String topic = "testAvro";
        IndexedRecord avroRecord = this.createAvroRecord();
        Object[] objects = new Object[]{avroRecord, true, 130, 345L, Float.valueOf(1.23f), 2.34, "abc", "def".getBytes()};
        Properties producerProps = this.createNewProducerProps();
        producerProps.put("context.name.strategy", CustomContextNameStrategy.class.getName());
        KafkaProducer producer = this.createNewProducer(producerProps);
        this.newProduce(producer, topic, objects);
        Properties consumerProps = this.createConsumerProps();
        consumerProps.put("context.name.strategy", CustomContextNameStrategy.class.getName());
        Consumer<String, Object> consumer = this.createConsumer(consumerProps);
        ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
        Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
    }

    @Test
    public void testAvroNewProducerUsingInvalidContextStrategy() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            String topic = "testAvro";
            IndexedRecord avroRecord = this.createAvroRecord();
            Object[] objects = new Object[]{avroRecord, true, 130, 345L, Float.valueOf(1.23f), 2.34, "abc", "def".getBytes()};
            Properties producerProps = this.createNewProducerProps();
            producerProps.put("context.name.strategy", InvalidContextNameStrategy.class.getName());
            KafkaProducer producer = this.createNewProducer(producerProps);
            this.newProduce(producer, topic, objects);
            Properties consumerProps = this.createConsumerProps();
            consumerProps.put("context.name.strategy", InvalidContextNameStrategy.class.getName());
            Consumer<String, Object> consumer = this.createConsumer(consumerProps);
            ArrayList<Object> recordList = this.consume(consumer, topic, objects.length);
            Assert.assertArrayEquals((Object[])objects, (Object[])recordList.toArray());
        });
    }

    public static class CustomContextNameStrategy
    implements ContextNameStrategy {
        public void configure(Map<String, ?> configs) {
        }

        public String contextName(String topic) {
            return ".ctx1";
        }
    }

    public static class InvalidContextNameStrategy
    implements ContextNameStrategy {
        public void configure(Map<String, ?> configs) {
        }

        public String contextName(String topic) {
            return "foo:bar";
        }
    }
}

