/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomSchemaProviderMetricTest
extends ClusterTestHarness {
    public CustomSchemaProviderMetricTest() {
        super(1, true);
    }

    @Override
    public Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", CustomSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testCustomSchemaProviderMetricCount() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName customSchemaProviderCount = new ObjectName("kafka.schema.registry:type=custom-schema-provider-count");
        Assertions.assertEquals((Object)1.0, (Object)mBeanServer.getAttribute(customSchemaProviderCount, "custom-schema-provider-count"));
    }

    public static class CustomSchemaProvider
    implements SchemaProvider {
        public String schemaType() {
            return "CUSTOM_PROVIDER";
        }

        public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references, boolean isNew, boolean normalize) {
            return Optional.empty();
        }

        public ParsedSchema parseSchemaOrElseThrow(Schema schema, boolean isNew, boolean normalize) {
            return null;
        }
    }
}

