/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.MutableRequest;
import io.confluent.kafka.schemaregistry.rest.RequestHeaderHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.apache.logging.log4j.ThreadContext;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RequestHeaderHandlerTest {
    RequestHeaderHandler requestHeaderHandler = new RequestHeaderHandler();
    @Mock
    Request request;
    @Mock
    Response response;
    @Mock
    Blocker.Callback callback;

    @Before
    public void setup() {
        Mockito.reset((Object[])new Object[]{this.request, this.response});
        ThreadContext.clearAll();
    }

    @Test
    public void testRequestHandlerWith1RequestId() throws Exception {
        RequestHeaderHandler requestHeaderHandlerSpy = (RequestHeaderHandler)Mockito.spy((Object)new RequestHeaderHandler());
        HttpFields.Mutable headers = HttpFields.build().add("X-Request-ID", "request-ID-4329");
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)headers);
        HttpFields.Mutable responseHeaders = HttpFields.build();
        Mockito.when((Object)this.response.getHeaders()).thenReturn((Object)responseHeaders);
        ((RequestHeaderHandler)Mockito.doReturn((Object)"127.0.0.1").when((Object)requestHeaderHandlerSpy)).getRemoteAddr(this.request);
        requestHeaderHandlerSpy.handle(this.request, this.response, (Callback)this.callback);
        ((RequestHeaderHandler)Mockito.verify((Object)requestHeaderHandlerSpy, (VerificationMode)Mockito.times((int)1))).getRequestId(Collections.singletonList("request-ID-4329"));
        ((Request)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getHeaders();
        ((Response)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getHeaders();
        String responseRequestId = responseHeaders.get("X-Request-ID");
        Assert.assertEquals((Object)"request-ID-4329", (Object)responseRequestId);
        Assert.assertEquals((Object)"request-ID-4329", (Object)ThreadContext.get((String)"requestId"));
    }

    @Test
    public void testRequestHandlerWithoutRequestId() throws Exception {
        RequestHeaderHandler requestHeaderHandlerSpy = (RequestHeaderHandler)Mockito.spy((Object)new RequestHeaderHandler());
        HttpFields.Mutable headers = HttpFields.build();
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)headers);
        HttpFields.Mutable responseHeaders = HttpFields.build();
        Mockito.when((Object)this.response.getHeaders()).thenReturn((Object)responseHeaders);
        ((RequestHeaderHandler)Mockito.doReturn((Object)"127.0.0.1").when((Object)requestHeaderHandlerSpy)).getRemoteAddr(this.request);
        requestHeaderHandlerSpy.handle(this.request, this.response, (Callback)this.callback);
        ((RequestHeaderHandler)Mockito.verify((Object)requestHeaderHandlerSpy, (VerificationMode)Mockito.times((int)1))).getRequestId(Collections.emptyList());
        ((Request)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getHeaders();
        ((Response)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getHeaders();
        String generatedRequestId = responseHeaders.get("X-Request-ID");
        Assert.assertNotNull((String)"Request ID should be added to response headers", (Object)generatedRequestId);
        Assert.assertEquals((Object)generatedRequestId, (Object)ThreadContext.get((String)"requestId"));
        this.validateUuid(generatedRequestId);
    }

    @Test
    public void testRequestHandlerWithMultipleRequestId() throws Exception {
        RequestHeaderHandler requestHeaderHandlerSpy = (RequestHeaderHandler)Mockito.spy((Object)new RequestHeaderHandler());
        HttpFields.Mutable headers = HttpFields.build().add("X-Request-ID", "request-ID6").add("X-Request-ID", "request-ID4");
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)headers);
        HttpFields.Mutable responseHeaders = HttpFields.build();
        Mockito.when((Object)this.response.getHeaders()).thenReturn((Object)responseHeaders);
        ((RequestHeaderHandler)Mockito.doReturn((Object)"127.0.0.1").when((Object)requestHeaderHandlerSpy)).getRemoteAddr(this.request);
        requestHeaderHandlerSpy.handle(this.request, this.response, (Callback)this.callback);
        ((RequestHeaderHandler)Mockito.verify((Object)requestHeaderHandlerSpy, (VerificationMode)Mockito.times((int)1))).getRequestId(Arrays.asList("request-ID6", "request-ID4"));
        ((Request)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getHeaders();
        ((Response)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getHeaders();
        String generatedRequestId = responseHeaders.get("X-Request-ID");
        Assert.assertNotNull((String)"Request ID should be added to response headers", (Object)generatedRequestId);
        Assert.assertEquals((Object)generatedRequestId, (Object)ThreadContext.get((String)"requestId"));
        this.validateUuid(generatedRequestId);
    }

    @Test
    public void testAddXRequestIdToRequest() {
        MutableRequest mutableRequest = new MutableRequest(this.request);
        HttpFields.Mutable headers = HttpFields.build().add("X-Request-ID", "request-ID-4329");
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)headers);
        HttpFields.Mutable responseHeaders = HttpFields.build();
        Mockito.when((Object)this.response.getHeaders()).thenReturn((Object)responseHeaders);
        RequestHeaderHandler requestHeaderHandler = new RequestHeaderHandler();
        requestHeaderHandler.addXRequestIdToRequest(mutableRequest, this.response);
        ((Request)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getHeaders();
        ((Response)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getHeaders();
        String responseRequestId = responseHeaders.get("X-Request-ID");
        Assert.assertEquals((Object)"request-ID-4329", (Object)responseRequestId);
        String requestId = mutableRequest.getHeader("X-Request-ID");
        Assert.assertEquals((Object)"request-ID-4329", (Object)requestId);
        Assert.assertEquals((Object)"request-ID-4329", (Object)ThreadContext.get((String)"requestId"));
    }

    @Test
    public void testAddXForwardedForToRequest() {
        MutableRequest mutableRequest = new MutableRequest(this.request);
        RequestHeaderHandler requestHeaderHandlerSpy = (RequestHeaderHandler)Mockito.spy((Object)new RequestHeaderHandler());
        ((RequestHeaderHandler)Mockito.doReturn((Object)"127.0.0.1").when((Object)requestHeaderHandlerSpy)).getRemoteAddr(this.request);
        HttpFields.Mutable headers = HttpFields.build();
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)headers);
        requestHeaderHandlerSpy.addXForwardedForToRequest(mutableRequest, this.request);
        String callerIp = mutableRequest.getHeader("X-Forwarded-For");
        Assert.assertEquals((Object)"127.0.0.1", (Object)callerIp);
        headers = HttpFields.build().add("X-Forward", "true");
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)headers);
        requestHeaderHandlerSpy.addXForwardedForToRequest(mutableRequest, this.request);
        callerIp = mutableRequest.getHeader("X-Forwarded-For");
        Assert.assertEquals((Object)"127.0.0.1", (Object)callerIp);
    }

    @Test
    public void testAddXForwardedForToRequestOverridesHeader() {
        MutableRequest mutableRequest = new MutableRequest(this.request);
        RequestHeaderHandler requestHeaderHandlerSpy = (RequestHeaderHandler)Mockito.spy((Object)new RequestHeaderHandler());
        ((RequestHeaderHandler)Mockito.doReturn((Object)"127.0.0.1").when((Object)requestHeaderHandlerSpy)).getRemoteAddr(this.request);
        HttpFields.Mutable headers = HttpFields.build();
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)headers);
        mutableRequest.putHeader("X-Forwarded-For", "192.168.1.10");
        requestHeaderHandlerSpy.addXForwardedForToRequest(mutableRequest, this.request);
        String callerIp = mutableRequest.getHeader("X-Forwarded-For");
        Assert.assertEquals((Object)"127.0.0.1", (Object)callerIp);
    }

    @Test
    public void testGetRequestIdWith1RequestId() {
        String requestId = this.requestHeaderHandler.getRequestId(Collections.singletonList("request-ID-1234"));
        Assert.assertEquals((String)"Request ID must not change", (Object)"request-ID-1234", (Object)requestId);
    }

    @Test
    public void testGetRequestIdWithoutRequestId() {
        String requestId = this.requestHeaderHandler.getRequestId(Collections.emptyList());
        this.validateUuid(requestId);
    }

    @Test
    public void testGetRequestIdWithMultipleRequestId() {
        String requestId = this.requestHeaderHandler.getRequestId(Arrays.asList("request-ID1", "request-ID2"));
        this.validateUuid(requestId);
    }

    @Test
    public void testGetRequestIdWithBlankRequestId() {
        String requestId = this.requestHeaderHandler.getRequestId(Collections.singletonList("   "));
        this.validateUuid(requestId);
    }

    private void validateUuid(String requestId) {
        Assert.assertEquals((String)"Request ID is not a valid UUID", (Object)UUID.fromString(requestId).toString(), (Object)requestId);
    }
}

