/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiModeTest
extends ClusterTestHarness {
    private static String SCHEMA_STRING = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
    private static String SCHEMA2_STRING = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"f1\"}]}").canonicalString();
    private static String SCHEMA_WITH_DECIMAL = AvroUtils.parseSchema((String)"{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"scale\": 4,\n                    \"precision\": 17,\n                    \"logicalType\": \"decimal\"\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}").canonicalString();
    private static String SCHEMA_WITH_DECIMAL2 = AvroUtils.parseSchema((String)"{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"logicalType\": \"decimal\",\n                    \"precision\": 17,\n                    \"scale\": 4\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}").canonicalString();

    public RestApiModeTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testReadOnlyMode() throws Exception {
        String subject = "testSubject";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assertions.fail((String)"Registering during read-only mode should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
    }

    @Test
    public void testReadWriteMode() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, 1);
            Assertions.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
    }

    @Test
    public void testImportMode() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
    }

    @Test
    public void testImportModeWithoutId() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assertions.fail((String)"Registering a schema without ID should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
    }

    @Test
    public void testClearMode() throws Exception {
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        Assertions.assertEquals(null, (Object)this.restApp.restClient.setMode(null).getMode());
        Assertions.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode().getMode());
    }

    @Test
    public void testInvalidImportMode() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        try {
            this.restApp.restClient.setMode(mode).getMode();
            Assertions.fail((String)"Setting import mode should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject, true).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, null, true).getMode());
    }

    @Test
    public void testRegisterSchemaWithNoIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
    }

    @Test
    public void testRegisterSchemaWithDifferentIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 2;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
    }

    @Test
    public void testRegisterSchemaWithSameIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_STRING, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testRegisterSchemaWithSameIdButWithMetadataAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 1;
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(SCHEMA_STRING);
        request.setMetadata(new Metadata(null, (Map)ImmutableMap.of((Object)"foo", (Object)"bar"), null));
        request.setVersion(Integer.valueOf(1));
        request.setId(Integer.valueOf(expectedIdSchema1));
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request, subject, false).getId(), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_STRING, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        expectedIdSchema1 = 1;
        request = new RegisterSchemaRequest();
        request.setSchema(SCHEMA_STRING);
        request.setMetadata(new Metadata(null, (Map)ImmutableMap.of((Object)"foo", (Object)"bar"), null));
        request.setVersion(Integer.valueOf(1));
        request.setId(Integer.valueOf(expectedIdSchema1));
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request, subject, false).getId(), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_STRING, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testImportModeWithEquivalentSchemaDifferentId() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 100;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
        expectedIdSchema1 = 200;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL2, subject, 2, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL2, (Object)this.restApp.restClient.getVersion(subject, 2).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testImportModeWithSameSchemaDifferentId() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 100;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
        expectedIdSchema1 = 200;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 2, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 2).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testImportModeWithSameSchemaDifferentIdAndSubject() throws Exception {
        String subject = "testSubject";
        String subject2 = "testSubject2";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 100;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 1, expectedIdSchema1));
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema());
        int versionOfRegisteredSubject1 = this.restApp.restClient.lookUpSubjectVersion(SCHEMA_WITH_DECIMAL, subject).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSubject1);
        expectedIdSchema1 = 200;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject2, 1, expectedIdSchema1));
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject2, 1).getSchema());
        versionOfRegisteredSubject1 = this.restApp.restClient.lookUpSubjectVersion(SCHEMA_WITH_DECIMAL, subject).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSubject1);
        int versionOfRegisteredSubject2 = this.restApp.restClient.lookUpSubjectVersion(SCHEMA_WITH_DECIMAL, subject2).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSubject2);
    }

    @Test
    public void testRegisterIncompatibleSchemaDuringImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        expectedIdSchema1 = 2;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA2_STRING, subject, 2, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA2_STRING, (Object)this.restApp.restClient.getVersion(subject, 2).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testGlobalContextWithReadOnlyMode() throws Exception {
        String subject = "testSubject";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, ":.__GLOBAL:").getMode());
        Mode mode1 = this.restApp.restClient.getMode(null, true);
        Assertions.assertEquals((Object)"readonly", (Object)mode1.getMode().toLowerCase());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assertions.fail((String)"Registering during read-only mode should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
    }

    @Test
    public void testDeleteGlobalMode() throws Exception {
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode().getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(null);
        Assertions.assertEquals((Object)mode, (Object)deletedMode.getMode(), (String)"Deleted mode should return the old global mode");
        Assertions.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode().getMode(), (String)"Global mode should revert to default READWRITE");
    }

    @Test
    public void testDeleteSubjectModeAfterGlobalMode() throws Exception {
        String subject = "testSubject";
        String globalMode = "READONLY";
        String subjectMode = "READWRITE";
        Assertions.assertEquals((Object)globalMode, (Object)this.restApp.restClient.setMode(globalMode).getMode());
        Assertions.assertEquals((Object)subjectMode, (Object)this.restApp.restClient.setMode(subjectMode, subject).getMode());
        Assertions.assertEquals((Object)subjectMode, (Object)this.restApp.restClient.getMode(subject, false).getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(subject);
        Assertions.assertEquals((Object)subjectMode, (Object)deletedMode.getMode(), (String)"Deleted mode should return the old mode");
        Assertions.assertEquals((Object)globalMode, (Object)this.restApp.restClient.getMode(subject, true).getMode());
    }

    @Test
    public void testSetForwardMode() throws Exception {
        String subject = "testSubject";
        String mode = "FORWARD";
        try {
            this.restApp.restClient.setMode(mode, subject);
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42204, (int)e.getErrorCode());
            Assertions.assertEquals((Object)"Forward mode only supported on global level; error code: 42204", (Object)e.getMessage());
        }
        try {
            this.restApp.restClient.setMode(mode).getMode();
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42204, (int)e.getErrorCode());
            Assertions.assertEquals((Object)"Forward mode only supported on global level; error code: 42204", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetForwardModeForNonGlobalContext() throws Exception {
        String mode = "FORWARD";
        this.restApp.restClient.setMode(mode, ":.__GLOBAL");
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(":.__GLOBAL").getMode());
        try {
            this.restApp.restClient.setMode(mode, null);
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42204, (int)e.getErrorCode());
            Assertions.assertEquals((Object)"Forward mode only supported on global level; error code: 42204", (Object)e.getMessage());
        }
        try {
            this.restApp.restClient.setMode(mode, ":.");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42204, (int)e.getErrorCode());
            Assertions.assertEquals((Object)"Forward mode only supported on global level; error code: 42204", (Object)e.getMessage());
        }
        try {
            this.restApp.restClient.setMode(mode, ":.__GLOBAL:subject-name");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42204, (int)e.getErrorCode());
            Assertions.assertEquals((Object)"Forward mode only supported on global level; error code: 42204", (Object)e.getMessage());
        }
    }

    @Test
    public void testRecursiveDeleteContextMode() throws Exception {
        String context = ":.mycontext:";
        String subject1 = ":.mycontext:subject1";
        String subject2 = ":.mycontext:subject2";
        String subject3 = ":.mycontext:subject3";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, context).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject1).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject2).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject3).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(context, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject1, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject3, false).getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(Collections.emptyMap(), context, true);
        Assertions.assertEquals((Object)mode, (Object)deletedMode.getMode(), (String)"Deleted mode should return the old context mode");
        try {
            this.restApp.restClient.getMode(context, false);
            Assertions.fail((String)"Should throw exception for deleted context mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject1, false);
            Assertions.fail((String)"Should throw exception for deleted subject1 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject2, false);
            Assertions.fail((String)"Should throw exception for deleted subject2 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject3, false);
            Assertions.fail((String)"Should throw exception for deleted subject3 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
    }

    @Test
    public void testNonRecursiveDeleteContextModeDoesNotAffectSubjects() throws Exception {
        String context = ":.mycontext:";
        String subject1 = ":.mycontext:subject1";
        String subject2 = ":.mycontext:subject2";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, context).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject1).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject2).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(context, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject1, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(Collections.emptyMap(), context, false);
        Assertions.assertEquals((Object)mode, (Object)deletedMode.getMode(), (String)"Deleted mode should return the old context mode");
        try {
            this.restApp.restClient.getMode(context, false);
            Assertions.fail((String)"Should throw exception for deleted context mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject1, false).getMode(), (String)"Subject1 mode should still exist");
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode(), (String)"Subject2 mode should still exist");
    }

    @Test
    public void testRecursiveDeleteGlobalMode() throws Exception {
        String subject1 = "subject1";
        String subject2 = "subject2";
        String subject3 = "subject3";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject1).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject2).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject3).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(null, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject1, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject3, false).getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(Collections.emptyMap(), null, true);
        Assertions.assertEquals((Object)mode, (Object)deletedMode.getMode(), (String)"Deleted mode should return the old global mode");
        Assertions.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode(null, false).getMode(), (String)"Global mode should revert to default READWRITE");
        try {
            this.restApp.restClient.getMode(subject1, false);
            Assertions.fail((String)"Should throw exception for deleted subject1 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject2, false);
            Assertions.fail((String)"Should throw exception for deleted subject2 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject3, false);
            Assertions.fail((String)"Should throw exception for deleted subject3 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
    }

    @Test
    public void testRecursiveDeleteContextModeWhenContextModeNotSet() throws Exception {
        String context = ":.mycontext:";
        String subject1 = ":.mycontext:subject1";
        String subject2 = ":.mycontext:subject2";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject1).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject2).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject1, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode());
        try {
            this.restApp.restClient.getMode(context, false);
            Assertions.fail((String)"Context mode should not be set");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(Collections.emptyMap(), context, true);
        Assertions.assertEquals(null, (Object)deletedMode.getMode(), (String)"Deleted mode should return null as context mode was not set");
        try {
            this.restApp.restClient.getMode(subject1, false);
            Assertions.fail((String)"Should throw exception for deleted subject1 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject2, false);
            Assertions.fail((String)"Should throw exception for deleted subject2 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
    }

    @Test
    public void testRecursiveDeleteMixedContextAndSubjects() throws Exception {
        String context = ":.mycontext:";
        String subject1 = ":.mycontext:subject1";
        String subject2 = ":.mycontext:subject2";
        String subject3 = ":.mycontext:subject3";
        String contextMode = "IMPORT";
        String subject1Mode = "READONLY";
        String subject2Mode = "READWRITE";
        Assertions.assertEquals((Object)contextMode, (Object)this.restApp.restClient.setMode(contextMode, context).getMode());
        Assertions.assertEquals((Object)subject1Mode, (Object)this.restApp.restClient.setMode(subject1Mode, subject1).getMode());
        Assertions.assertEquals((Object)subject2Mode, (Object)this.restApp.restClient.setMode(subject2Mode, subject2).getMode());
        Assertions.assertEquals((Object)contextMode, (Object)this.restApp.restClient.getMode(context, false).getMode());
        Assertions.assertEquals((Object)subject1Mode, (Object)this.restApp.restClient.getMode(subject1, false).getMode());
        Assertions.assertEquals((Object)subject2Mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(Collections.emptyMap(), context, true);
        Assertions.assertEquals((Object)contextMode, (Object)deletedMode.getMode(), (String)"Deleted mode should return the old context mode");
        try {
            this.restApp.restClient.getMode(context, false);
            Assertions.fail((String)"Should throw exception for deleted context mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject1, false);
            Assertions.fail((String)"Should throw exception for deleted subject1 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject2, false);
            Assertions.fail((String)"Should throw exception for deleted subject2 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject3, false);
            Assertions.fail((String)"Subject3 should still have no mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
    }

    @Test
    public void testRecursiveDeleteDoesNotAffectOtherContexts() throws Exception {
        String context1 = ":.context1:";
        String context2 = ":.context2:";
        String subject1 = ":.context1:subject1";
        String subject2 = ":.context2:subject2";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, context1).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, context2).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject1).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject2).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(context1, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(context2, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject1, false).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(Collections.emptyMap(), context1, true);
        Assertions.assertEquals((Object)mode, (Object)deletedMode.getMode(), (String)"Deleted mode should return the old context1 mode");
        try {
            this.restApp.restClient.getMode(context1, false);
            Assertions.fail((String)"Should throw exception for deleted context1 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        try {
            this.restApp.restClient.getMode(subject1, false);
            Assertions.fail((String)"Should throw exception for deleted subject1 mode");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)"Should get mode not configured error");
        }
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(context2, false).getMode(), (String)"Context2 mode should still exist");
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.getMode(subject2, false).getMode(), (String)"Subject2 mode should still exist");
    }
}

