/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.ContextId;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.utils.AppInfoParser;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import ns.MyRecord;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiTest
extends ClusterTestHarness {
    public RestApiTest() {
        super(1, true);
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = TestUtils.getRandomCanonicalAvroString(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = TestUtils.getRandomCanonicalAvroString(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        try {
            this.restApp.restClient.getAllVersions(subject1);
            Assertions.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
        Assertions.assertEquals(Collections.singletonList("."), (Object)this.restApp.restClient.getAllContexts(), (String)"Getting all subjects should return default context");
        Assertions.assertEquals(Collections.singletonList("."), (Object)this.restApp.restClient.getAllContextsWithPagination(1, 0), (String)"Getting all subjects should return default context");
        Assertions.assertEquals(Collections.emptyList(), (Object)this.restApp.restClient.getAllContextsWithPagination(1, 1), (String)"Getting all subjects should return default context");
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should return empty");
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, subject1);
            Assertions.assertEquals((int)expectedId, (int)foundId, (String)"Re-registering an existing schema should return the existing version");
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assertions.assertEquals(allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1), (String)"Getting all versions from subject1 should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2), (String)"Getting all versions from subject2 should match all registered versions");
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals((Object)ImmutableList.of((Object)((String)allSubjects.get(0))), (Object)this.restApp.restClient.getAllSubjectsWithPagination(0, 1), (String)"Getting all subjects with pagination offset=0, limit=1 should return first registered subject");
        Assertions.assertEquals((Object)ImmutableList.of((Object)((String)allSubjects.get(1))), (Object)this.restApp.restClient.getAllSubjectsWithPagination(1, 1), (String)"Getting all subjects with pagination offset=1, limit=1 should return second registered subject");
        List latestSchemas = this.restApp.restClient.getSchemas(null, false, true);
        Assertions.assertEquals((int)2, (int)latestSchemas.size(), (String)"Getting latest schemas should return two schemas");
        Assertions.assertEquals((Integer)10, (Integer)((Schema)latestSchemas.get(0)).getVersion());
        Assertions.assertEquals((Integer)5, (Integer)((Schema)latestSchemas.get(1)).getVersion());
        SchemaString schemaString = this.restApp.restClient.getId(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, null, null, false);
        Assertions.assertNotNull((Object)schemaString.getTimestamp());
        Assertions.assertFalse((boolean)schemaString.getDeleted());
        SchemaString schemaString2 = this.restApp.restClient.getByGuid(RestService.DEFAULT_REQUEST_PROPERTIES, schemaString.getGuid(), null);
        Assertions.assertEquals((Object)schemaString.getGuid(), (Object)schemaString2.getGuid());
        Assertions.assertNotNull((Object)schemaString.getTimestamp());
        Assertions.assertFalse((boolean)schemaString.getDeleted());
        List contextId = this.restApp.restClient.getAllContextIds(RestService.DEFAULT_REQUEST_PROPERTIES, schemaString.getGuid());
        Assertions.assertEquals((int)1, (int)contextId.size());
        Assertions.assertEquals((Object)".", (Object)((ContextId)contextId.get(0)).getContext());
        Assertions.assertEquals((int)1, (Integer)((ContextId)contextId.get(0)).getId());
    }

    @Test
    public void testRegisterSameSchemaOnDifferentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        int id1 = this.restApp.restClient.registerSchema(schema, "subject1");
        int id2 = this.restApp.restClient.registerSchema(schema, "subject2");
        Assertions.assertEquals((int)id1, (int)id2, (String)"Registering the same schema under different subjects should return the same id");
    }

    @Test
    public void testRegisterBadDefault() throws Exception {
        String subject = "testSubject";
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"default\":null,\"name\":\"f\"}]}";
        String schema = AvroUtils.parseSchema((String)schemaString).canonicalString();
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "latest");
            Assertions.fail((String)"Testing compatibility for schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.registerSchema(schema, subject);
            Assertions.fail((String)"Registering schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testRegisterInvalidSchemaBadType() throws Exception {
        String subject = "testSubject";
        String badSchemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"str\",\"name\":\"field1\"}]}";
        String expectedErrorMessage = null;
        try {
            new Schema.Parser().parse(badSchemaString);
            Assertions.fail((String)"Parsing invalid schema string should fail with SchemaParseException");
        }
        catch (Exception spe) {
            expectedErrorMessage = spe.getMessage();
        }
        try {
            this.restApp.restClient.registerSchema(badSchemaString, subject);
            Assertions.fail((String)"Registering schema with invalid field type should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
            Assertions.assertTrue((boolean)rce.getMessage().contains(expectedErrorMessage), (String)"Verify error message verbosity");
        }
    }

    @Test
    public void testRegisterInvalidSchemaBadReference() throws Exception {
        String subject = "testSubject";
        SchemaReference invalidReference = new SchemaReference("invalid.schema", "badSubject", Integer.valueOf(1));
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"}]}";
        try {
            this.restApp.restClient.registerSchema(schemaString, "AVRO", Collections.singletonList(invalidReference), subject);
            Assertions.fail((String)"Registering schema with invalid reference should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testRegisterBadReferenceInContext() throws Exception {
        List<String> avroSchemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "testSubject";
        String avroSchema = avroSchemas.get(0);
        int id1 = this.restApp.restClient.registerSchema(avroSchema, subject);
        Assertions.assertEquals((int)1, (int)id1, (String)"1st schema registered in first context should have id 1");
        String subject2 = ":.ctx:testFoo";
        String avroSchema2 = avroSchemas.get(1);
        int id2 = this.restApp.restClient.registerSchema(avroSchema2, subject2);
        Assertions.assertEquals((int)1, (int)id2, (String)"2nd schema registered in second context should have id 1");
        SchemaReference reference = new SchemaReference("testSubject", "testSubject", Integer.valueOf(1));
        String schemaString = "{\"type\":\"record\",\"name\":\"somerecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"}]}";
        try {
            this.restApp.restClient.lookUpSubjectVersion(schemaString, "AVRO", Collections.singletonList(reference), subject, false);
            Assertions.fail((String)String.format("Subject %s should not be found", subject));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testRegisterDiffSchemaType() throws Exception {
        String subject = "testSubject";
        String avroSchema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String jsonSchema = io.confluent.kafka.schemaregistry.rest.json.RestApiTest.getRandomJsonSchemas(1).get(0);
        String protobufSchema = io.confluent.kafka.schemaregistry.rest.protobuf.RestApiTest.getRandomProtobufSchemas(1).get(0);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        int id1 = this.restApp.restClient.registerSchema(avroSchema, subject);
        Assertions.assertEquals((int)1, (int)id1, (String)"1st schema registered globally should have id 1");
        boolean isCompatible = this.restApp.restClient.testCompatibility(jsonSchema, "JSON", null, subject, "latest", false).isEmpty();
        Assertions.assertTrue((boolean)isCompatible, (String)"Different schema type is allowed when compatibility is NONE");
        int id2 = this.restApp.restClient.registerSchema(jsonSchema, "JSON", null, subject).getId();
        Assertions.assertEquals((int)2, (int)id2, (String)"2nd schema registered globally should have id 2");
        isCompatible = this.restApp.restClient.testCompatibility(protobufSchema, "PROTOBUF", null, subject, "latest", false).isEmpty();
        Assertions.assertTrue((boolean)isCompatible, (String)"Different schema type is allowed when compatibility is NONE");
        int id3 = this.restApp.restClient.registerSchema(protobufSchema, "PROTOBUF", null, subject).getId();
        Assertions.assertEquals((int)3, (int)id3, (String)"3rd schema registered globally should have id 3");
    }

    @Test
    public void testRegisterDiffContext() throws Exception {
        List<String> avroSchemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "testSubject";
        String avroSchema = avroSchemas.get(0);
        int id1 = this.restApp.restClient.registerSchema(avroSchema, subject);
        Assertions.assertEquals((int)1, (int)id1, (String)"1st schema registered in first context should have id 1");
        String subject2 = ":.ctx:testSubject";
        String avroSchema2 = avroSchemas.get(1);
        int id2 = this.restApp.restClient.registerSchema(avroSchema2, subject2);
        Assertions.assertEquals((int)1, (int)id2, (String)"2nd schema registered in second context should have id 1");
        List subjects = this.restApp.restClient.getAllSubjects("", false);
        Assertions.assertEquals(Collections.singletonList(subject), (Object)subjects);
        List schemas = this.restApp.restClient.getSchemas(null, false, false);
        Assertions.assertEquals((Object)avroSchema, (Object)((Schema)schemas.get(0)).getSchema());
        List subjects2 = this.restApp.restClient.getAllSubjects(":.ctx:", false);
        Assertions.assertEquals(Collections.singletonList(subject2), (Object)subjects2);
        List schemas2 = this.restApp.restClient.getSchemas(":.ctx:", false, false);
        Assertions.assertEquals((Object)avroSchema2, (Object)((Schema)schemas2.get(0)).getSchema());
        int id3 = this.restApp.restClient.registerSchema(avroSchema, subject2);
        Assertions.assertEquals((int)2, (int)id3, (String)"3nd schema registered in second context should have id 2");
        SchemaString schemaString = this.restApp.restClient.getId(RestService.DEFAULT_REQUEST_PROPERTIES, 1, subject, null, null, false);
        SchemaString schemaString2 = this.restApp.restClient.getId(RestService.DEFAULT_REQUEST_PROPERTIES, 2, subject2, null, null, false);
        Assertions.assertEquals((Object)schemaString.getGuid(), (Object)schemaString2.getGuid());
        Assertions.assertNotNull((Object)schemaString.getTimestamp());
    }

    @Test
    public void testImportDifferentSchemaOnSameID() throws Exception {
        int id2;
        int id1;
        String schema1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"}]}";
        String schema2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"},{\"type\":\"int\",\"name\":\"field2\",\"default\":0}]}";
        this.restApp.restClient.setMode("IMPORT");
        try {
            id1 = this.restApp.restClient.registerSchema(schema1, "subject1", 1, 1);
            Assertions.assertEquals((int)1, (int)id1);
            id2 = this.restApp.restClient.registerSchema(schema2, "subject1", 2, 1);
            Assertions.fail((String)String.format("Schema2 is registered with id %s, should receive error here", id2));
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42205, (int)e.getErrorCode(), (String)"Overwrite schema for the same ID is not permitted.");
        }
        try {
            id1 = this.restApp.restClient.registerSchema(schema1, "subject1", 1, 1);
            Assertions.assertEquals((int)1, (int)id1);
            id2 = this.restApp.restClient.registerSchema(schema2, "subject2", 1, 1);
            Assertions.fail((String)String.format("Schema2 is registered with id %s, should receive error here", id2));
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42205, (int)e.getErrorCode(), (String)"Overwrite schema for the same ID is not permitted.");
        }
    }

    @Test
    public void testImportSameSchemaDifferentVersion() throws Exception {
        String schema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"}]}";
        this.restApp.restClient.setMode("IMPORT");
        int id1 = this.restApp.restClient.registerSchema(schema, "subject1", 1, 1);
        Assertions.assertEquals((int)1, (int)id1);
        id1 = this.restApp.restClient.registerSchema(schema, "subject1", 2, 1);
        Assertions.assertEquals((int)1, (int)id1);
        id1 = this.restApp.restClient.registerSchema(schema, "subject1", 1, 1);
        Assertions.assertEquals((int)1, (int)id1);
    }

    @Test
    public void testCompatibleSchemaLookupBySubject() throws Exception {
        String subject = "testSubject";
        int numRegisteredSchemas = 0;
        int numSchemas = 10;
        List<String> allSchemas = TestUtils.getRandomCanonicalAvroString(numSchemas);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        this.restApp.restClient.registerSchema(allSchemas.get(0), subject);
        ++numRegisteredSchemas;
        String schema1 = allSchemas.get(0);
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema1, subject, "latest").isEmpty();
        Assertions.assertTrue((boolean)isCompatible, (String)"First schema registered should be compatible");
        for (int i = 0; i < numSchemas; ++i) {
            String schema = allSchemas.get(i);
            isCompatible = this.restApp.restClient.testCompatibility(schema, subject, "latest").isEmpty();
            TestUtils.checkNumberOfVersions(this.restApp.restClient, numRegisteredSchemas, subject);
        }
    }

    @Test
    public void testIncompatibleSchemaLookupBySubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"f\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        int versionOfRegisteredSchema = this.restApp.restClient.lookUpSubjectVersion(schema1, subject).getVersion();
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema2, subject, String.valueOf(versionOfRegisteredSchema)).isEmpty();
        Assertions.assertFalse((boolean)isCompatible, (String)"Schema should be incompatible with specified version");
    }

    @Test
    public void testIncompatibleSchemaBySubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"},{\"type\":\"string\",\"name\":\"f2\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        String schema3String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"},{\"type\":\"string\",\"name\":\"f3\"}]}";
        String schema3 = AvroUtils.parseSchema((String)schema3String).canonicalString();
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD_TRANSITIVE.name, subject);
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema3, subject, "latest").isEmpty();
        Assertions.assertTrue((boolean)isCompatible, (String)"Schema is compatible with the latest version");
        isCompatible = this.restApp.restClient.testCompatibility(schema3, subject, null).isEmpty();
        Assertions.assertFalse((boolean)isCompatible, (String)"Schema should be incompatible with FORWARD_TRANSITIVE setting");
        try {
            this.restApp.restClient.registerSchema(schema3String, subject);
            Assertions.fail((String)"Schema register should fail since schema is incompatible");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE, (int)e.getErrorCode());
            Assertions.assertFalse((boolean)e.getMessage().isEmpty());
            Assertions.assertTrue((boolean)e.getMessage().contains("oldSchemaVersion:"));
            Assertions.assertTrue((boolean)e.getMessage().contains("oldSchema:"));
            Assertions.assertTrue((boolean)e.getMessage().contains("compatibility:"));
        }
    }

    @Test
    public void testBadFormat() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        this.restApp.restClient.registerSchema(schema1, subject);
        SchemaString schemaString = this.restApp.restClient.getId(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, "bad-format", null, false);
        Assertions.assertEquals((Object)schema1, (Object)schemaString.getSchemaString(), (String)"Registered schema should be found");
    }

    @Test
    public void testSchemaRegistrationUnderDiffSubjects() throws Exception {
        String subject1 = "testSubject1";
        String subject2 = "testSubject2";
        String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schemaString1).canonicalString();
        String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"foo\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schemaString2).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject1);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject2);
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(schema1, subject1);
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(schema1, subject1).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSchema1Subject1, (String)"1st schema under subject1 should have version 1");
        Assertions.assertEquals((int)1, (int)idOfRegisteredSchema1Subject1, (String)"1st schema registered globally should have id 1");
        int idOfRegisteredSchema2Subject1 = this.restApp.restClient.registerSchema(schema2, subject1);
        int versionOfRegisteredSchema2Subject1 = this.restApp.restClient.lookUpSubjectVersion(schema2, subject1).getVersion();
        Assertions.assertEquals((int)2, (int)versionOfRegisteredSchema2Subject1, (String)"2nd schema under subject1 should have version 2");
        Assertions.assertEquals((int)2, (int)idOfRegisteredSchema2Subject1, (String)"2nd schema registered globally should have id 2");
        int idOfRegisteredSchema2Subject2 = this.restApp.restClient.registerSchema(schema2, subject2);
        int versionOfRegisteredSchema2Subject2 = this.restApp.restClient.lookUpSubjectVersion(schema2, subject2).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSchema2Subject2, (String)"2nd schema under subject1 should still have version 1 as the first schema under subject2");
        Assertions.assertEquals((int)2, (int)idOfRegisteredSchema2Subject2, (String)"Since schema is globally registered but not under subject2, id should not change");
    }

    @Test
    public void testConfigDefaults() throws Exception {
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Default compatibility level should be none for this test instance");
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null);
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"New compatibility level should be forward for this test instance");
    }

    @Test
    public void testNonExistentSubjectConfigChange() throws Exception {
        String subject = "testSubject";
        try {
            this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, subject);
        }
        catch (RestClientException e) {
            Assertions.fail((String)"Changing config for an invalid subject should succeed");
        }
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel(), (String)"New compatibility level for this subject should be forward");
    }

    @Test
    public void testSubjectConfigChange() throws Exception {
        String subject = "testSubject";
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Default compatibility level should be none for this test instance");
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, subject);
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Global compatibility level should remain none for this test instance");
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel(), (String)"New compatibility level for this subject should be forward");
        this.restApp.restClient.deleteConfig(subject);
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true).getCompatibilityLevel(), (String)"Compatibility level for this subject should be reverted to none");
    }

    @Test
    public void testGlobalConfigChange() throws Exception {
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Default compatibility level should be none for this test instance");
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null);
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"New Global compatibility level should be forward");
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, null);
        Assertions.assertEquals((Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"New Global compatibility level should be backward");
        this.restApp.restClient.deleteConfig(null);
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, null, true).getCompatibilityLevel(), (String)"Global compatibility level should be reverted to none");
    }

    @Test
    public void testDefaultContextConfigAndMode() throws Exception {
        String defaultContext = ":.:";
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest();
        configUpdateRequest.setCompatibilityLevel(CompatibilityLevel.FORWARD.name());
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null));
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, defaultContext, true).getCompatibilityLevel());
        configUpdateRequest = new ConfigUpdateRequest();
        configUpdateRequest.setCompatibilityLevel(CompatibilityLevel.FORWARD_TRANSITIVE.name());
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, defaultContext));
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD_TRANSITIVE.name, (Object)this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, null, true).getCompatibilityLevel());
        this.restApp.restClient.deleteConfig(defaultContext);
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, null, true).getCompatibilityLevel());
        ModeUpdateRequest modeUpdateRequest = new ModeUpdateRequest(io.confluent.kafka.schemaregistry.storage.Mode.IMPORT.name());
        Assertions.assertEquals((Object)modeUpdateRequest, (Object)this.restApp.restClient.setMode(io.confluent.kafka.schemaregistry.storage.Mode.IMPORT.name(), null));
        Assertions.assertEquals((Object)io.confluent.kafka.schemaregistry.storage.Mode.IMPORT.name(), (Object)this.restApp.restClient.getMode(defaultContext, true).getMode());
        modeUpdateRequest = new ModeUpdateRequest(io.confluent.kafka.schemaregistry.storage.Mode.READONLY.name());
        Assertions.assertEquals((Object)modeUpdateRequest, (Object)this.restApp.restClient.setMode(io.confluent.kafka.schemaregistry.storage.Mode.READONLY.name(), defaultContext));
        Assertions.assertEquals((Object)io.confluent.kafka.schemaregistry.storage.Mode.READONLY.name(), (Object)this.restApp.restClient.getMode(null, true).getMode());
        Mode deletedMode = this.restApp.restClient.deleteSubjectMode(defaultContext);
        Assertions.assertEquals((Object)io.confluent.kafka.schemaregistry.storage.Mode.READONLY.name(), (Object)deletedMode.getMode(), (String)"Deleted mode should return the old mode");
        Assertions.assertEquals((Object)io.confluent.kafka.schemaregistry.storage.Mode.READWRITE.name(), (Object)this.restApp.restClient.getMode(null, true).getMode(), (String)"Mode should revert to global mode after deleting default context mode");
    }

    @Test
    public void testGetSchemaNonExistingId() throws Exception {
        try {
            this.restApp.restClient.getId(100);
            Assertions.fail((String)"Schema lookup by missing id should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing id");
        }
    }

    @Test
    public void testGetSchemaWithFetchMaxId() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(3);
        int latestId = 0;
        for (String schema : schemas) {
            latestId = this.restApp.restClient.registerSchema(schema, "subject");
        }
        Assertions.assertNull((Object)this.restApp.restClient.getId(1).getMaxId());
        Assertions.assertEquals((Integer)latestId, (Integer)this.restApp.restClient.getId(1, null, true).getMaxId());
    }

    @Test
    public void testGetSchemaTypes() throws Exception {
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("AVRO", "JSON", "PROTOBUF")), new HashSet(this.restApp.restClient.getSchemaTypes()));
    }

    @Test
    public void testListVersionsNonExistingSubject() throws Exception {
        try {
            this.restApp.restClient.getAllVersions("Invalid");
            Assertions.fail((String)"Getting all versions of missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
    }

    @Test
    public void testGetVersionNonExistentSubject() throws Exception {
        try {
            this.restApp.restClient.getVersion("non-existing-subject", 1);
            Assertions.fail((String)"Getting version of missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40401, (int)e.getErrorCode(), (String)"Unregistered subject shouldn't be found in getVersion()");
        }
    }

    @Test
    public void testGetNonExistingVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.getVersion(subject, 200);
            Assertions.fail((String)"Getting unregistered version should fail with 40402 (version not found)");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40402, (int)e.getErrorCode(), (String)"Unregistered version shouldn't be found");
        }
    }

    @Test
    public void testGetInvalidVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.getVersion(subject, 0);
            Assertions.fail((String)"Getting invalid version should fail with 42202 (invalid version)");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42202, (int)e.getErrorCode(), (String)"Invalid version shouldn't be found");
        }
    }

    @Test
    public void testRegisterInvalidSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "\rbad\nsubject\t";
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
            Assertions.fail((String)"Registering invalid subject should fail with 42208 (invalid subject)");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42208, (int)e.getErrorCode(), (String)"Invalid subject shouldn't be registered");
        }
    }

    @Test
    public void testGetVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assertions.assertEquals((Object)schemas.get(0), (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Version 1 schema should match");
        Assertions.assertEquals((Object)schemas.get(1), (Object)this.restApp.restClient.getVersion(subject, 2).getSchema(), (String)"Version 2 schema should match");
        Assertions.assertEquals((Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema(), (String)"Latest schema should be the same as version 2");
    }

    @Test
    public void testGetOnlySchemaById() throws Exception {
        String schema = String.valueOf(TestUtils.getRandomCanonicalAvroString(1));
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        Assertions.assertEquals((Object)schema, (Object)this.restApp.restClient.getOnlySchemaById(1), (String)"Schema with ID 1 should match.");
    }

    @Test
    public void testGetLatestVersionSchemaOnly() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assertions.assertEquals((Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersionSchemaOnly(subject), (String)"Latest schema should be the same as version 2");
    }

    @Test
    public void testGetVersionSchemaOnly() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(1);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        Assertions.assertEquals((Object)schemas.get(0), (Object)this.restApp.restClient.getVersionSchemaOnly(subject, 1), (String)"Retrieved schema should be the same as version 1");
    }

    @Test
    public void testSchemaReferences() throws Exception {
        this.testSchemaReferencesInContext("", "", 2);
    }

    @Test
    public void testSchemaReferencesSameContext() throws Exception {
        this.testSchemaReferencesInContext(":.ctx:", ":.ctx:", 2);
    }

    @Test
    public void testSchemaReferencesDifferentContext() throws Exception {
        this.testSchemaReferencesInContext("", ":.ctx:", 1);
    }

    private void testSchemaReferencesInContext(String context, String refContext, int parentId) throws Exception {
        List<String> schemas = TestUtils.getAvroSchemaWithReferences();
        String unqualifiedSubject = "my_reference";
        String subject = refContext + unqualifiedSubject;
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get(1));
        SchemaReference ref = new SchemaReference("otherns.Subrecord", subject, Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        String subject2 = context + "my_referrer";
        int registeredId = this.restApp.restClient.registerSchema(request, subject2, false).getId();
        Assertions.assertEquals((int)parentId, (int)registeredId, (String)"Registering a new schema should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(parentId, subject2);
        Assertions.assertEquals((Object)subject2, (Object)schemaString.getSubject());
        Assertions.assertEquals((int)1, (Integer)schemaString.getVersion());
        Assertions.assertEquals((Object)schemas.get(1), (Object)schemaString.getSchemaString(), (String)"Registered schema should be found");
        Assertions.assertEquals(Collections.singletonList(ref), (Object)schemaString.getReferences(), (String)"Schema references should be found");
        List refs = this.restApp.restClient.getReferencedBy(subject, 1);
        Assertions.assertEquals((int)parentId, (int)((Integer)refs.get(0)));
        MyRecord myrecord = new MyRecord();
        AvroSchema schema = new AvroSchema(AvroSchemaUtils.getSchema((Object)((Object)myrecord)));
        Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "AVRO", Collections.emptyList(), subject2, false);
        Assertions.assertEquals((int)parentId, (int)registeredSchema.getId(), (String)"Registered schema should be found");
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, String.valueOf(1));
            Assertions.fail((String)"Deleting reference should fail with 42206");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42206, (int)rce.getErrorCode(), (String)"Reference found");
        }
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"));
        refs = this.restApp.restClient.getReferencedBy(subject, 1);
        Assertions.assertTrue((boolean)refs.isEmpty());
        refs = this.restApp.restClient.getReferencedByWithPagination(subject, 1, 0, 1);
        Assertions.assertTrue((boolean)refs.isEmpty());
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"));
    }

    @Test
    public void testSchemaUnqualifiedReferencesInContext() throws Exception {
        String context = ":.ctx:";
        int parentId = 2;
        List<String> schemas = TestUtils.getAvroSchemaWithReferences();
        String unqualifiedSubject = "my_reference";
        String subject = context + unqualifiedSubject;
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get(1));
        SchemaReference ref = new SchemaReference("otherns.Subrecord", unqualifiedSubject, Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        String subject2 = context + "my_referrer";
        int registeredId = this.restApp.restClient.registerSchema(request, subject2, false).getId();
        Assertions.assertEquals((int)parentId, (int)registeredId, (String)"Registering a new schema should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(parentId, subject2);
        Assertions.assertEquals((Object)subject2, (Object)schemaString.getSubject());
        Assertions.assertEquals((int)1, (Integer)schemaString.getVersion());
        Assertions.assertFalse((boolean)((SchemaReference)schemaString.getReferences().get(0)).getSubject().startsWith(context));
        Schema schemaResult = this.restApp.restClient.getVersion(subject2, 1);
        Assertions.assertEquals((Object)subject2, (Object)schemaResult.getSubject());
        Assertions.assertEquals((int)1, (Integer)schemaResult.getVersion());
        Assertions.assertFalse((boolean)((SchemaReference)schemaResult.getReferences().get(0)).getSubject().startsWith(context));
        SchemaString schemaString2 = this.restApp.restClient.getId(RestService.DEFAULT_REQUEST_PROPERTIES, parentId, subject2, null, "qualified", null, false);
        Assertions.assertEquals((Object)subject2, (Object)schemaString2.getSubject());
        Assertions.assertEquals((int)1, (Integer)schemaString2.getVersion());
        Assertions.assertTrue((boolean)((SchemaReference)schemaString2.getReferences().get(0)).getSubject().startsWith(context));
        Schema schemaResult2 = this.restApp.restClient.getVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, 1, null, "qualified", false, null);
        Assertions.assertEquals((Object)subject2, (Object)schemaResult2.getSubject());
        Assertions.assertEquals((int)1, (Integer)schemaResult2.getVersion());
        Assertions.assertTrue((boolean)((SchemaReference)schemaResult2.getReferences().get(0)).getSubject().startsWith(context));
        Assertions.assertEquals((Object)schemas.get(1), (Object)schemaString.getSchemaString(), (String)"Registered schema should be found");
        Assertions.assertEquals(Collections.singletonList(ref), (Object)schemaString.getReferences(), (String)"Schema references should be found");
        List refs = this.restApp.restClient.getReferencedBy(subject, 1);
        Assertions.assertEquals((int)parentId, (int)((Integer)refs.get(0)));
        MyRecord myrecord = new MyRecord();
        AvroSchema schema = new AvroSchema(AvroSchemaUtils.getSchema((Object)((Object)myrecord)));
        Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "AVRO", Collections.emptyList(), subject2, false);
        Assertions.assertEquals((int)parentId, (int)registeredSchema.getId(), (String)"Registered schema should be found");
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, String.valueOf(1));
            Assertions.fail((String)"Deleting reference should fail with 42206");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42206, (int)rce.getErrorCode(), (String)"Reference found");
        }
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"));
        refs = this.restApp.restClient.getReferencedBy(subject, 1);
        Assertions.assertTrue((boolean)refs.isEmpty());
        refs = this.restApp.restClient.getReferencedByWithPagination(subject, 1, 0, 1);
        Assertions.assertTrue((boolean)refs.isEmpty());
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"));
    }

    @Test
    public void testSchemaReferencesMultipleLevels() throws Exception {
        String root = "[\"myavro.BudgetDecreased\",\"myavro.BudgetUpdated\"]";
        String ref1 = "{\n  \"type\" : \"record\",\n  \"name\" : \"BudgetDecreased\",\n  \"namespace\" : \"myavro\",\n  \"fields\" : [ {\n    \"name\" : \"buyerId\",\n    \"type\" : \"long\"\n  }, {\n    \"name\" : \"currency\",\n    \"type\" : {\n      \"type\" : \"myavro.currencies.Currency\"    }\n  }, {\n    \"name\" : \"amount\",\n    \"type\" : \"double\"\n  } ]\n}";
        String ref2 = "{\n  \"type\" : \"record\",\n  \"name\" : \"BudgetUpdated\",\n  \"namespace\" : \"myavro\",\n  \"fields\" : [ {\n    \"name\" : \"buyerId\",\n    \"type\" : \"long\"\n  }, {\n    \"name\" : \"currency\",\n    \"type\" : {\n      \"type\" : \"myavro.currencies.Currency\"    }\n  }, {\n    \"name\" : \"updatedValue\",\n    \"type\" : \"double\"\n  } ]\n}";
        String sharedRef = "{\n      \"type\" : \"enum\",\n      \"name\" : \"Currency\",\n      \"namespace\" : \"myavro.currencies\",\n      \"symbols\" : [ \"EUR\", \"USD\" ]\n    }\n";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, new AvroSchema(sharedRef).canonicalString(), 1, "shared");
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(ref1);
        SchemaReference ref = new SchemaReference("myavro.currencies.Currency", "shared", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        int registeredId = this.restApp.restClient.registerSchema(request, "ref1", false).getId();
        Assertions.assertEquals((int)2, (int)registeredId, (String)"Registering a new schema should succeed");
        request = new RegisterSchemaRequest();
        request.setSchema(ref2);
        ref = new SchemaReference("myavro.currencies.Currency", "shared", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        registeredId = this.restApp.restClient.registerSchema(request, "ref2", false).getId();
        Assertions.assertEquals((int)3, (int)registeredId, (String)"Registering a new schema should succeed");
        request = new RegisterSchemaRequest();
        request.setSchema(root);
        SchemaReference r1 = new SchemaReference("myavro.BudgetDecreased", "ref1", Integer.valueOf(1));
        SchemaReference r2 = new SchemaReference("myavro.BudgetUpdated", "ref2", Integer.valueOf(1));
        request.setReferences(Arrays.asList(r1, r2));
        registeredId = this.restApp.restClient.registerSchema(request, "root", false).getId();
        Assertions.assertEquals((int)4, (int)registeredId, (String)"Registering a new schema should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(4);
        Assertions.assertEquals((Object)root, (Object)schemaString.getSchemaString(), (String)"Registered schema should be found");
        Assertions.assertEquals(Arrays.asList(r1, r2), (Object)schemaString.getReferences(), (String)"Schema references should be found");
        SchemaString schemaString2 = this.restApp.restClient.getId(RestService.DEFAULT_REQUEST_PROPERTIES, 4, "root", "resolved", null, false);
        Assertions.assertEquals((Object)schemaString.getGuid(), (Object)schemaString2.getGuid());
    }

    @Test
    public void testSchemaMissingReferences() throws Exception {
        Assertions.assertThrows(RestClientException.class, () -> {
            List<String> schemas = TestUtils.getAvroSchemaWithReferences();
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get(1));
            request.setReferences(Collections.emptyList());
            this.restApp.restClient.registerSchema(request, "referrer", false);
        });
    }

    @Test
    public void testSchemaNormalization() throws Exception {
        String subject1 = "testSubject1";
        String reference1 = "{\"type\":\"record\",\"name\":\"Subrecord1\",\"namespace\":\"otherns\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, reference1, 1, "ref1");
        String reference2 = "{\"type\":\"record\",\"name\":\"Subrecord2\",\"namespace\":\"otherns\",\"fields\":[{\"name\":\"field2\",\"type\":\"string\"}]}";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, reference2, 2, "ref2");
        SchemaReference ref1 = new SchemaReference("otherns.Subrecord1", "ref1", Integer.valueOf(1));
        SchemaReference ref2 = new SchemaReference("otherns.Subrecord2", "ref2", Integer.valueOf(1));
        String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":{\"type\":\"int\"},\"name\":\"field0\"},{\"name\":\"field1\",\"type\":\"otherns.Subrecord1\"},{\"name\":\"field2\",\"type\":\"otherns.Subrecord2\"}],\"extraMetadata\": {\"a\": 1, \"b\": 2}}";
        String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"field0\"},{\"name\":\"field1\",\"type\":\"otherns.Subrecord1\"},{\"name\":\"field2\",\"type\":\"otherns.Subrecord2\"}],\"extraMetadata\": {\"b\": 2, \"a\": 1}}";
        RegisterSchemaRequest registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(schemaString1);
        registerRequest.setReferences(Arrays.asList(ref1, ref2));
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(registerRequest, subject1, true).getId();
        RegisterSchemaRequest lookUpRequest = new RegisterSchemaRequest();
        lookUpRequest.setSchema(schemaString2);
        lookUpRequest.setReferences(Arrays.asList(ref2, ref1));
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSchema1Subject1, (String)"1st schema under subject1 should have version 1");
        Assertions.assertEquals((int)3, (int)idOfRegisteredSchema1Subject1, (String)"1st schema registered globally should have id 3");
        lookUpRequest = new RegisterSchemaRequest();
        Schema.Parser parser = new Schema.Parser();
        parser.parse(reference1);
        parser.parse(reference2);
        AvroSchema resolvedSchema = new AvroSchema(parser.parse(schemaString2));
        lookUpRequest.setSchema(resolvedSchema.canonicalString());
        versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSchema1Subject1, (String)"1st schema under subject1 should have version 1");
        String recordInvalidDefaultSchema = "{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": null}\n]\n}";
        registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(recordInvalidDefaultSchema);
        try {
            this.restApp.restClient.registerSchema(registerRequest, subject1, true);
            Assertions.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        List messages = this.restApp.restClient.testCompatibility(registerRequest, subject1, null, true, true);
        Assertions.assertTrue((!messages.isEmpty() && ((String)messages.get(0)).contains("Invalid schema") ? 1 : 0) != 0);
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should return empty");
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, TestUtils.getBadSchema(), 1, subject1);
            Assertions.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, TestUtils.getRandomCanonicalAvroString(1).get(0), (List<SchemaReference>)ImmutableList.of((Object)new SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assertions.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
    }

    @Test
    public void testLookUpSchemaUnderNonExistentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        try {
            this.restApp.restClient.lookUpSubjectVersion(schema, "non-existent-subject");
            Assertions.fail((String)"Looking up schema under missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Subject not found");
        }
    }

    @Test
    public void testLookUpNonExistentSchemaUnderSubject() throws Exception {
        String subject = "test";
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        try {
            this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject);
            Assertions.fail((String)"Looking up missing schema under subject should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testGetSubjectsAssociatedWithSchemaId() throws Exception {
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject2);
        List associatedSubjects = this.restApp.restClient.getAllSubjectsById(1);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)2);
        Assertions.assertEquals(Arrays.asList(subject1, subject2), (Object)associatedSubjects);
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"), (String)"Deleting Schema Version Success");
        associatedSubjects = this.restApp.restClient.getAllSubjectsById(1);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)1);
        Assertions.assertEquals(Collections.singletonList(subject1), (Object)associatedSubjects);
        associatedSubjects = this.restApp.restClient.getAllSubjectsByIdWithPagination(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, false, 1, 1);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)0);
        Assertions.assertEquals(Collections.emptyList(), (Object)associatedSubjects);
        associatedSubjects = this.restApp.restClient.getAllSubjectsById(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, true);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)2);
        Assertions.assertEquals(Arrays.asList(subject1, subject2), (Object)associatedSubjects);
        associatedSubjects = this.restApp.restClient.getAllSubjectsByIdWithPagination(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, true, 1, 0);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)1);
        Assertions.assertEquals(Collections.singletonList(subject1), (Object)associatedSubjects);
    }

    @Test
    public void testGetSubjectsAssociatedWithNotFoundSchemaId() throws Exception {
        try {
            this.restApp.restClient.getAllSubjectsById(1);
            Assertions.fail((String)"Getting all subjects associated with id 1 should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing schema");
        }
    }

    @Test
    public void testGetVersionsAssociatedWithSchemaId() throws Exception {
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject2);
        List associatedSubjects = this.restApp.restClient.getAllVersionsById(1);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)2);
        Assertions.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject1, Integer.valueOf(1))));
        Assertions.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject2, Integer.valueOf(1))));
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"), (String)"Deleting Schema Version Success");
        associatedSubjects = this.restApp.restClient.getAllVersionsById(1);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)1);
        Assertions.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject1, Integer.valueOf(1))));
        associatedSubjects = this.restApp.restClient.getAllVersionsByIdWithPagination(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, false, 1, 1);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)0);
        associatedSubjects = this.restApp.restClient.getAllVersionsById(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, true);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)2);
        Assertions.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject1, Integer.valueOf(1))));
        Assertions.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject2, Integer.valueOf(1))));
        associatedSubjects = this.restApp.restClient.getAllVersionsByIdWithPagination(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, true, 1, 1);
        Assertions.assertEquals((int)associatedSubjects.size(), (int)1);
        Assertions.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject2, Integer.valueOf(1))));
    }

    @Test
    public void testCompatibilityNonExistentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        boolean result = this.restApp.restClient.testCompatibility(schema, "non-existent-subject", "latest").isEmpty();
        Assertions.assertTrue((boolean)result, (String)"Compatibility succeeds");
        result = this.restApp.restClient.testCompatibility(schema, "non-existent-subject", null).isEmpty();
        Assertions.assertTrue((boolean)result, (String)"Compatibility succeeds");
    }

    @Test
    public void testCompatibilityNonExistentVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "100");
            Assertions.fail((String)"Testing compatibility for missing version should fail with 40402 (version not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40402, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testCompatibilityInvalidVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "earliest");
            Assertions.fail((String)"Testing compatibility for invalid version should fail with 42202 (version not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42202, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testGetConfigNonExistentSubject() throws Exception {
        try {
            this.restApp.restClient.getConfig("non-existent-subject");
            Assertions.fail((String)"Getting the configuration of a missing subject should fail with 40401 error code (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40408, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testCanonicalization() throws Exception {
        String schema = "{   \"type\":   \"string\"}";
        String subject = "test";
        Assertions.assertEquals((int)1, (int)this.restApp.restClient.registerSchema(schema, subject), (String)"Registering a new schema should succeed");
        Assertions.assertEquals((int)1, (int)this.restApp.restClient.registerSchema(schema, subject), (String)"Registering the same schema should get back the same id");
        Assertions.assertEquals((int)1, (int)this.restApp.restClient.lookUpSubjectVersion(schema, subject).getId(), (String)"Lookup the same schema should get back the same id");
    }

    @Test
    public void testDeleteSchemaVersionBasic() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assertions.assertEquals((Integer)2, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2"), (String)"Deleting Schema Version Success");
        Assertions.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getAllVersions(subject));
        Schema schema = this.restApp.restClient.getVersion(subject, 2, true);
        Assertions.assertEquals((Integer)2, (Integer)schema.getVersion());
        Assertions.assertTrue((boolean)schema.getDeleted());
        try {
            this.restApp.restClient.getVersion(subject, 2);
            Assertions.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40402, (int)rce.getErrorCode(), (String)"Version not found");
        }
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get(1));
            this.restApp.restClient.lookUpSubjectVersion(RestService.DEFAULT_REQUEST_PROPERTIES, request, subject, false, false);
            Assertions.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode(), (String)"Schema not found");
        }
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"), (String)"Deleting Schema Version Success");
        try {
            List versions = this.restApp.restClient.getAllVersions(subject);
            Assertions.fail((String)("Getting all versions from non-existing subject1 should fail with 40401 (subject not found). Got " + String.valueOf(versions)));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
        for (int i = 0; i < 2; ++i) {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
            Assertions.assertEquals(Collections.singletonList(3), (Object)this.restApp.restClient.getAllVersions(subject));
        }
    }

    @Test
    public void testDeleteSchemaVersionPermanent() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true);
            Assertions.fail((String)"Permanent deleting first time should throw schemaVersionNotSoftDeletedException");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40407, (int)rce.getErrorCode(), (String)"Schema version must be soft deleted first");
        }
        Assertions.assertEquals((Integer)2, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2"), (String)"Deleting Schema Version Success");
        Assertions.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getAllVersions(subject));
        Assertions.assertEquals(Arrays.asList(1, 2), (Object)this.restApp.restClient.getAllVersions(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true));
        Assertions.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getAllVersionsWithPagination(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true, 0, 1));
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
            Assertions.fail((String)"Soft deleting second time should throw schemaVersionSoftDeletedException");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40406, (int)rce.getErrorCode(), (String)"Schema version already soft deleted");
        }
        try {
            this.restApp.restClient.getVersion(subject, 2);
            Assertions.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40402, (int)rce.getErrorCode(), (String)"Version not found");
        }
        Schema schema = this.restApp.restClient.getVersion(subject, 2, true);
        Assertions.assertEquals((Integer)2, (Integer)schema.getVersion());
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get(1));
            this.restApp.restClient.lookUpSubjectVersion(RestService.DEFAULT_REQUEST_PROPERTIES, request, subject, false, false);
            Assertions.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode());
        }
        Assertions.assertEquals((Integer)2, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true), (String)"Deleting Schema Version Success");
        try {
            this.restApp.restClient.getVersion(subject, 2, true);
            Assertions.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40402, (int)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true);
            Assertions.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40402, (int)rce.getErrorCode());
        }
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"), (String)"Deleting Schema Version Success");
        try {
            List versions = this.restApp.restClient.getAllVersions(subject);
            Assertions.fail((String)("Getting all versions from non-existing subject1 should fail with 40401 (subject not found). Got " + String.valueOf(versions)));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
        for (int i = 0; i < 2; ++i) {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
            Assertions.assertEquals(Collections.singletonList(2), (Object)this.restApp.restClient.getAllVersions(subject));
        }
    }

    @Test
    public void testDeleteSchemaVersionInvalidSubject() throws Exception {
        try {
            String subject = "test";
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
            Assertions.fail((String)"Deleting a non existent subject version should fail with 40401 error code (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Subject not found");
        }
    }

    @Test
    public void testDeleteLatestVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(3);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assertions.assertEquals((Integer)2, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"), (String)"Deleting Schema Version Success");
        Schema schema = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemas.get(0), (Object)schema.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"), (String)"Deleting Schema Version Success");
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assertions.fail((String)"Getting latest versions from non-existing subject should fail with 40401 (subject not found).");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(2), 3, subject);
        Assertions.assertEquals((Object)schemas.get(2), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema(), (String)"Latest version available after subject re-registration");
    }

    @Test
    public void testDeleteAndCreateWithDanglingReference() throws Exception {
        int parentId = 2;
        this.testSchemaReferencesInContext("", "", parentId);
        String subject = "my_reference";
        String subject2 = "my_referrer";
        List<String> schemas = TestUtils.getAvroSchemaWithReferences();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get(1));
        SchemaReference ref = new SchemaReference("otherns.Subrecord", subject, Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        try {
            this.restApp.restClient.registerSchema(request, subject2, false).getId();
            Assertions.fail((String)"Registration should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1", true));
        try {
            this.restApp.restClient.registerSchema(request, subject2, false).getId();
            Assertions.fail((String)"Registration should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testReviveSchemaWithDanglingReference() throws Exception {
        String refSchema = "{\"type\":\"record\",\"name\":\"Ref\",\"namespace\":\"com.example\",\"fields\":[{\"name\":\"id\",\"type\":\"string\"}]}";
        int refId = this.restApp.restClient.registerSchema(refSchema, "ref");
        Assertions.assertEquals((int)1, (int)refId);
        String baseSchema = "{\"type\":\"record\",\"name\":\"Base\",\"namespace\":\"com.example\",\"fields\":[{\"name\":\"refField\",\"type\":\"com.example.Ref\"}]}";
        RegisterSchemaRequest baseRequest = new RegisterSchemaRequest();
        baseRequest.setSchema(baseSchema);
        SchemaReference ref = new SchemaReference("com.example.Ref", "ref", Integer.valueOf(1));
        baseRequest.setReferences(Collections.singletonList(ref));
        RegisterSchemaResponse response = this.restApp.restClient.registerSchema(baseRequest, "base", false);
        Assertions.assertEquals((int)2, (int)response.getId());
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "base", "1"));
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "ref", "1"));
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "ref", "1", true));
        try {
            this.restApp.restClient.registerSchema(baseRequest, "base", false);
            Assertions.fail((String)"Re-registering base schema with dangling reference should fail");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
        String modifiedBaseSchema = "{\"type\":\"record\",\"name\":\"Base\",\"namespace\":\"com.example\",\"fields\":[{\"name\":\"refField\",\"type\":\"com.example.Ref\"},{\"name\":\"newField\",\"type\":\"string\"}]}";
        RegisterSchemaRequest modifiedRequest = new RegisterSchemaRequest();
        modifiedRequest.setSchema(modifiedBaseSchema);
        modifiedRequest.setReferences(Collections.singletonList(ref));
        try {
            this.restApp.restClient.registerSchema(modifiedRequest, "base", false);
            Assertions.fail((String)"Registering modified schema with dangling reference should fail");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testGetLatestVersionNonExistentSubject() throws Exception {
        String subject = "non_existent_subject";
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assertions.fail((String)"Getting latest versions from non-existing subject should fail with 40401 (subject not found).");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
    }

    @Test
    public void testGetLatestVersionDeleteOlder() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assertions.assertEquals((Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema());
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"), (String)"Deleting Schema Older Version Success");
        Assertions.assertEquals((Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema(), (String)"Latest Version Schema Still Same");
    }

    @Test
    public void testDeleteInvalidVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(1);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40402, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject version");
        }
    }

    @Test
    public void testDeleteWithLookup() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"), (String)"Deleting Schema Version Success");
        try {
            this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
            Assertions.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode());
        }
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assertions.assertEquals((Integer)1, (Integer)schema.getVersion());
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assertions.assertEquals((Integer)3, (Integer)schema.getVersion());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
        Assertions.assertEquals((Integer)3, (Integer)schema.getVersion());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject);
        Assertions.assertEquals((Integer)3, (Integer)schema.getVersion());
    }

    @Test
    public void testIncompatibleSchemaLookupBySubjectAfterDelete() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String wrongSchema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String wrongSchema2 = AvroUtils.parseSchema((String)wrongSchema2String).canonicalString();
        String correctSchema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"int\",\"name\":\"g\" , \"default\":0}]}";
        String correctSchema2 = AvroUtils.parseSchema((String)correctSchema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        boolean isCompatible = this.restApp.restClient.testCompatibility(wrongSchema2, subject, "latest").isEmpty();
        Assertions.assertTrue((boolean)isCompatible, (String)"Schema should be compatible with specified version");
        this.restApp.restClient.registerSchema(wrongSchema2, subject);
        isCompatible = this.restApp.restClient.testCompatibility(correctSchema2, subject, "latest").isEmpty();
        Assertions.assertFalse((boolean)isCompatible, (String)"Schema should be incompatible with specified version");
        try {
            this.restApp.restClient.registerSchema(correctSchema2, subject);
            Assertions.fail((String)"Schema should be Incompatible");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE, (int)rce.getErrorCode());
        }
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest");
        isCompatible = this.restApp.restClient.testCompatibility(correctSchema2, subject, "latest").isEmpty();
        Assertions.assertTrue((boolean)isCompatible, (String)"Schema should be compatible with specified version");
        this.restApp.restClient.registerSchema(correctSchema2, subject);
        Assertions.assertEquals((Integer)3, (Integer)this.restApp.restClient.lookUpSubjectVersion(correctSchema2String, subject).getVersion(), (String)"Version is same");
    }

    @Test
    public void testSubjectCompatibilityAfterDeletingAllVersions() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, null);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
        Assertions.assertEquals((Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel(), (String)"Compatibility Level Exists");
        Assertions.assertEquals((Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Top Compatibility Level Exists");
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
        try {
            this.restApp.restClient.getConfig(subject);
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40408, (int)rce.getErrorCode(), (String)"Compatibility Level doesn't exist");
        }
        Assertions.assertEquals((Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Top Compatibility Level Exists");
    }

    @Test
    public void testListSubjects() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject1 = "test1";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject1);
        String subject2 = "test2";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject2);
        ArrayList<String> expectedResponse = new ArrayList<String>();
        expectedResponse.add(subject1);
        expectedResponse.add(subject2);
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.getAllSubjects(), (String)"Current Subjects");
        ArrayList<Integer> deletedResponse = new ArrayList<Integer>();
        deletedResponse.add(1);
        Assertions.assertEquals(deletedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject2), (String)"Versions Deleted Match");
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.getAllSubjects(), (String)"Current Subjects");
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        expectedResponse.add(subject2);
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.getAllSubjects(true), (String)"Current Subjects");
        Assertions.assertEquals(deletedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, true), (String)"Versions Deleted Match");
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.getAllSubjects(), (String)"Current Subjects");
    }

    @Test
    public void testListSoftDeletedSubjectsAndSchemas() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(3);
        String subject1 = "test1";
        String subject2 = "test2";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(2), 3, subject2);
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject1, "1"));
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"));
        Assertions.assertEquals(Collections.singletonList(2), (Object)this.restApp.restClient.getAllVersions(subject1), (String)"List All Versions Match");
        Assertions.assertEquals(Arrays.asList(1, 2), (Object)this.restApp.restClient.getAllVersions(RestService.DEFAULT_REQUEST_PROPERTIES, subject1, true), (String)"List All Versions Include deleted Match");
        Assertions.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getDeletedOnlyVersions(subject1), (String)"List Deleted Versions Match");
        Assertions.assertEquals(Collections.singletonList(subject1), (Object)this.restApp.restClient.getAllSubjects(), (String)"List All Subjects Match");
        Assertions.assertEquals(Arrays.asList(subject1, subject2), (Object)this.restApp.restClient.getAllSubjects(true), (String)"List All Subjects Include deleted Match");
        Assertions.assertEquals(Collections.singletonList(subject2), (Object)this.restApp.restClient.getDeletedOnlySubjects(null), (String)"List Deleted Only Subjects Match");
    }

    @Test
    public void testDeleteSubjectBasic() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject), (String)"Versions Deleted Match");
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assertions.fail((String)String.format("Subject %s should not be found", subject));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteSubjectException() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject), (String)"Versions Deleted Match");
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assertions.assertEquals((long)1L, (long)schema.getVersion().intValue());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject, true);
        Assertions.assertEquals((long)2L, (long)schema.getVersion().intValue());
        try {
            this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
            Assertions.fail((String)String.format("Subject %s should not be found", subject));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40404, (int)rce.getErrorCode(), (String)"Subject exists in soft deleted format.");
        }
    }

    @Test
    public void testDeleteSubjectPermanent() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        try {
            this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true);
            Assertions.fail((String)"Delete permanent should not succeed");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40405, (int)rce.getErrorCode(), (String)"Subject was not deleted first before permanent delete");
        }
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject), (String)"Versions Deleted Match");
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assertions.assertEquals((long)1L, (long)schema.getVersion().intValue());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject, true);
        Assertions.assertEquals((long)2L, (long)schema.getVersion().intValue());
        Assertions.assertEquals(expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true), (String)"Versions Deleted Match");
        for (Integer i : expectedResponse) {
            try {
                this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
                Assertions.fail((String)String.format("Subject %s should not be found", subject));
            }
            catch (RestClientException rce) {
                Assertions.assertEquals((int)40401, (int)rce.getErrorCode());
            }
            try {
                this.restApp.restClient.lookUpSubjectVersion(schemas.get(i - 1), subject, true);
                Assertions.fail((String)String.format("Subject %s should not be found", subject));
            }
            catch (RestClientException rce) {
                Assertions.assertEquals((int)40401, (int)rce.getErrorCode());
            }
        }
    }

    @Test
    public void testDeleteSubjectAndRegister() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assertions.assertEquals(Arrays.asList(3, 4), (Object)this.restApp.restClient.getAllVersions(subject), (String)"Versions match");
        try {
            this.restApp.restClient.getVersion(subject, 1);
            Assertions.fail((String)"Version 1 should not be found");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40402, (int)rce.getErrorCode(), (String)"Version not found");
        }
    }

    @Test
    public void testSubjectCompatibilityAfterDeletingSubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, null);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
        try {
            this.restApp.restClient.getConfig(subject);
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40408, (int)rce.getErrorCode(), (String)"Compatibility Level doesn't exist");
        }
        Assertions.assertEquals((Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Top Compatibility Level Exists");
    }

    @Test
    public void testGetClusterId() throws Exception {
        try {
            ServerClusterId serverClusterId = this.restApp.restClient.getClusterId();
            Assertions.assertEquals((Object)"", (Object)serverClusterId.getId());
            Assertions.assertEquals(Collections.emptyList(), serverClusterId.getScope().get("path"));
            Assertions.assertNotNull(serverClusterId.getScope().get("clusters"));
        }
        catch (RestClientException rce) {
            Assertions.fail((String)"The operation shouldn't have failed");
        }
    }

    @Test
    public void testGetSchemaRegistryServerVersion() throws Exception {
        SchemaRegistryServerVersion srVersion = this.restApp.restClient.getSchemaRegistryServerVersion();
        Assertions.assertEquals((Object)AppInfoParser.getVersion(), (Object)srVersion.getVersion());
        Assertions.assertEquals((Object)AppInfoParser.getCommitId(), (Object)srVersion.getCommitId());
    }

    @Test
    public void testGetSchemaRegistryServerDeployment() throws Exception {
        SchemaRegistryDeployment srDeployment = this.restApp.restClient.getSchemaRegistryDeployment();
        Assertions.assertEquals((int)0, (int)srDeployment.getAttributes().size(), (String)"Should return empty attributes list by default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpResponseHeaders() throws Exception {
        String baseUrl = this.restApp.restClient.getBaseUrls().current();
        String requestUrl = this.buildRequestUrl(baseUrl, "/v1/metadata/id");
        HttpURLConnection connection = null;
        try {
            URL url = new URL(requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            Map<String, List<String>> httpResponseHeaders = connection.getHeaderFields();
            Assertions.assertNotNull((Object)this.matchHeaderValue(httpResponseHeaders, "X-XSS-Protection", "1; mode=block"));
            Assertions.assertNotNull((Object)this.matchHeaderValue(httpResponseHeaders, "Cache-Control", "no-cache, no-store, must-revalidate"));
            Assertions.assertNull((Object)this.matchHeaderValue(httpResponseHeaders, "Strict-Transport-Security", "max-age=31536000"));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Test
    public void testGlobalMode() throws Exception {
        Assertions.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode().getMode());
        String subject = "testSubject";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        String context = ".";
        try {
            this.restApp.restClient.getMode(subject).getMode();
            Assertions.fail((String)String.format("Subject %s should not be found when there's no mode override", subject));
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)40409, (int)e.getErrorCode(), (String)String.format("No mode override for subject %s, get mode should return not configured", subject));
        }
        Assertions.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode(subject, true).getMode());
        this.restApp.restClient.setMode("READONLY", null);
        this.restApp.restClient.setMode("READWRITE", subject);
        Assertions.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode(subject).getMode());
        this.restApp.restClient.deleteSubjectMode(subject);
        Assertions.assertEquals((Object)"READONLY", (Object)this.restApp.restClient.getMode(subject, true).getMode());
        this.restApp.restClient.setMode("READONLY_OVERRIDE", null);
        Assertions.assertEquals((Object)"READONLY_OVERRIDE", (Object)this.restApp.restClient.getMode(subject).getMode());
        try {
            this.restApp.restClient.registerSchema(schema, "testSubject2");
            Assertions.fail((String)String.format("Subject %s in context %s is in read-only mode", "testSubject2", context));
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42205, (int)rce.getErrorCode(), (String)String.format("Subject %s in context %s is in read-only mode", "testSubject2", context));
        }
    }

    @Test
    public void testRegisterWithAndWithoutMetadata() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Map<String, String> properties = Collections.singletonMap("application.version", "2");
        Metadata metadata = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata);
        int id = this.restApp.restClient.registerSchema(request1, subject, false).getId();
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema1);
        int id2 = this.restApp.restClient.registerSchema(request2, subject, false).getId();
        Assertions.assertEquals((int)id, (int)id2);
    }

    @Test
    public void testRegisterDropsRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Rule r1 = new Rule("foo", null, null, RuleMode.READ, "ENCRYPT", null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(null, rules);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request1, subject, false).getId(), (String)"Registering should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema1, subject);
        Assertions.assertNull((Object)schemaString.getRuleSet());
    }

    @Test
    public void testRegisterSchemaWithReservedFields() throws RestClientException, IOException {
        String subject0 = "testSubject0";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}");
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)Objects.requireNonNull(schema1));
        request1.setMetadata(new Metadata(Collections.emptyMap(), Collections.singletonMap("confluent:reserved", "f"), Collections.emptySet()));
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest();
        configUpdateRequest.setCompatibilityLevel(CompatibilityLevel.BACKWARD.name());
        configUpdateRequest.setValidateFields(Boolean.valueOf(true));
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null), (String)"Updating config should succeed");
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.registerSchema(request1, subject0, false), (String)"Fail registering subject0 because of global validateFields");
        configUpdateRequest.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null), (String)"Updating config should succeed");
        Assertions.assertEquals((int)1, (int)this.restApp.restClient.registerSchema(request1, subject0, false).getId(), (String)"Should register despite reserved fields");
        String subject1 = "testSubject1";
        configUpdateRequest.setValidateFields(Boolean.valueOf(true));
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, subject1), (String)"Updating config should succeed");
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.registerSchema(request1, subject1, false), (String)"Fail registering subject1 because of subject1 validateFields");
        String subject2 = "testSubject2";
        Assertions.assertEquals((int)1, (int)this.restApp.restClient.registerSchema(request1, subject2, false).getId(), (String)"Should register despite reserved fields");
        configUpdateRequest.setValidateFields(Boolean.valueOf(true));
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null), (String)"Updating config should succeed");
        configUpdateRequest.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, subject1), (String)"Updating config should succeed");
        Assertions.assertEquals((int)1, (int)this.restApp.restClient.registerSchema(request1, subject1, false).getId(), (String)"Should register despite reserved fields");
        String subject3 = "testSubject3";
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.registerSchema(request1, subject3, false), (String)"Fail registering because of subject3 validateFields");
        request1.setMetadata(new Metadata(Collections.emptyMap(), Collections.singletonMap("confluent:reserved", "g"), Collections.emptySet()));
        Assertions.assertEquals((int)2, (int)this.restApp.restClient.registerSchema(request1, subject1, false).getId(), (String)"Should register despite removal of reserved fields");
        schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)Objects.requireNonNull(schema1));
        request2.setMetadata(new Metadata(Collections.emptyMap(), Collections.singletonMap("confluent:reserved", "g"), Collections.emptySet()));
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.registerSchema(request2, subject0, false), (String)"Fail registering because of removal of reserved fields");
    }

    @Test
    public void testRegisterSchemaWithInvalidNamespace() throws RestClientException, IOException {
        String subject0 = "testSubject0";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"namespace\":\"a-bad.namespace\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}");
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)Objects.requireNonNull(schema1));
        Assertions.assertThrows(RestClientException.class, () -> this.restApp.restClient.registerSchema(request1, subject0, false), (String)"Fail registering subject0 because of global validateFields");
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest();
        configUpdateRequest.setCompatibilityLevel(CompatibilityLevel.BACKWARD.name());
        configUpdateRequest.setValidateNames(Boolean.valueOf(false));
        Assertions.assertEquals((Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null), (String)"Updating config should succeed");
        Assertions.assertEquals((int)1, (int)this.restApp.restClient.registerSchema(request1, subject0, false).getId(), (String)"Should register despite reserved fields");
    }

    @Test
    public void testInvalidSchema() {
        Assertions.assertThrows(InvalidSchemaException.class, () -> this.restApp.schemaRegistry().parseSchema(null));
    }

    @Test
    public void testConfluentVersion() throws Exception {
        String subject = "test";
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchemaType("AVRO");
        request.setSchema(schemaString);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 1, subject);
        Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 1, subject);
        request.setVersion(Integer.valueOf(2));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "1"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "2"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(3));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)3, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"3", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(3));
        request.setMetadata(null);
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
            Assertions.fail((String)"Registering version that is not next version should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
        request.setVersion(Integer.valueOf(4));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 4, subject);
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)4, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"4", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "-1"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 5, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)5, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"5", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "2"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "3"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "0"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 6, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)6, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"6", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.emptyMap(), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 6, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 7, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)7, (Integer)result.getVersion());
        Assertions.assertNull(result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 8, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)8, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"8", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)7, (Integer)result.getVersion());
        Assertions.assertNull(result.getMetadata().getProperties().get("confluent:version"));
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "7");
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)8, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"8", result.getMetadata().getProperties().get("confluent:version"));
        schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"doc\":\"mydoc\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        request = new RegisterSchemaRequest();
        request.setSchemaType("AVRO");
        request.setSchema(schemaString);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        try {
            this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
            Assertions.fail((String)"Looking up version that is not next version should fail with 40403");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode());
        }
    }

    public static void registerAndVerifySchema(RestService restService, RegisterSchemaRequest request, int expectedId, String subject) throws IOException, RestClientException {
        RegisterSchemaResponse response = restService.registerSchema(request, subject, false);
        Assertions.assertNotNull((Object)response.getVersion());
        int registeredId = response.getId();
        Assertions.assertEquals((long)expectedId, (long)registeredId, (String)"Registering a new schema should succeed");
        Assertions.assertEquals((Object)request.getSchema().trim(), (Object)restService.getId(expectedId).getSchemaString().trim(), (String)"Registered schema should be found");
    }

    @Override
    public Properties getSchemaRegistryProperties() {
        Properties schemaRegistryProps = new Properties();
        schemaRegistryProps.put("response.http.headers.config", "add X-XSS-Protection: 1; mode=block, \"add Cache-Control: no-cache, no-store, must-revalidate\"");
        schemaRegistryProps.put("schema.providers.avro.validate.defaults", "true");
        return schemaRegistryProps;
    }

    private String matchHeaderValue(Map<String, List<String>> responseHeaders, String headerName, String expectedHeaderValue) {
        if (responseHeaders.isEmpty() || responseHeaders.get(headerName) == null) {
            return null;
        }
        return responseHeaders.get(headerName).stream().filter(value -> expectedHeaderValue.equals(value.trim())).findAny().orElse(null);
    }

    private String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }
}

