/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.client;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.client.LocalSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidSchemaException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestOperationNotPermittedException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import io.confluent.rest.exceptions.RestNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocalSchemaRegistryClientTest
extends ClusterTestHarness {
    private SchemaRegistry schemaRegistry;
    private LocalSchemaRegistryClient client;
    private Metadata metadata = new Metadata(null, (Map)new HashMap<String, String>(){
        {
            this.put("key1", "value1");
        }
    }, null);
    private AvroSchema schema1 = new AvroSchema("{\"type\":\"record\",\"name\":\"myrecord1\", \"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}", Collections.emptyList(), new HashMap(), this.metadata, null, Integer.valueOf(2), true);
    private AvroSchema schema2 = new AvroSchema("{\"type\":\"record\",\"name\":\"myrecord2\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
    private static final String SUBJECT1 = ":.context1:subject1";
    private static final String SUBJECT2 = ":.context2:subject2";
    private int id1;
    private int id2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Properties props = new Properties();
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        props.put("ssl.endpoint.identification.algorithm", "");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        this.schemaRegistry = new KafkaSchemaRegistry(config, (Serializer)new SchemaRegistrySerializer());
        this.schemaRegistry.init();
        this.client = new LocalSchemaRegistryClient(this.schemaRegistry);
        this.id1 = this.client.register(SUBJECT1, (ParsedSchema)this.schema1);
        this.id2 = this.client.register(SUBJECT2, (ParsedSchema)this.schema2);
    }

    @Test
    public void testRegister_InvalidVersion() {
        Assertions.assertThrows(RestInvalidSchemaException.class, () -> this.client.register(SUBJECT1, (ParsedSchema)this.schema1, 100, -1));
    }

    @Test
    public void testParseSchema() {
        Schema schema = new Schema(SUBJECT1, Integer.valueOf(-1), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        Optional parsedSchema = this.client.parseSchema(schema);
        Assert.assertTrue((boolean)parsedSchema.isPresent());
        Assert.assertEquals((Object)"AVRO", (Object)((ParsedSchema)parsedSchema.get()).schemaType());
        Assert.assertEquals((Object)"Foo", (Object)((ParsedSchema)parsedSchema.get()).name());
    }

    @Test
    public void testGetSchemas() throws Exception {
        List schemas = this.client.getSchemas(SUBJECT1, false, true);
        Assert.assertNotNull((Object)schemas);
        Assert.assertEquals((long)1L, (long)schemas.size());
        ParsedSchema schema = (ParsedSchema)schemas.get(0);
        Assert.assertEquals((Object)"AVRO", (Object)schema.schemaType());
        Assert.assertEquals((Object)"myrecord1", (Object)schema.name());
        schemas = this.client.getSchemas(":.context1:subject", false, true);
        Assert.assertEquals((long)1L, (long)schemas.size());
        schemas = this.client.getSchemas("subject123", false, true);
        Assert.assertEquals((long)0L, (long)schemas.size());
    }

    @Test
    public void testGetAllVersions() throws Exception {
        List versions = this.client.getAllVersions(SUBJECT1);
        Assert.assertEquals((long)1L, (long)versions.size());
        Assert.assertEquals((long)1L, (long)((Integer)versions.get(0)).intValue());
    }

    @Test
    public void testGetAllVersions_NotFound() {
        Assertions.assertThrows(RestNotFoundException.class, () -> this.client.getAllVersions("subject123"));
    }

    @Test
    public void testGetSchemaBySubjectAndId() throws Exception {
        ParsedSchema s1 = this.client.getSchemaBySubjectAndId(SUBJECT1, this.id1);
        Assert.assertNotNull((Object)s1);
        Assert.assertEquals((Object)"myrecord1", (Object)s1.name());
        Assert.assertEquals((Object)"AVRO", (Object)s1.schemaType());
        Assert.assertEquals((Object)"value1", s1.metadata().getProperties().get("key1"));
        ParsedSchema s2 = this.client.getSchemaBySubjectAndId(SUBJECT2, this.id2);
        Assert.assertNotNull((Object)s2);
        Assert.assertEquals((Object)"myrecord2", (Object)s2.name());
        Assert.assertEquals((Object)"AVRO", (Object)s2.schemaType());
    }

    @Test
    public void testGetSchemaMetadata() throws Exception {
        SchemaMetadata sm = this.client.getSchemaMetadata(SUBJECT1, 1, true);
        Assert.assertNotNull((Object)sm);
        Assert.assertEquals((Object)"AVRO", (Object)sm.getSchemaType());
        Assert.assertEquals((Object)SUBJECT1, (Object)sm.getSubject());
        Assert.assertEquals((long)1L, (long)sm.getVersion());
        Metadata m = sm.getMetadata();
        Assert.assertEquals((long)1L, (long)m.getProperties().size());
        Assert.assertEquals((Object)"value1", m.getProperties().get("key1"));
    }

    @Test
    public void testGetConfig() throws Exception {
        this.client.updateConfig(SUBJECT1, new Config("FULL"));
        Config config = this.client.getConfig(SUBJECT1);
        Assert.assertEquals((Object)"FULL", (Object)config.getCompatibilityLevel());
    }

    @Test
    public void testUpdateConfig() throws Exception {
        Config config = new Config("FULL");
        this.client.updateConfig(SUBJECT1, config);
        Assert.assertEquals((Object)"FULL", (Object)this.client.getConfig(SUBJECT1).getCompatibilityLevel());
    }

    @Test
    public void testDeleteConfig() throws Exception {
        Config config = new Config("FULL");
        this.client.updateConfig(SUBJECT1, config);
        Assert.assertEquals((Object)"FULL", (Object)this.client.getConfig(SUBJECT1).getCompatibilityLevel());
        this.client.deleteConfig(SUBJECT1);
        Assertions.assertThrows(RestNotFoundException.class, () -> this.client.getConfig(SUBJECT1));
    }

    @Test
    public void testSetMode() throws Exception {
        Assert.assertEquals((Object)"READONLY", (Object)this.client.setMode("READONLY", SUBJECT1, false));
        Assert.assertEquals((Object)"READONLY", (Object)this.client.getMode(SUBJECT1));
    }

    @Test
    public void testSetMode_NotPermitted() {
        Assertions.assertThrows(RestOperationNotPermittedException.class, () -> this.client.setMode("IMPORT", SUBJECT1, false));
    }

    @Test
    public void testDeleteSubject() throws Exception {
        List deletedVersions = this.client.deleteSubject(SUBJECT1, false);
        Assert.assertEquals((long)1L, (long)deletedVersions.size());
        Assert.assertEquals((long)1L, (long)((Integer)deletedVersions.get(0)).intValue());
    }

    @Test
    public void testGetVersion() throws Exception {
        Assert.assertEquals((long)1L, (long)this.client.getVersion(SUBJECT1, (ParsedSchema)this.schema1));
        Assert.assertEquals((long)1L, (long)this.client.getVersion(SUBJECT2, (ParsedSchema)this.schema2));
    }

    @Test
    public void testGetByVersion() throws Exception {
        Schema s1 = this.client.getByVersion(SUBJECT1, 1, false);
        Assert.assertEquals((long)this.id1, (long)s1.getId().intValue());
        Schema s2 = this.client.getByVersion(SUBJECT2, 1, false);
        Assert.assertEquals((long)this.id2, (long)s2.getId().intValue());
    }

    @Test
    public void testGetSchemaRegistryDeployment() throws Exception {
        SchemaRegistryDeployment deployment = this.client.getSchemaRegistryDeployment();
        Assert.assertNotNull((Object)deployment);
        Assert.assertEquals((String)"Should return empty attributes list by default", (long)0L, (long)deployment.getAttributes().size());
    }

    @Test
    public void testGetSchemaRegistryServerVersion() throws Exception {
        SchemaRegistryServerVersion version = this.client.getSchemaRegistryServerVersion();
        Assert.assertNotNull((Object)version);
        Assert.assertNotNull((Object)version.getVersion());
        Assert.assertNotNull((Object)version.getCommitId());
    }
}

