/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.annotations.Schema;
import io.confluent.kafka.schemaregistry.annotations.SchemaReference;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiTest
extends ClusterTestHarness {
    private static final Random random = new Random();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public RestApiTest() {
        super(1, true);
    }

    @Override
    public Properties getSchemaRegistryProperties() {
        Properties props = new Properties();
        props.setProperty("schema.providers", JsonSchemaProvider.class.getName());
        return props;
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = RestApiTest.getRandomJsonSchemas(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = RestApiTest.getRandomJsonSchemas(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should return empty");
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, "JSON", Collections.emptyList(), subject1).getId();
            Assertions.assertEquals((int)expectedId, (int)foundId, (String)"Re-registering an existing schema should return the existing version");
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assertions.assertEquals(allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1), (String)"Getting all versions from subject1 should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2), (String)"Getting all versions from subject2 should match all registered versions");
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
    }

    @Test
    public void testSchemaReferences() throws Exception {
        Map<String, String> schemas = RestApiTest.getJsonSchemaWithReferences();
        String subject = "reference";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, schemas.get("ref.json"), 1, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get("main.json"));
        request.setSchemaType("JSON");
        io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference ref = new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("ref.json", "reference", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        int registeredId = this.restApp.restClient.registerSchema(request, "referrer", false).getId();
        Assertions.assertEquals((int)2, (int)registeredId, (String)"Registering a new schema should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(2);
        Assertions.assertEquals((Object)MAPPER.readTree(schemas.get("main.json")), (Object)MAPPER.readTree(schemaString.getSchemaString()), (String)"Registered schema should be found");
        Assertions.assertEquals(Collections.singletonList(ref), (Object)schemaString.getReferences(), (String)"Schema references should be found");
        List refs = this.restApp.restClient.getReferencedBy("reference", 1);
        Assertions.assertEquals((int)2, (int)((Integer)refs.get(0)));
        CachedSchemaRegistryClient schemaRegistryClient = new CachedSchemaRegistryClient(this.restApp.restClient, 10, Collections.singletonList(new JsonSchemaProvider()), new HashMap(), null);
        SchemaHolder holder = new SchemaHolder();
        JsonSchema schema = JsonSchemaUtils.getSchema((Object)holder, (SchemaRegistryClient)schemaRegistryClient);
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "JSON", schema.references(), "referrer", false);
        Assertions.assertEquals((int)2, (int)registeredSchema.getId(), (String)"Registered schema should be found");
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "reference", String.valueOf(1));
            Assertions.fail((String)"Deleting reference should fail with 42206");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42206, (int)rce.getErrorCode(), (String)"Reference found");
        }
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "referrer", "1"));
        refs = this.restApp.restClient.getReferencedBy("reference", 1);
        Assertions.assertTrue((boolean)refs.isEmpty());
        Assertions.assertEquals((Integer)1, (Integer)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, "reference", "1"));
    }

    @Test
    public void testSchemaMissingReferences() throws Exception {
        Assertions.assertThrows(RestClientException.class, () -> {
            Map<String, String> schemas = RestApiTest.getJsonSchemaWithReferences();
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get("main.json"));
            request.setSchemaType("JSON");
            request.setReferences(Collections.emptyList());
            this.restApp.restClient.registerSchema(request, "referrer", false);
        });
    }

    @Test
    public void testSchemaNormalization() throws Exception {
        String subject1 = "testSubject1";
        String reference1 = "{\"type\":\"object\",\"additionalProperties\":false,\"definitions\":{\"ExternalType\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"}},\"additionalProperties\":false}}}";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, reference1, 1, "ref1");
        String reference2 = "{\"type\":\"object\",\"additionalProperties\":false,\"definitions\":{\"ExternalType2\":{\"type\":\"object\",\"properties\":{\"name2\":{\"type\":\"string\"}},\"additionalProperties\":false}}}";
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, reference2, 2, "ref2");
        io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference ref1 = new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("ref1.json", "ref1", Integer.valueOf(1));
        io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference ref2 = new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("ref2.json", "ref2", Integer.valueOf(1));
        String schemaString1 = "{\"$id\": \"https://acme.com/referrer.json\",\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"type\":\"object\",\"properties\":{\"Ref1\": {\"$ref\":\"ref1.json#/definitions/ExternalType\"},\"Ref2\": {\"$ref\":\"ref2.json#/definitions/ExternalType2\"}},\"additionalProperties\":false}";
        String schemaString2 = "{\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"$id\": \"https://acme.com/referrer.json\",\"type\":\"object\",\"properties\":{\"Ref2\": {\"$ref\":\"ref2.json#/definitions/ExternalType2\"},\"Ref1\": {\"$ref\":\"ref1.json#/definitions/ExternalType\"}},\"additionalProperties\":false}";
        RegisterSchemaRequest registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(schemaString1);
        registerRequest.setSchemaType("JSON");
        registerRequest.setReferences(Arrays.asList(ref1, ref2));
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(registerRequest, subject1, true).getId();
        RegisterSchemaRequest lookUpRequest = new RegisterSchemaRequest();
        lookUpRequest.setSchema(schemaString2);
        lookUpRequest.setSchemaType("JSON");
        lookUpRequest.setReferences(Arrays.asList(ref2, ref1));
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSchema1Subject1, (String)"1st schema under subject1 should have version 1");
        Assertions.assertEquals((int)3, (int)idOfRegisteredSchema1Subject1, (String)"1st schema registered globally should have id 3");
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should return empty");
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getBadSchema(), 1, subject1);
            Assertions.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, RestApiTest.getRandomJsonSchemas(1).get(0), Arrays.asList(new io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assertions.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        Assertions.assertEquals(allSubjects, (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
    }

    @Test
    public void testIncompatibleSchema() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"$id\": \"https://acme.com/referrer.json\",\"type\":\"object\",\"properties\":{\"myField1\": {\"type\":\"string\"},\"myField2\": {\"type\":\"number\"}},\"additionalProperties\":false}";
        RegisterSchemaRequest registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(schema1String);
        registerRequest.setSchemaType("JSON");
        String schema2String = "{\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"$id\": \"https://acme.com/referrer.json\",\"type\":\"object\",\"properties\":{\"myField1\": {\"type\":\"string\"},\"myField2\": {\"type\":\"string\"}},\"additionalProperties\":false}";
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, subject);
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(registerRequest, subject, true).getId();
        try {
            registerRequest.setSchema(schema2String);
            registerRequest.setSchemaType("JSON");
            this.restApp.restClient.registerSchema(registerRequest, subject, true);
            Assertions.fail((String)("Registering incompatible schema should fail with " + Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE));
        }
        catch (RestClientException e) {
            Assertions.assertTrue((e.getMessage().length() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)e.getMessage().contains("oldSchemaVersion:"));
            Assertions.assertTrue((boolean)e.getMessage().contains("oldSchema:"));
            Assertions.assertTrue((boolean)e.getMessage().contains("compatibility:"));
        }
        List response = this.restApp.restClient.testCompatibility(registerRequest, subject, String.valueOf(idOfRegisteredSchema1Subject1), false, true);
        Assertions.assertTrue((response.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)response.get(2)).contains("oldSchemaVersion:"));
        Assertions.assertTrue((boolean)((String)response.get(3)).contains("oldSchema:"));
        Assertions.assertTrue((boolean)((String)response.get(4)).contains("compatibility:"));
    }

    @Test
    public void testConfluentVersion() throws Exception {
        String subject = "test";
        String schemaString = "{\"id\":\"urn:jsonschema:com:MySchema\",\"properties\":{\"myEnum\":{\"enum\":[\"YES_VALUE\",\"NO_VALUE\"],\"type\":\"string\"}},\"type\":\"object\"}";
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchemaType("JSON");
        request.setSchema(schemaString);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 1, subject);
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 1, subject);
        request.setVersion(Integer.valueOf(2));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "1"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)1, (Integer)result.getVersion());
        Assertions.assertNull((Object)result.getMetadata());
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "2"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)2, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"2", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(3));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)3, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"3", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(3));
        request.setMetadata(null);
        try {
            RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
            Assertions.fail((String)"Registering version that is not next version should fail with 42201");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode(), (String)"Invalid schema");
        }
        request.setVersion(Integer.valueOf(4));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 4, subject);
        request.setVersion(null);
        request.setMetadata(null);
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)4, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"4", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "-1"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 5, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)5, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"5", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "2"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 2, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "3"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 3, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("confluent:version", "0"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 6, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)6, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"6", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.emptyMap(), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 6, subject);
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 7, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)7, (Integer)result.getVersion());
        Assertions.assertNull(result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(Integer.valueOf(-1));
        request.setMetadata(null);
        RestApiTest.registerAndVerifySchema(this.restApp.restClient, request, 8, subject);
        result = this.restApp.restClient.getLatestVersion(subject);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)8, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"8", result.getMetadata().getProperties().get("confluent:version"));
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)7, (Integer)result.getVersion());
        Assertions.assertNull(result.getMetadata().getProperties().get("confluent:version"));
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "7");
        request.setVersion(null);
        request.setMetadata(new Metadata(null, Collections.singletonMap("mykey", "myvalue"), null));
        result = this.restApp.restClient.lookUpSubjectVersion(request, subject, false, false);
        Assertions.assertEquals((Object)schemaString, (Object)result.getSchema());
        Assertions.assertEquals((Integer)8, (Integer)result.getVersion());
        Assertions.assertEquals((Object)"8", result.getMetadata().getProperties().get("confluent:version"));
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        RestApiTest.registerAndVerifySchema(restService, schemaString, Collections.emptyList(), expectedId, subject);
    }

    public static void registerAndVerifySchema(RestService restService, String schemaString, List<io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference> references, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, "JSON", references, subject).getId();
        Assertions.assertEquals((int)expectedId, (int)registeredId, (String)"Registering a new schema should succeed");
        Assertions.assertEquals((Object)MAPPER.readTree(schemaString), (Object)MAPPER.readTree(restService.getId(expectedId).getSchemaString()), (String)"Registered schema should be found");
    }

    public static void registerAndVerifySchema(RestService restService, RegisterSchemaRequest request, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(request, subject, false).getId();
        Assertions.assertEquals((long)expectedId, (long)registeredId, (String)"Registering a new schema should succeed");
        Assertions.assertEquals((Object)request.getSchema().trim(), (Object)restService.getId(expectedId).getSchemaString().trim(), (String)"Registered schema should be found");
    }

    public static List<String> getRandomJsonSchemas(int num) {
        ArrayList<String> schemas = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            String schema = "{\"type\":\"object\",\"properties\":{\"f" + random.nextInt(Integer.MAX_VALUE) + "\":{\"type\":\"string\"}},\"additionalProperties\":false}";
            schemas.add(schema);
        }
        return schemas;
    }

    public static Map<String, String> getJsonSchemaWithReferences() {
        HashMap<String, String> schemas = new HashMap<String, String>();
        String reference = "{\"type\":\"object\",\"additionalProperties\":false,\"definitions\":{\"ExternalType\":{\"type\":\"object\",\"properties\":{\"name\":{\"type\":\"string\"}},\"additionalProperties\":false}}}";
        schemas.put("ref.json", new JsonSchema(reference).canonicalString());
        String schemaString = "{\"$id\": \"https://acme.com/referrer.json\",\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"type\":\"object\",\"properties\":{\"Ref\":{\"$ref\":\"ref.json#/definitions/ExternalType\"}},\"additionalProperties\":false}";
        schemas.put("main.json", schemaString);
        return schemas;
    }

    public static String getBadSchema() {
        String schema = "{\"type\":\"bad-object\",\"properties\":{\"f" + random.nextInt(Integer.MAX_VALUE) + "\":{\"type\":\"string\"}},\"additionalProperties\":false}";
        return schema;
    }

    @Schema(value="{\"$id\": \"https://acme.com/referrer.json\",\"$schema\": \"http://json-schema.org/draft-07/schema#\",\"type\":\"object\",\"properties\":{\"Ref\":{\"$ref\":\"ref.json#/definitions/ExternalType\"}},\"additionalProperties\":false}", refs={@SchemaReference(name="ref.json", subject="reference")})
    static class SchemaHolder {
        SchemaHolder() {
        }
    }
}

