/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.ExtendedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.AbstractSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfigException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaSchemaRegistryTest
extends ClusterTestHarness {
    private SchemaRegistryConfig config;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String listeners = "http://localhost:123, https://localhost:456";
        Properties props = new Properties();
        props.setProperty("port", "123");
        props.setProperty("listeners", listeners);
        props.put("kafkastore.bootstrap.servers", this.brokerList);
        props.put("kafkastore.topic", "_schemas");
        this.config = new SchemaRegistryConfig(props);
    }

    @Test
    public void testGetPortForIdentityPrecedence() throws SchemaRegistryException, RestConfigException {
        String listeners = "http://localhost:456";
        Properties props = new Properties();
        props.setProperty("port", "123");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = AbstractSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"http");
        Assertions.assertEquals((int)456, (int)listener.getUri().getPort(), (String)"Expected listeners to take precedence over port.");
        Assertions.assertEquals((Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetPortForIdentityNoListeners() throws SchemaRegistryException, RestConfigException {
        String listeners = "";
        Properties props = new Properties();
        props.setProperty("port", "123");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = AbstractSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"http");
        Assertions.assertEquals((int)123, (int)listener.getUri().getPort(), (String)"Expected port to take the configured port value");
        Assertions.assertEquals((Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetPortForIdentityMultipleListenersWithHttps() throws SchemaRegistryException, RestConfigException {
        String listeners = "http://localhost:123, https://localhost:456";
        Properties props = new Properties();
        props.setProperty("port", "-1");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = AbstractSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"https");
        Assertions.assertEquals((int)456, (int)listener.getUri().getPort(), (String)"Expected HTTPS listener's port to be returned");
        Assertions.assertEquals((Object)"https", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetPortForIdentityMultipleListeners() throws SchemaRegistryException, RestConfigException {
        String listeners = "http://localhost:123, http://localhost:456";
        Properties props = new Properties();
        props.setProperty("port", "-1");
        props.setProperty("listeners", listeners);
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = AbstractSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)"", (String)"http");
        Assertions.assertEquals((int)456, (int)listener.getUri().getPort(), (String)"Expected last listener's port to be returned");
        Assertions.assertEquals((Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testGetNamedInternalListener() throws SchemaRegistryException, RestConfigException {
        String listeners = "bob://localhost:123, http://localhost:456";
        String listenerProtocolMap = "bob:http";
        Properties props = new Properties();
        props.setProperty("port", "-1");
        props.setProperty("listeners", listeners);
        props.setProperty("listener.protocol.map", listenerProtocolMap);
        props.setProperty("inter.instance.listener.name", "bob");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        NamedURI listener = AbstractSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)config.interInstanceListenerName(), (String)"http");
        Assertions.assertEquals((int)123, (int)listener.getUri().getPort());
        Assertions.assertEquals((Object)"bob", (Object)listener.getName());
        Assertions.assertEquals((Object)"http", (Object)listener.getUri().getScheme());
    }

    @Test
    public void testMyIdentityWithoutPortOverride() throws RestConfigException, SchemaRegistryException {
        String listeners = "bob://localhost:123, http://localhost:456";
        String listenerProtocolMap = "bob:https";
        Properties props = new Properties();
        props.setProperty("host.name", "schema.registry-0.example.com");
        props.setProperty("listeners", listeners);
        props.setProperty("listener.protocol.map", listenerProtocolMap);
        props.setProperty("inter.instance.listener.name", "bob");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        SchemaRegistryIdentity schemaRegistryIdentity = new SchemaRegistryIdentity("schema.registry-0.example.com", Integer.valueOf(123), Boolean.valueOf(true), "https");
        NamedURI internalListener = AbstractSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)config.interInstanceListenerName(), (String)"http");
        Assertions.assertEquals((Object)schemaRegistryIdentity, (Object)KafkaSchemaRegistry.getMyIdentity((NamedURI)internalListener, (boolean)true, (SchemaRegistryConfig)config));
    }

    @Test
    public void testMyIdentityWithPortOverride() throws RestConfigException, SchemaRegistryException {
        String listeners = "bob://localhost:123, http://localhost:456";
        String listenerProtocolMap = "bob:https";
        Properties props = new Properties();
        props.setProperty("host.name", "schema.registry-0.example.com");
        props.setProperty("host.port", "443");
        props.setProperty("listeners", listeners);
        props.setProperty("listener.protocol.map", listenerProtocolMap);
        props.setProperty("inter.instance.listener.name", "bob");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        SchemaRegistryIdentity schemaRegistryIdentity = new SchemaRegistryIdentity("schema.registry-0.example.com", Integer.valueOf(443), Boolean.valueOf(true), "https");
        NamedURI internalListener = AbstractSchemaRegistry.getInterInstanceListener((List)config.getListeners(), (String)config.interInstanceListenerName(), (String)"http");
        Assertions.assertEquals((Object)schemaRegistryIdentity, (Object)KafkaSchemaRegistry.getMyIdentity((NamedURI)internalListener, (boolean)true, (SchemaRegistryConfig)config));
    }

    @Test
    public void testRegister() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        Schema expected = new Schema("subject1", Integer.valueOf(-1), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        Schema actual = kafkaSchemaRegistry.register("subject1", expected);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Schema schema = kafkaSchemaRegistry.get("subject1", 1, false);
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testGet() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        Schema expected = new Schema("subject1", Integer.valueOf(-1), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        kafkaSchemaRegistry.register("subject1", expected);
        Schema schema = kafkaSchemaRegistry.get("subject1", 1, false);
        Assertions.assertEquals((Object)expected, (Object)schema);
        schema = kafkaSchemaRegistry.get("subject1", -1, false);
        Assertions.assertEquals((Object)expected, (Object)schema);
        schema = kafkaSchemaRegistry.get("subject1", 2, false);
        Assertions.assertNull((Object)schema);
        schema = kafkaSchemaRegistry.get("subject2", 1, false);
        Assertions.assertNull((Object)schema);
    }

    @Test
    public void testDeleteSchema() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        ConfigUpdateRequest globalConfigUpdateRequest = new ConfigUpdateRequest();
        globalConfigUpdateRequest.setCompatibilityLevel("FORWARD");
        kafkaSchemaRegistry.updateConfig(null, globalConfigUpdateRequest);
        Assertions.assertEquals((Object)"FORWARD", (Object)kafkaSchemaRegistry.getConfig(null).getCompatibilityLevel());
        kafkaSchemaRegistry.setMode(null, new ModeUpdateRequest(Mode.READONLY.name()));
        Assertions.assertEquals((Object)Mode.READONLY, (Object)kafkaSchemaRegistry.getMode(null));
        Schema expected1 = new Schema("subject1", Integer.valueOf(-1), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        Schema expected2 = new Schema("subject1", Integer.valueOf(-1), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(2));
        kafkaSchemaRegistry.setMode("subject1", new ModeUpdateRequest(Mode.READWRITE.name()));
        Assertions.assertEquals((Object)Mode.READWRITE, (Object)kafkaSchemaRegistry.getMode("subject1"));
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest();
        configUpdateRequest.setCompatibilityLevel("FULL");
        kafkaSchemaRegistry.updateConfig("subject1", configUpdateRequest);
        Assertions.assertEquals((Object)"FULL", (Object)kafkaSchemaRegistry.getConfig("subject1").getCompatibilityLevel());
        kafkaSchemaRegistry.register("subject1", expected1);
        kafkaSchemaRegistry.register("subject1", expected2);
        Schema schema1 = kafkaSchemaRegistry.get("subject1", 1, false);
        Assertions.assertEquals((Object)expected1, (Object)schema1);
        Schema schema2 = kafkaSchemaRegistry.get("subject1", 2, false);
        Assertions.assertEquals((Object)expected2, (Object)schema2);
        kafkaSchemaRegistry.deleteSchemaVersion("subject1", schema1, false);
        Assertions.assertNull((Object)kafkaSchemaRegistry.get("subject1", 1, false));
        Assertions.assertEquals((Object)expected1, (Object)kafkaSchemaRegistry.get("subject1", 1, true));
        Assertions.assertEquals((Object)Mode.READWRITE, (Object)kafkaSchemaRegistry.getMode("subject1"));
        Assertions.assertEquals((Object)"FULL", (Object)kafkaSchemaRegistry.getConfig("subject1").getCompatibilityLevel());
        kafkaSchemaRegistry.deleteSchemaVersion("subject1", schema1, true);
        Assertions.assertNull((Object)kafkaSchemaRegistry.get("subject1", 1, true));
        Assertions.assertEquals((Object)Mode.READWRITE, (Object)kafkaSchemaRegistry.getMode("subject1"));
        Assertions.assertEquals((Object)"FULL", (Object)kafkaSchemaRegistry.getConfig("subject1").getCompatibilityLevel());
        kafkaSchemaRegistry.deleteSchemaVersion("subject1", schema2, false);
        Assertions.assertNull((Object)kafkaSchemaRegistry.get("subject1", 2, false));
        Assertions.assertEquals((Object)expected2, (Object)kafkaSchemaRegistry.get("subject1", 2, true));
        Assertions.assertEquals((Object)Mode.READWRITE, (Object)kafkaSchemaRegistry.getMode("subject1"));
        Assertions.assertEquals((Object)"FULL", (Object)kafkaSchemaRegistry.getConfig("subject1").getCompatibilityLevel());
        kafkaSchemaRegistry.deleteSchemaVersion("subject1", schema2, true);
        Assertions.assertNull((Object)kafkaSchemaRegistry.get("subject1", 2, true));
        Assertions.assertNull((Object)kafkaSchemaRegistry.getMode("subject1"));
        Assertions.assertNull((Object)kafkaSchemaRegistry.getConfig("subject1"));
        Assertions.assertEquals((Object)Mode.READONLY, (Object)kafkaSchemaRegistry.getMode(null));
        Assertions.assertEquals((Object)"FORWARD", (Object)kafkaSchemaRegistry.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testDeleteSubject() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        ConfigUpdateRequest globalConfigUpdateRequest = new ConfigUpdateRequest();
        globalConfigUpdateRequest.setCompatibilityLevel("FORWARD");
        kafkaSchemaRegistry.updateConfig(null, globalConfigUpdateRequest);
        Assertions.assertEquals((Object)"FORWARD", (Object)kafkaSchemaRegistry.getConfig(null).getCompatibilityLevel());
        kafkaSchemaRegistry.setMode(null, new ModeUpdateRequest(Mode.READONLY.name()));
        Assertions.assertEquals((Object)Mode.READONLY, (Object)kafkaSchemaRegistry.getMode(null));
        Schema expected = new Schema("subject1", Integer.valueOf(-1), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        kafkaSchemaRegistry.setMode("subject1", new ModeUpdateRequest(Mode.READWRITE.name()));
        Assertions.assertEquals((Object)Mode.READWRITE, (Object)kafkaSchemaRegistry.getMode("subject1"));
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest();
        configUpdateRequest.setCompatibilityLevel("FULL");
        kafkaSchemaRegistry.updateConfig("subject1", configUpdateRequest);
        Assertions.assertEquals((Object)"FULL", (Object)kafkaSchemaRegistry.getConfig("subject1").getCompatibilityLevel());
        kafkaSchemaRegistry.register("subject1", expected);
        Schema schema = kafkaSchemaRegistry.get("subject1", 1, false);
        Assertions.assertEquals((Object)expected, (Object)schema);
        kafkaSchemaRegistry.deleteSubject("subject1", false);
        Set subjects = kafkaSchemaRegistry.subjects("subject1", false);
        Assertions.assertEquals((int)0, (int)subjects.size());
        subjects = kafkaSchemaRegistry.subjects("subject1", true);
        Assertions.assertEquals((int)1, (int)subjects.size());
        Assertions.assertEquals((Object)"subject1", (Object)subjects.toArray()[0]);
        Assertions.assertEquals((Object)Mode.READWRITE, (Object)kafkaSchemaRegistry.getMode("subject1"));
        Assertions.assertEquals((Object)"FULL", (Object)kafkaSchemaRegistry.getConfig("subject1").getCompatibilityLevel());
        kafkaSchemaRegistry.deleteSubject("subject1", true);
        subjects = kafkaSchemaRegistry.subjects("subject1", true);
        Assertions.assertEquals((int)0, (int)subjects.size());
        Assertions.assertNull((Object)kafkaSchemaRegistry.getMode("subject1"));
        Assertions.assertNull((Object)kafkaSchemaRegistry.getConfig("subject1"));
        Assertions.assertEquals((Object)Mode.READONLY, (Object)kafkaSchemaRegistry.getMode(null));
        Assertions.assertEquals((Object)"FORWARD", (Object)kafkaSchemaRegistry.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testGetByVersion() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        Schema schema1 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        kafkaSchemaRegistry.register("subject1", schema1);
        Schema actual = kafkaSchemaRegistry.getByVersion("subject1", 1, false);
        Assertions.assertEquals((Object)schema1, (Object)actual);
        actual = kafkaSchemaRegistry.getByVersion("subject1", 2, false);
        Assertions.assertNull((Object)actual);
        Schema schema2 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        kafkaSchemaRegistry.register("subject1", schema2);
        actual = kafkaSchemaRegistry.getByVersion("subject1", 2, false);
        Assertions.assertNull((Object)actual);
        Schema schema3 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(2));
        kafkaSchemaRegistry.register("subject1", schema3);
        actual = kafkaSchemaRegistry.getByVersion("subject1", 2, false);
        Assertions.assertEquals((Object)schema3, (Object)actual);
        Iterator itr = kafkaSchemaRegistry.getAllVersions("subject1", LookupFilter.DEFAULT);
        Assertions.assertEquals((int)1, (int)((SchemaKey)itr.next()).getVersion());
        Assertions.assertEquals((int)2, (int)((SchemaKey)itr.next()).getVersion());
        Assertions.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testSetMode() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        kafkaSchemaRegistry.setMode("subject1", new ModeUpdateRequest(Mode.IMPORT.name()));
        Assertions.assertEquals((Object)Mode.IMPORT, (Object)kafkaSchemaRegistry.getMode("subject1"));
        Assertions.assertEquals((Object)Mode.IMPORT, (Object)kafkaSchemaRegistry.getModeInScope("subject1"));
        Assertions.assertNull((Object)kafkaSchemaRegistry.getMode("subject2"));
        kafkaSchemaRegistry.setModeOrForward("subject1", new ModeUpdateRequest(Mode.READONLY.name()), true, new HashMap());
        Assertions.assertEquals((Object)Mode.READONLY, (Object)kafkaSchemaRegistry.getMode("subject1"));
    }

    @Test
    public void testDeleteMode() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        kafkaSchemaRegistry.setMode("subject1", new ModeUpdateRequest(Mode.READONLY.name()));
        Assertions.assertEquals((Object)Mode.READONLY, (Object)kafkaSchemaRegistry.getMode("subject1"));
        kafkaSchemaRegistry.deleteSubjectMode("subject1");
        Assertions.assertNull((Object)kafkaSchemaRegistry.getMode("subject1"));
    }

    @Test
    public void testGetVersionsWithSubjectPrefix() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        Iterator itr = kafkaSchemaRegistry.getVersionsWithSubjectPrefix("subject1", true, LookupFilter.DEFAULT, false, schema -> true);
        Assertions.assertFalse((boolean)itr.hasNext());
        Schema schema1 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        kafkaSchemaRegistry.register("subject1", schema1);
        itr = kafkaSchemaRegistry.getVersionsWithSubjectPrefix("subject1", true, LookupFilter.DEFAULT, false, schema -> true);
        Assertions.assertTrue((boolean)itr.hasNext());
        ExtendedSchema es = (ExtendedSchema)itr.next();
        Assertions.assertEquals((Object)schema1.getSchema(), (Object)es.getSchema());
        Assertions.assertFalse((boolean)itr.hasNext());
        itr = kafkaSchemaRegistry.getVersionsWithSubjectPrefix("subject2", true, LookupFilter.DEFAULT, false, schema -> true);
        Assertions.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testIsCompatible() throws SchemaRegistryException {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        Schema schema1 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(1));
        kafkaSchemaRegistry.register("subject1", schema1);
        Schema schema2 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(2));
        ArrayList<SchemaKey> list = new ArrayList<SchemaKey>();
        list.add(new SchemaKey("subject1", 1));
        List errors = kafkaSchemaRegistry.isCompatible("subject1", schema2, list, true);
        Assertions.assertTrue((boolean)errors.isEmpty());
        kafkaSchemaRegistry.register("subject1", schema2);
        list.add(new SchemaKey("subject1", 2));
        Schema schema3 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(2));
        errors = kafkaSchemaRegistry.isCompatible("subject1", schema3, list, true);
        Assertions.assertTrue((boolean)errors.isEmpty());
        Schema schema4 = new Schema("subject1", Integer.valueOf(0), Integer.valueOf(-1), "AVRO", Collections.emptyList(), StoreUtils.avroSchemaString(2).replace("Foo", "Bar"));
        errors = kafkaSchemaRegistry.isCompatible("subject1", schema4, list, true);
        Assertions.assertFalse((boolean)errors.isEmpty());
    }

    @Test
    public void testLeaderRestServiceIsForwardIsTrue() throws Exception {
        KafkaSchemaRegistry kafkaSchemaRegistry = new KafkaSchemaRegistry(this.config, (Serializer)new SchemaRegistrySerializer());
        kafkaSchemaRegistry.init();
        SchemaRegistryIdentity leaderIdentity = new SchemaRegistryIdentity("test-host", Integer.valueOf(8081), Boolean.valueOf(true), "http");
        kafkaSchemaRegistry.setLeader(leaderIdentity);
        RestService leaderRestService = kafkaSchemaRegistry.leaderRestService();
        Assertions.assertNotNull((Object)leaderRestService, (String)"Leader rest service should not be null");
        Assertions.assertTrue((boolean)leaderRestService.isForward(), (String)"isForward should be true for leaderRestService");
    }
}

