/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.OffsetCheckpoint;
import io.confluent.kafka.schemaregistry.storage.OffsetCheckpointReadOnly;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class OffsetCheckpointTest {
    private final String topic = "topic";

    @Test
    public void testReadWrite() throws IOException {
        try (OffsetCheckpoint checkpoint = new OffsetCheckpoint("/tmp", 0, "topic");){
            HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
            offsets.put(new TopicPartition("topic", 0), 0L);
            offsets.put(new TopicPartition("topic", 1), 1L);
            offsets.put(new TopicPartition("topic", 2), 2L);
            checkpoint.write(offsets);
            Assert.assertEquals(offsets, (Object)checkpoint.read());
            checkpoint.delete();
            Assert.assertFalse((boolean)new File("/tmp", ".checkpoint").exists());
            offsets.put(new TopicPartition("topic", 3), 3L);
            checkpoint.write(offsets);
            Assert.assertEquals(offsets, (Object)checkpoint.read());
            checkpoint.delete();
        }
    }

    @Test
    public void shouldNotWriteCheckpointWhenNoOffsets() throws IOException {
        try (OffsetCheckpoint checkpoint = new OffsetCheckpoint("/tmp", 0, "topic");){
            checkpoint.write(Collections.emptyMap());
            Assert.assertFalse((boolean)new File("/tmp", ".checkpoint").exists());
            Assert.assertEquals(Collections.emptyMap(), (Object)checkpoint.read());
            checkpoint.delete();
        }
    }

    @Test
    public void testReadOnly() throws Exception {
        try (OffsetCheckpoint checkpoint = new OffsetCheckpoint("/tmp", 0, "topic");){
            HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
            offsets.put(new TopicPartition("topic", 0), 0L);
            offsets.put(new TopicPartition("topic", 1), 1L);
            offsets.put(new TopicPartition("topic", 2), 2L);
            checkpoint.write(offsets);
            Assert.assertEquals(offsets, (Object)checkpoint.read());
            try (OffsetCheckpointReadOnly checkpointReadOnly = new OffsetCheckpointReadOnly("/tmp", 0, "topic");){
                Assert.assertEquals(offsets, (Object)checkpointReadOnly.read());
                Assert.assertThrows(UnsupportedOperationException.class, () -> checkpointReadOnly.write(offsets));
            }
            checkpoint.delete();
        }
    }
}

