/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.storage.KafkaStoreMessageHandler;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.Metadata;
import io.confluent.kafka.schemaregistry.storage.Rule;
import io.confluent.kafka.schemaregistry.storage.RuleKind;
import io.confluent.kafka.schemaregistry.storage.RuleMode;
import io.confluent.kafka.schemaregistry.storage.RuleSet;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SchemaValuesTest {
    @Test
    public void testSchemaValueDeserializeForMagicByte0() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(0);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\"}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        this.assertSchemaValue(subject, version, 1, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1067572235\",\"type\":\"string\"}]}", "AVRO", false, schemaValue);
    }

    @Test
    public void testSchemaValueDeserializeForMagicByte1WithDeleteFlagFalse() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(1);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":false}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        this.assertSchemaValue(subject, version, 1, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1067572235\",\"type\":\"string\"}]}", "AVRO", false, schemaValue);
    }

    @Test
    public void testSchemaValueDeserializeForMagicByte1WithDeleteFlagTrue() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(1);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":true}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        this.assertSchemaValue(subject, version, 1, "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"name\":\"f1067572235\",\"type\":\"string\"}]}", "AVRO", true, schemaValue);
    }

    @Test
    public void testSchemaValueDeserializeForUnSupportedMagicByte() {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(2);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":true}";
        try {
            serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
            Assert.fail((String)"Deserialization shouldn't be supported");
        }
        catch (SerializationException e) {
            Assert.assertEquals((Object)"Can't deserialize schema for the magic byte 2", (Object)e.getMessage());
        }
    }

    @Test
    public void testSchemaValueDeserializeForOffsetTimestamp() throws SerializationException {
        String subject = "test";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(1);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        String schemaValueJson = "{\"subject\":\"test\",\"version\":1,\"id\":1,\"schema\":\"{\\\"type\\\":\\\"record\\\",\\\"name\\\":\\\"myrecord\\\",\\\"fields\\\":[{\\\"name\\\":\\\"f1067572235\\\",\\\"type\\\":\\\"string\\\"}]}\",\"deleted\":true,\"offset\":1,\"ts\":123}";
        SchemaValue schemaValue = (SchemaValue)serializer.deserializeValue((Object)key, schemaValueJson.getBytes());
        Assert.assertEquals((long)1L, (long)schemaValue.getOffset());
        Assert.assertEquals((long)123L, (long)schemaValue.getTimestamp());
    }

    @Test
    public void testSchemaValueCanonicalize() {
        String oldSchema = "syntax = \"proto3\";\npackage com.mycorp.mynamespace;\n\n// Test Comment.\r\nmessage value {\n  int32 myField1 = 1;\n}\n";
        String newSchema = "syntax = \"proto3\";\npackage com.mycorp.mynamespace;\n\nmessage value {\n  int32 myField1 = 1;\n}\n";
        SchemaValue schemaValue = new SchemaValue("sub", Integer.valueOf(1), Integer.valueOf(0), "PROTOBUF", null, oldSchema, false);
        KafkaStoreMessageHandler.canonicalize((SchemaProvider)new ProtobufSchemaProvider(), (SchemaValue)schemaValue);
        Assert.assertEquals((Object)newSchema, (Object)schemaValue.getSchema());
    }

    @Test
    public void testSchemaValueMD5() {
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"default\":null,\"name\":\"f\"}]}";
        SchemaValue schema = new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(1), "AVRO", null, schemaString, false);
        MD5 md5 = new MD5(new byte[]{29, 32, -53, -71, -27, -29, 94, -105, 84, -25, -38, 23, 11, 110, 93, -37});
        Assert.assertEquals((String)"MD5 hash should be equal", (Object)md5, (Object)MD5.ofSchema((Schema)schema.toSchemaEntity()));
        Metadata metadata = new Metadata(null, null, null);
        List<Rule> domainRules = Collections.singletonList(new Rule(null, null, RuleKind.TRANSFORM, RuleMode.WRITEREAD, null, null, null, null, null, null, false));
        RuleSet ruleSet = new RuleSet(domainRules, null, null);
        schema = new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(1), null, "AVRO", null, metadata, ruleSet, schemaString, false);
        md5 = new MD5(new byte[]{22, -15, -20, -91, -21, -7, 34, -77, -38, -128, 33, 47, -113, -89, 52, 46});
        Assert.assertEquals((String)"MD5 hash should be equal", (Object)md5, (Object)MD5.ofSchema((Schema)schema.toSchemaEntity()));
    }

    @Test
    public void testSchemaValueComplexMD5() {
        String schemaString = "{\n  \"type\": \"record\",\n  \"name\": \"Complex\",\n  \"namespace\": \"io.confluent.avro\",\n  \"fields\": [\n    {\n      \"name\": \"int8\",\n      \"type\": {\n        \"type\": \"int\",\n        \"connect.doc\": \"int8 field\",\n        \"connect.default\": 2,\n        \"connect.type\": \"int8\"\n      },\n      \"default\": 2\n    },\n    {\n      \"name\": \"int16\",\n      \"type\": {\n        \"type\": \"int\",\n        \"connect.type\": \"int16\"\n      }\n    },\n    {\n      \"name\": \"int32\",\n      \"type\": \"int\"\n    },\n    {\n      \"name\": \"int64\",\n      \"type\": \"long\"\n    },\n    {\n      \"name\": \"float32\",\n      \"type\": \"float\"\n    },\n    {\n      \"name\": \"float64\",\n      \"type\": \"double\"\n    },\n    {\n      \"name\": \"boolean\",\n      \"type\": \"boolean\"\n    },\n    {\n      \"name\": \"string\",\n      \"type\": \"string\"\n    },\n    {\n      \"name\": \"bytes\",\n      \"type\": \"bytes\"\n    },\n    {\n      \"name\": \"array\",\n      \"type\": {\n        \"type\": \"array\",\n        \"items\": \"string\"\n      }\n    },\n    {\n      \"name\": \"map\",\n      \"type\": {\n        \"type\": \"map\",\n        \"values\": \"int\"\n      }\n    },\n    {\n      \"name\": \"mapNonStringKeys\",\n      \"type\": {\n        \"type\": \"array\",\n        \"items\": {\n          \"type\": \"record\",\n          \"name\": \"MapEntry\",\n          \"fields\": [\n            {\n              \"name\": \"key\",\n              \"type\": \"int\"\n            },\n            {\n              \"name\": \"value\",\n              \"type\": \"int\"\n            }\n          ]\n        }\n      }\n    }\n  ]\n}\n";
        SchemaValue schema = new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(1), "AVRO", null, schemaString, false);
        MD5 md5 = MD5.fromString((String)"c4ad6448-4d68-34d2-c8cf-7443afc25d54");
        Assert.assertEquals((String)"MD5 hash should be equal", (Object)md5, (Object)MD5.ofSchema((Schema)schema.toSchemaEntity()));
    }

    @Test
    public void testSchemaValueComplexProtobufMD5() {
        String schemaString = "syntax = \"proto3\";\n\nmessage Complex {\n  int32 int32 = 1;\n  int64 int64 = 2;\n  float float32 = 3;\n  double float64 = 4;\n  bool boolean = 5;\n  string string = 6;\n  bytes bytes = 7;\n  repeated string array = 8;\n  repeated ComplexEntry map = 9;\n\n  message ComplexEntry {\n    string key = 1;\n    int32 value = 2;\n  }\n}\n";
        SchemaValue schema = new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(1), "PROTOBUF", null, schemaString, false);
        MD5 md5 = MD5.fromString((String)"d49cbf63-d35b-ba54-e1f7-0bdd51528a37");
        Assert.assertEquals((String)"MD5 hash should be equal", (Object)md5, (Object)MD5.ofSchema((Schema)schema.toSchemaEntity()));
    }

    @Test
    public void testSchemaValueComplexJsonMD5() {
        String schemaString = "\n  \"type\": \"object\",\n  \"properties\": {\n    \"boolean\": {\n      \"connect.index\": 6,\n      \"type\": \"boolean\"\n    },\n    \"string\": {\n      \"type\": \"string\",\n      \"connect.index\": 7\n    },\n    \"int32\": {\n      \"type\": \"integer\",\n      \"connect.index\": 2,\n      \"connect.type\": \"int32\"\n    },\n    \"array\": {\n      \"type\": \"array\",\n      \"connect.index\": 9,\n      \"items\": {\n        \"type\": \"string\"\n      }\n    },\n    \"int64\": {\n      \"type\": \"integer\",\n      \"connect.index\": 3,\n      \"connect.type\": \"int64\"\n    },\n    \"bytes\": {\n      \"type\": \"string\",\n      \"connect.index\": 8,\n      \"connect.type\": \"bytes\"\n    },\n\"int8\": {\n      \"type\": \"integer\",\n      \"connect.index\": 0,\n      \"connect.type\": \"int8\"\n    },\n    \"float32\": {\n      \"type\": \"number\",\n      \"connect.index\": 4,\n      \"connect.type\": \"float32\"\n    },\n    \"float64\": {\n      \"type\": \"number\",\n      \"connect.index\": 5,\n      \"connect.type\": \"float64\"\n    },\n    \"map\": {\n      \"type\": \"object\",\n      \"connect.index\": 10,\n      \"connect.type\": \"map\",\n      \"additionalProperties\": {\n        \"type\": \"integer\",\n        \"connect.type\": \"int32\"\n      }\n    },\n    \"int16\": {\n      \"type\": \"integer\",\n      \"connect.index\": 1,\n      \"connect.type\": \"int16\"\n    }\n  }\n}\n";
        SchemaValue schema = new SchemaValue("subject", Integer.valueOf(1), Integer.valueOf(1), "JSON", null, schemaString, false);
        MD5 md5 = MD5.fromString((String)"ae6f9592-621e-546e-45b2-dfb7ca884c15");
        Assert.assertEquals((String)"MD5 hash should be equal", (Object)md5, (Object)MD5.ofSchema((Schema)schema.toSchemaEntity()));
    }

    private void assertSchemaValue(String subject, int version, int schemaId, String schema, String type, boolean deleted, SchemaValue schemaValue) {
        Assert.assertNotNull((String)"Not Null", (Object)schemaValue);
        Assert.assertEquals((String)"Subject Matches", (Object)subject, (Object)schemaValue.getSubject());
        Assert.assertEquals((String)"Version matches", (Object)version, (Object)schemaValue.getVersion());
        Assert.assertEquals((String)"SchemaId matches", (Object)schemaId, (Object)schemaValue.getId());
        Assert.assertEquals((String)"Schema Matches", (Object)schema, (Object)schemaValue.getSchema());
        Assert.assertEquals((String)"Type matches", (Object)type, (Object)schemaValue.getSchemaType());
        Assert.assertEquals((String)"Delete Flag Matches", (Object)deleted, (Object)schemaValue.isDeleted());
    }
}

