/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;

public class JsonErrorHandler
extends ErrorHandler {
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String method = request.getMethod();
        if (!(HttpMethod.GET.is(method) || HttpMethod.POST.is(method) || HttpMethod.PUT.is(method) || HttpMethod.HEAD.is(method))) {
            callback.succeeded();
            return true;
        }
        return super.handle(request, response, callback);
    }

    protected boolean generateAcceptableResponse(Request request, Response response, Callback callback, String contentType, List<Charset> charsets, int code, String message, Throwable cause) throws IOException {
        return super.generateAcceptableResponse(request, response, callback, MimeTypes.Type.APPLICATION_JSON.asString(), charsets, code, message, cause);
    }

    protected void writeErrorJson(Request request, PrintWriter writer, int code, String message, Throwable cause, boolean showStacks) {
        String error = message == null ? HttpStatus.getMessage((int)code) : message;
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectNode root = factory.objectNode();
        root.put("error_code", code);
        root.put("message", error);
        writer.write(root.toString());
    }
}

