/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.client;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ExtendedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.exceptions.IdDoesNotMatchException;
import io.confluent.kafka.schemaregistry.exceptions.IncompatibleSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.ReferenceExistsException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaVersionNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.exceptions.SubjectNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidCompatibilityException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidModeException;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.AppInfoParser;
import io.confluent.kafka.schemaregistry.utils.Props;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(LocalSchemaRegistryClient.class);
    private final SchemaRegistry schemaRegistry;
    private final Map<String, SchemaProvider> providers;

    public LocalSchemaRegistryClient(SchemaRegistry schemaRegistry) {
        this(schemaRegistry, null);
    }

    public LocalSchemaRegistryClient(SchemaRegistry schemaRegistry, List<SchemaProvider> providers) {
        this.schemaRegistry = schemaRegistry;
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(p -> p.schemaType(), p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, LocalSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, LocalSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
    }

    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider;
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("No provider found for schema type {}", (Object)schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    public Optional<ParsedSchema> parseSchema(Schema schema) {
        SchemaProvider schemaProvider;
        String schemaType = schema.getSchemaType();
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("No provider found for schema type {}", (Object)schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schema, false);
    }

    public synchronized List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        Iterator<SchemaKey> resultSchemas = null;
        ArrayList<Integer> allVersions = new ArrayList<Integer>();
        String errorMessage = "Error while validating that subject " + (String)subject + " exists in the registry";
        try {
            if (!this.schemaRegistry.hasSubjects((String)subject, false)) {
                throw Errors.subjectNotFoundException((String)subject);
            }
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        errorMessage = "Error while listing all versions for subject " + (String)subject;
        try {
            resultSchemas = this.schemaRegistry.getAllVersions((String)subject, LookupFilter.DEFAULT);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        while (resultSchemas.hasNext()) {
            SchemaKey schema = resultSchemas.next();
            allVersions.add(schema.getVersion());
        }
        return allVersions;
    }

    public synchronized int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, false);
    }

    public synchronized int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize, false).getId();
    }

    public synchronized int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, version, id, false, false).getId();
    }

    public synchronized RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, boolean normalize, boolean propagateSchemaTags) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize, propagateSchemaTags);
    }

    private synchronized RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, int version, int id, boolean normalize, boolean propagateSchemaTags) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        Schema s = new Schema((String)subject, Integer.valueOf(version), Integer.valueOf(id), schema);
        try {
            return new RegisterSchemaResponse(this.schemaRegistry.register((String)subject, s, normalize, propagateSchemaTags));
        }
        catch (IdDoesNotMatchException e) {
            throw Errors.idDoesNotMatchException(e);
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Register operation timed out", e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Register schema operation failed while writing to the Kafka store", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding register schema request to the leader", e);
        }
        catch (IncompatibleSchemaException e) {
            throw Errors.incompatibleSchemaException("Schema being registered is incompatible with an earlier schema for subject \"" + (String)subject + "\"", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Leader not known.", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while registering schema", e);
        }
    }

    public synchronized ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public synchronized ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        SchemaString s = null;
        String errorMessage = "Error while retrieving schema with id " + id + " from the schema registry";
        try {
            s = this.schemaRegistry.get(id, (String)subject);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (s == null) {
            throw Errors.schemaNotFoundException(id);
        }
        return this.parseSchema(new Schema(null, null, null, s)).get();
    }

    public synchronized ParsedSchema getSchemaByGuid(String guid, String format) throws IOException, RestClientException {
        SchemaString s = null;
        String errorMessage = "Error while retrieving schema with guid " + guid + " from the schema registry";
        try {
            s = this.schemaRegistry.getByGuid(guid, format);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (s == null) {
            throw Errors.schemaNotFoundException(guid);
        }
        return this.parseSchema(new Schema(null, null, null, s)).get();
    }

    public synchronized List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subjectPrefix = this.schemaRegistry.tenant() + "_" + (String)subjectPrefix;
        }
        Iterator<ExtendedSchema> schemas = null;
        ArrayList<ParsedSchema> result = new ArrayList<ParsedSchema>();
        String errorMessage = "Error while getting schemas for prefix " + (String)subjectPrefix;
        try {
            schemas = this.schemaRegistry.getVersionsWithSubjectPrefix((String)subjectPrefix, false, lookupDeletedSchema ? LookupFilter.INCLUDE_DELETED : LookupFilter.DEFAULT, latestOnly, null);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        while (schemas.hasNext()) {
            Schema s = (Schema)schemas.next();
            result.add(this.parseSchema(s).get());
        }
        return result;
    }

    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        try {
            SchemaMetadata schema = this.getSchemaMetadata(subject, version, lookupDeletedSchema);
            return new Schema(subject, schema);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        return this.getSchemaMetadata(subject, version, false);
    }

    public synchronized SchemaMetadata getSchemaMetadata(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        VersionId versionId = null;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        Schema s = null;
        String errorMessage = "Error while retrieving schema for subject " + (String)subject + " with version " + version + " from the schema registry";
        try {
            s = this.schemaRegistry.get((String)subject, versionId.getVersionId(), lookupDeletedSchema);
            if (s == null) {
                if (!this.schemaRegistry.hasSubjects((String)subject, true)) {
                    throw Errors.subjectNotFoundException((String)subject);
                }
                throw Errors.versionNotFoundException(versionId.getVersionId());
            }
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        return new SchemaMetadata(s);
    }

    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        return this.getSchemaMetadata(subject, -1);
    }

    public synchronized int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getVersion(subject, schema, false);
    }

    public synchronized int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponse(subject, schema, normalize).getVersion();
    }

    public boolean testCompatibility(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public List<String> testCompatibilityVerbose(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public Config updateConfig(String subject, Config config) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        CompatibilityLevel compatibilityLevel = CompatibilityLevel.forName((String)config.getCompatibilityLevel());
        if (config.getCompatibilityLevel() != null && compatibilityLevel == null) {
            throw new RestInvalidCompatibilityException();
        }
        try {
            return this.schemaRegistry.updateConfig((String)subject, new ConfigUpdateRequest(config));
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to update compatibility level", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to update compatibility level", e);
        }
    }

    public Config getConfig(String subject) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        try {
            Config config = this.schemaRegistry.getConfig((String)subject);
            if (config == null) {
                throw Errors.subjectLevelCompatibilityNotConfiguredException((String)subject);
            }
            return config;
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to get the configs for subject " + (String)subject, e);
        }
    }

    public void deleteConfig(String subject) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        try {
            this.schemaRegistry.deleteSubjectConfig((String)subject);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to get the configs for subject " + (String)subject, e);
        }
    }

    public String setMode(String mode) throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public String setMode(String mode, String subject) throws IOException, RestClientException {
        return this.setMode(mode, subject, false);
    }

    public String setMode(String mode, String subject, boolean force) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        try {
            if (mode != null) {
                Enum.valueOf(Mode.class, mode.toUpperCase(Locale.ROOT));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RestInvalidModeException();
        }
        try {
            ModeUpdateRequest request = new ModeUpdateRequest(Optional.ofNullable(mode));
            this.schemaRegistry.setMode((String)subject, request, force);
        }
        catch (ReferenceExistsException e) {
            throw Errors.referenceExistsException(e.getMessage());
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to update mode", e);
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Update mode operation timed out", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while updating the mode", e);
        }
        return mode;
    }

    public String getMode() throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public String getMode(String subject) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        try {
            Mode mode = this.schemaRegistry.getMode((String)subject);
            if (mode == null) {
                throw Errors.subjectLevelModeNotConfiguredException((String)subject);
            }
            return mode.name();
        }
        catch (SchemaRegistryException e) {
            throw Errors.storeException("Failed to get mode", e);
        }
    }

    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        throw new UnsupportedOperationException();
    }

    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getId(subject, schema, false);
    }

    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponse(subject, schema, normalize).getId();
    }

    public String getGuid(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getGuid(subject, schema, false);
    }

    public String getGuid(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponse(subject, schema, normalize).getGuid();
    }

    public RegisterSchemaResponse getIdWithResponse(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        Schema s = new Schema((String)subject, Integer.valueOf(0), Integer.valueOf(-1), schema);
        Schema matchingSchema = null;
        try {
            if (!this.schemaRegistry.hasSubjects((String)subject, false)) {
                throw Errors.subjectNotFoundException((String)subject);
            }
            matchingSchema = this.schemaRegistry.lookUpSchemaUnderSubject((String)subject, s, normalize, false);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while looking up schema under subject " + (String)subject, e);
        }
        if (matchingSchema == null) {
            throw Errors.schemaNotFoundException();
        }
        return new RegisterSchemaResponse(matchingSchema);
    }

    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        return this.deleteSubject(null, (String)subject, isPermanent);
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        try {
            if (!this.schemaRegistry.hasSubjects((String)subject, true)) {
                throw Errors.subjectNotFoundException((String)subject);
            }
            if (!isPermanent && !this.schemaRegistry.hasSubjects((String)subject, false)) {
                throw Errors.subjectSoftDeletedException((String)subject);
            }
            return this.schemaRegistry.deleteSubject((String)subject, isPermanent);
        }
        catch (ReferenceExistsException e) {
            throw Errors.referenceExistsException(e.getMessage());
        }
        catch (SubjectNotSoftDeletedException e) {
            throw Errors.subjectNotSoftDeletedException((String)subject);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting the subject " + (String)subject, e);
        }
    }

    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(null, subject, version, isPermanent);
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        if (!"default".equals(this.schemaRegistry.tenant())) {
            subject = this.schemaRegistry.tenant() + "_" + (String)subject;
        }
        VersionId versionId = null;
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        Schema schema = null;
        String errorMessage = "Error while retrieving schema for subject " + (String)subject + " with version " + version + " from the schema registry";
        try {
            if (this.schemaRegistry.schemaVersionExists((String)subject, versionId, true) && !isPermanent && !this.schemaRegistry.schemaVersionExists((String)subject, versionId, false)) {
                throw Errors.schemaVersionSoftDeletedException((String)subject, version);
            }
            schema = this.schemaRegistry.get((String)subject, versionId.getVersionId(), true);
            if (schema == null) {
                if (!this.schemaRegistry.hasSubjects((String)subject, true)) {
                    throw Errors.subjectNotFoundException((String)subject);
                }
                throw Errors.versionNotFoundException(versionId.getVersionId());
            }
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        try {
            this.schemaRegistry.deleteSchemaVersion((String)subject, schema, isPermanent);
        }
        catch (SchemaVersionNotSoftDeletedException e) {
            throw Errors.schemaVersionNotSoftDeletedException(e.getSubject(), e.getVersion());
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Delete Schema Version operation timed out", e);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Delete Schema Version operation failed while writing to the Kafka store", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete schema version request to the leader", e);
        }
        catch (ReferenceExistsException e) {
            throw Errors.referenceExistsException(e.getMessage());
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Leader not known.", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting Schema Version", e);
        }
        return schema.getVersion();
    }

    public SchemaRegistryDeployment getSchemaRegistryDeployment() throws IOException, RestClientException {
        return Props.getSchemaRegistryDeployment(this.schemaRegistry.properties());
    }

    public SchemaRegistryServerVersion getSchemaRegistryServerVersion() throws IOException, RestClientException {
        return new SchemaRegistryServerVersion(AppInfoParser.getVersion(), AppInfoParser.getCommitId());
    }

    public void reset() {
    }
}

